/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.jsr310.deser;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import tools.jackson.dataformat.avro.jsr310.deser.AvroJavaTimeDeserializerBase;

public class AvroInstantDeserializer<T extends Temporal>
extends AvroJavaTimeDeserializerBase<T> {
    public static final AvroInstantDeserializer<Instant> INSTANT = new AvroInstantDeserializer<Instant>(Instant.class, (instant, zoneID) -> instant);
    public static final AvroInstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new AvroInstantDeserializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::ofInstant);
    public static final AvroInstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new AvroInstantDeserializer<ZonedDateTime>(ZonedDateTime.class, ZonedDateTime::ofInstant);
    protected final BiFunction<Instant, ZoneId, T> fromInstant;

    protected AvroInstantDeserializer(Class<T> supportedType, BiFunction<Instant, ZoneId, T> fromInstant) {
        super(supportedType);
        this.fromInstant = fromInstant;
    }

    @Override
    protected T fromLong(long longValue, ZoneId defaultZoneId) {
        return (T)((Temporal)this.fromInstant.apply(Instant.ofEpochMilli(longValue), defaultZoneId));
    }
}

