/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.io.IOException;
import java.util.List;
import tools.jackson.core.JsonToken;
import tools.jackson.dataformat.avro.deser.ArrayReader;
import tools.jackson.dataformat.avro.deser.AvroFieldReader;
import tools.jackson.dataformat.avro.deser.AvroParserImpl;
import tools.jackson.dataformat.avro.deser.AvroReadContext;
import tools.jackson.dataformat.avro.deser.MapReader;

public class StructDefaults {
    public static AvroFieldReader createObjectDefaults(String name, List<AvroFieldReader> fieldReaders) {
        return AvroFieldReader.construct(name, new ObjectDefaults(null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    public static AvroFieldReader createArrayDefaults(String name, List<AvroFieldReader> fieldReaders) {
        return AvroFieldReader.construct(name, new ArrayDefaults(null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    protected static class ObjectDefaults
    extends MapReader {
        protected final AvroFieldReader[] _fieldReaders;

        public ObjectDefaults(AvroReadContext parent, AvroParserImpl parser, AvroFieldReader[] fieldReaders) {
            super(parent, parser, null, null, null);
            this._fieldReaders = fieldReaders;
        }

        @Override
        public long getRemainingElements() {
            return this._fieldReaders.length - this._index;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser) {
            return new ObjectDefaults(parent, parser, this._fieldReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._fieldReaders.length) {
                        this._state = 2;
                        this._currentName = this._fieldReaders[this._index].getName();
                        this._currToken = JsonToken.PROPERTY_NAME;
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    this._state = 4;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    this._state = 1;
                    AvroFieldReader r = this._fieldReaders[this._index++];
                    this._currToken = r.readValue(this, this._parser);
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
        }
    }

    protected static class ArrayDefaults
    extends ArrayReader {
        protected final AvroFieldReader[] _valueReaders;

        public ArrayDefaults(AvroReadContext parent, AvroParserImpl parser, AvroFieldReader[] valueReaders) {
            super(parent, parser, null, null);
            this._valueReaders = valueReaders;
        }

        @Override
        public ArrayReader newReader(AvroReadContext parent, AvroParserImpl parser) {
            return new ArrayDefaults(parent, parser, this._valueReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._valueReaders.length) {
                        AvroFieldReader r = this._valueReaders[this._index++];
                        this._currToken = r.readValue(this, this._parser);
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    this._state = 3;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
        }
    }
}

