/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.core.JacksonException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static void rethrowIfFatal(Throwable throwable) throws Error, RuntimeException {
        if (ExceptionUtil.isFatal(throwable)) {
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static <ERR extends Throwable> ERR rethrowIfNoWrap(DeserializationContext ctxt, ERR e) {
        if (e instanceof Error) {
            Error err = (Error)e;
            throw err;
        }
        if (e instanceof JacksonException) {
            JacksonException je = (JacksonException)e;
            throw je;
        }
        if (ctxt != null && !ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS) && e instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)e;
            throw re;
        }
        return e;
    }

    private static boolean isFatal(Throwable throwable) {
        return throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath || throwable instanceof InterruptedException || throwable instanceof ClassCircularityError || throwable instanceof ClassFormatError || throwable instanceof IncompatibleClassChangeError || throwable instanceof BootstrapMethodError || throwable instanceof VerifyError;
    }
}

