/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonInclude;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdDynamicSerializer;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;
import tools.jackson.databind.util.NameTransformer;

public abstract class ReferenceTypeSerializer<T>
extends StdDynamicSerializer<T> {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final JavaType _referredType;
    protected final NameTransformer _unwrapper;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public ReferenceTypeSerializer(ReferenceType fullType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> ser) {
        super(fullType, null, vts, ser);
        this._referredType = fullType.getReferencedType();
        this._unwrapper = null;
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    protected ReferenceTypeSerializer(ReferenceTypeSerializer<?> base, BeanProperty property, TypeSerializer vts, ValueSerializer<?> valueSer, NameTransformer unwrapper, Object suppressableValue, boolean suppressNulls) {
        super(base, property, vts, valueSer);
        this._referredType = base._referredType;
        this._unwrapper = unwrapper;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    @Override
    public ValueSerializer<T> unwrappingSerializer(NameTransformer transformer) {
        NameTransformer unwrapper;
        ValueSerializer valueSer = this._valueSerializer;
        if (valueSer != null && (valueSer = valueSer.unwrappingSerializer(transformer)) == this._valueSerializer) {
            return this;
        }
        NameTransformer nameTransformer = unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer(transformer, this._unwrapper);
        if (this._valueSerializer == valueSer && this._unwrapper == unwrapper) {
            return this;
        }
        return this.withResolved(this._property, this._valueTypeSerializer, valueSer, unwrapper);
    }

    protected abstract ReferenceTypeSerializer<T> withResolved(BeanProperty var1, TypeSerializer var2, ValueSerializer<?> var3, NameTransformer var4);

    public abstract ReferenceTypeSerializer<T> withContentInclusion(Object var1, boolean var2);

    protected abstract boolean _isValuePresent(T var1);

    protected abstract Object _getReferenced(T var1);

    protected abstract Object _getReferencedIfPresent(T var1);

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        JsonInclude.Value inclV;
        ValueSerializer<Object> ser;
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(ctxt, property);
        }
        if ((ser = this.findAnnotatedContentSerializer(ctxt, property)) == null) {
            ser = this._valueSerializer;
            if (ser == null) {
                if (typeSer == null && this._useStatic(ctxt, property, this._referredType)) {
                    ser = this._findSerializer(ctxt, this._referredType, property);
                }
            } else {
                ser = ctxt.handlePrimaryContextualization(ser, property);
            }
        }
        ser = this.findContextualConvertingSerializer(ctxt, property, ser);
        ReferenceTypeSerializer<T> refSer = this._property == property && this._valueTypeSerializer == typeSer && this._valueSerializer == ser ? this : this.withResolved(property, typeSer, ser, this._unwrapper);
        if (property != null && (inclV = property.findPropertyInclusion(ctxt.getConfig(), this.handledType())) != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            boolean suppressNulls;
            Object valueToSuppress;
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, this._referredType);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = this._referredType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
            if (this._suppressableValue != valueToSuppress || this._suppressNulls != suppressNulls) {
                refSer = refSer.withContentInclusion(valueToSuppress, suppressNulls);
            }
        }
        return refSer;
    }

    protected boolean _useStatic(SerializationContext serializers, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping(serializers.getConfig(), property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return serializers.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, T value) throws JacksonException {
        if (!this._isValuePresent(value)) {
            return true;
        }
        Object contents = this._getReferenced(value);
        if (contents == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(ctxt, contents.getClass());
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return ser.isEmpty(ctxt, contents);
        }
        return this._suppressableValue.equals(contents);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public JavaType getReferredType() {
        return this._referredType;
    }

    @Override
    public void serialize(T ref, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        Object value = this._getReferencedIfPresent(ref);
        if (value == null) {
            if (this._unwrapper == null) {
                ctxt.defaultSerializeNullValue(g);
            }
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(ctxt, value.getClass());
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, g, ctxt, this._valueTypeSerializer);
        } else {
            ser.serialize(value, g, ctxt);
        }
    }

    @Override
    public void serializeWithType(T ref, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        Object value = this._getReferencedIfPresent(ref);
        if (value == null) {
            if (this._unwrapper == null) {
                ctxt.defaultSerializeNullValue(g);
            }
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(ctxt, value.getClass());
        }
        ser.serializeWithType(value, g, ctxt, typeSer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getContext(), this._referredType, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    private final ValueSerializer<Object> _findCachedSerializer(SerializationContext ctxt, Class<?> rawType) {
        ValueSerializer<Object> ser = this._dynamicValueSerializers.serializerFor(rawType);
        if (ser == null) {
            if (this._referredType.hasGenericTypes()) {
                JavaType fullType = ctxt.constructSpecializedType(this._referredType, rawType);
                ser = ctxt.findPrimaryPropertySerializer(fullType, this._property);
            } else {
                ser = ctxt.findPrimaryPropertySerializer(rawType, this._property);
            }
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicValueSerializers = this._dynamicValueSerializers.newWith(rawType, ser);
        }
        return ser;
    }

    private final ValueSerializer<Object> _findSerializer(SerializationContext ctxt, JavaType type, BeanProperty prop) {
        return ctxt.findPrimaryPropertySerializer(type, prop);
    }
}

