/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.Collection;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.StaticListSerializerBase;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>> {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();

    protected StringCollectionSerializer() {
        super(Collection.class, String.class);
    }

    @Deprecated
    protected StringCollectionSerializer(StringCollectionSerializer src, Boolean unwrapSingle) {
        this(src, unwrapSingle, (Object)null, false);
    }

    protected StringCollectionSerializer(StringCollectionSerializer src, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    @Deprecated
    public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringCollectionSerializer(this, unwrapSingle, (Object)null, false);
    }

    @Override
    public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new StringCollectionSerializer(this, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            if (ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS) && (this._suppressableValue != null || this._suppressNulls)) {
                this.serializeFilteredContents(value, g, ctxt);
            } else {
                this.serializeContents(value, g, ctxt);
            }
            return;
        }
        g.writeStartArray(value, len);
        if (ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS) && (this._suppressableValue != null || this._suppressNulls)) {
            this.serializeFilteredContents(value, g, ctxt);
        } else {
            this.serializeContents(value, g, ctxt);
        }
        g.writeEndArray();
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        this.serializeContents(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        this.serializeContentsImpl(value, g, ctxt, false);
    }

    private final void serializeFilteredContents(Collection<String> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        this.serializeContentsImpl(value, g, ctxt, ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS));
    }

    private final void serializeContentsImpl(Collection<String> value, JsonGenerator g, SerializationContext ctxt, boolean filtered) throws JacksonException {
        int i = 0;
        try {
            for (String str : value) {
                if (str == null) {
                    if (filtered && this._suppressNulls) {
                        ++i;
                        continue;
                    }
                    ctxt.defaultSerializeNullValue(g);
                } else {
                    if (filtered && !this._shouldSerializeElement(str, null, ctxt)) {
                        ++i;
                        continue;
                    }
                    g.writeString(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }
}

