/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.ArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]> {
    protected static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    private static final JavaType VALUE_TYPE = TypeFactory.unsafeSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final ValueSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, ValueSerializer<?> ser, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src, prop, unwrapSingle, suppressableValue, suppressNulls);
        this._elementSerializer = ser;
    }

    public StringArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new StringArraySerializer(this, prop, this._elementSerializer, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        ValueSerializer<Object> ser = null;
        if (property != null) {
            AnnotationIntrospector ai = ctxt.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = ctxt.serializerInstance(m, ai.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, String[].class, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null) {
            ser = ctxt.findContentValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        JsonInclude.Value inclV = this.findIncludeOverrides(ctxt, property, this.handledType());
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (inclV != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, VALUE_TYPE);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        return new StringArraySerializer(this, property, ser, unwrapSingle, valueToSuppress, suppressNulls);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializationContext prov, String[] value) {
        return value.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value) {
        return value.length == 1;
    }

    @Override
    public final void serialize(String[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.length;
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g, ctxt);
            return;
        }
        g.writeStartArray((Object)value, len);
        this.serializeContents(value, g, ctxt);
        g.writeEndArray();
    }

    @Override
    public void serializeContents(String[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value, g, ctxt, this._elementSerializer);
            return;
        }
        boolean filtered = this._needToCheckFiltering(ctxt);
        for (int i = 0; i < len; ++i) {
            String str = value[i];
            if (str == null) {
                if (filtered && this._suppressNulls) continue;
                g.writeNull();
                continue;
            }
            if (filtered && !this._shouldSerializeElement(ctxt, str, null)) continue;
            g.writeString(str);
        }
    }

    private void serializeContentsSlow(String[] value, JsonGenerator g, SerializationContext ctxt, ValueSerializer<Object> ser) throws JacksonException {
        boolean filtered = this._needToCheckFiltering(ctxt);
        for (String str : value) {
            if (str == null) {
                if (filtered && this._suppressNulls) continue;
                ctxt.defaultSerializeNullValue(g);
                continue;
            }
            if (filtered && !this._shouldSerializeElement(ctxt, str, ser)) continue;
            ser.serialize(str, g, ctxt);
        }
    }

    protected boolean _shouldSerializeElement(SerializationContext ctxt, String elem, ValueSerializer<Object> serializer) {
        if (this._suppressableValue == null) {
            return true;
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            if (serializer != null) {
                return !serializer.isEmpty(ctxt, elem);
            }
            return !elem.isEmpty();
        }
        return !this._suppressableValue.equals(elem);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.STRING);
    }
}

