/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.ArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.BeanUtil;

@JacksonStdImpl
public class ObjectArraySerializer
extends ArraySerializerBase<Object[]> {
    protected static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected final TypeSerializer _valueTypeSerializer;
    protected ValueSerializer<Object> _elementSerializer;

    public ObjectArraySerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> elementSerializer) {
        super(Object[].class);
        this._elementType = elemType;
        this._staticTyping = staticTyping;
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
    }

    public ObjectArraySerializer(ObjectArraySerializer src, TypeSerializer vts) {
        super(src);
        this._elementType = src._elementType;
        this._valueTypeSerializer = vts;
        this._staticTyping = src._staticTyping;
        this._elementSerializer = src._elementSerializer;
    }

    @Deprecated
    public ObjectArraySerializer(ObjectArraySerializer src, BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        this(src, property, vts, elementSerializer, unwrapSingle, null, false);
    }

    public ObjectArraySerializer(ObjectArraySerializer src, BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src, property, unwrapSingle, suppressableValue, suppressNulls);
        this._elementType = src._elementType;
        this._valueTypeSerializer = vts;
        this._staticTyping = src._staticTyping;
        this._elementSerializer = elementSerializer;
    }

    public ObjectArraySerializer _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new ObjectArraySerializer(this, prop, this._valueTypeSerializer, this._elementSerializer, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new ObjectArraySerializer(this._elementType, this._staticTyping, vts, this._elementSerializer);
    }

    protected ObjectArraySerializer _withResolved(BeanProperty prop, TypeSerializer vts, ValueSerializer<?> elementSer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        if (this._property == prop && this._valueTypeSerializer == vts && this._elementSerializer == elementSer && Objects.equals(this._unwrapSingle, unwrapSingle) && Objects.equals(this._suppressableValue, suppressableValue) && this._suppressNulls == suppressNulls) {
            return this;
        }
        return new ObjectArraySerializer(this, prop, vts, elementSer, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        JsonInclude.Include incl;
        JsonFormat.Value format;
        TypeSerializer vts = this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(ctxt, property);
        }
        ValueSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            AnnotatedMember m = property.getMember();
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            if (m != null) {
                ser = ctxt.serializerInstance(m, intr.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        if ((format = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null && this._elementType != null && this._staticTyping && !this._elementType.isJavaLangObject()) {
            ser = ctxt.findContentValueSerializer(this._elementType, property);
        }
        JsonInclude.Value inclV = this.findIncludeOverrides(ctxt, property, this.handledType());
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (inclV != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.propertyDefaultValue(ctxt, this._elementType);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        return this._withResolved(property, vts, ser, unwrapSingle, valueToSuppress, suppressNulls);
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Object[] value) {
        return value.length == 0;
    }

    @Override
    public boolean hasSingleElement(Object[] value) {
        return value.length == 1;
    }

    @Override
    public final void serialize(Object[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.length;
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g, ctxt);
            return;
        }
        g.writeStartArray((Object)value, len);
        this.serializeContents(value, g, ctxt);
        g.writeEndArray();
    }

    @Override
    public void serializeContents(Object[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value, g, ctxt, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(value, g, ctxt);
            return;
        }
        boolean filtered = this._needToCheckFiltering(ctxt);
        Object elem = null;
        try {
            for (i = 0; i < len; ++i) {
                elem = value[i];
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = this._dynamicValueSerializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, serializer)) continue;
                serializer.serialize(elem, g, ctxt);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, elem, i);
        }
    }

    public void serializeContentsUsing(Object[] value, JsonGenerator g, SerializationContext ctxt, ValueSerializer<Object> ser) throws JacksonException {
        int i;
        int len = value.length;
        TypeSerializer typeSer = this._valueTypeSerializer;
        boolean filtered = this._needToCheckFiltering(ctxt);
        Object elem = null;
        try {
            for (i = 0; i < len; ++i) {
                elem = value[i];
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, ser)) continue;
                if (typeSer == null) {
                    ser.serialize(elem, g, ctxt);
                    continue;
                }
                ser.serializeWithType(elem, g, ctxt, typeSer);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, elem, i);
        }
    }

    public void serializeTypedContents(Object[] value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        int len = value.length;
        TypeSerializer typeSer = this._valueTypeSerializer;
        boolean filtered = this._needToCheckFiltering(ctxt);
        Object elem = null;
        try {
            for (i = 0; i < len; ++i) {
                elem = value[i];
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = this._dynamicValueSerializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._findAndAddDynamic(ctxt, cc);
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, serializer)) continue;
                serializer.serializeWithType(elem, g, ctxt, typeSer);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, elem, i);
        }
    }

    protected boolean _shouldSerializeElement(SerializationContext ctxt, Object elem, ValueSerializer<Object> serializer) {
        if (this._suppressableValue == null) {
            return true;
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            if (serializer != null) {
                return !serializer.isEmpty(ctxt, elem);
            }
            if (elem instanceof String) {
                String str = (String)elem;
                return !str.isEmpty();
            }
            return true;
        }
        return !this._suppressableValue.equals(elem);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor arrayVisitor = visitor.expectArrayFormat(typeHint);
        if (arrayVisitor != null) {
            JavaType contentType = this._elementType;
            ValueSerializer<Object> valueSer = this._elementSerializer;
            if (valueSer == null) {
                valueSer = visitor.getContext().findContentValueSerializer(contentType, this._property);
            }
            arrayVisitor.itemsFormat(valueSer, contentType);
        }
    }
}

