/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.io.ByteArrayOutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.ser.jackson.TokenBufferSerializer;
import tools.jackson.databind.ser.jdk.UUIDSerializer;
import tools.jackson.databind.ser.std.NullSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.util.TokenBuffer;

public class JDKMiscSerializers {
    public static final ValueSerializer<?> find(Class<?> raw) {
        if (raw == UUID.class) {
            return new UUIDSerializer();
        }
        if (raw == AtomicBoolean.class) {
            return new AtomicBooleanSerializer();
        }
        if (raw == AtomicInteger.class) {
            return new AtomicIntegerSerializer();
        }
        if (raw == AtomicLong.class) {
            return new AtomicLongSerializer();
        }
        if (raw == TokenBuffer.class) {
            return new TokenBufferSerializer();
        }
        if (raw == Void.class || raw == Void.TYPE) {
            return NullSerializer.instance;
        }
        if (ByteArrayOutputStream.class.isAssignableFrom(raw)) {
            return new ByteArrayOutputStreamSerializer();
        }
        return null;
    }

    public static class AtomicBooleanSerializer
    extends StdScalarSerializer<AtomicBoolean> {
        public AtomicBooleanSerializer() {
            super(AtomicBoolean.class, false);
        }

        @Override
        public void serialize(AtomicBoolean value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
            gen.writeBoolean(value.get());
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            visitor.expectBooleanFormat(typeHint);
        }
    }

    public static class AtomicIntegerSerializer
    extends StdScalarSerializer<AtomicInteger> {
        public AtomicIntegerSerializer() {
            super(AtomicInteger.class, false);
        }

        @Override
        public void serialize(AtomicInteger value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
            gen.writeNumber(value.get());
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }
    }

    public static class AtomicLongSerializer
    extends StdScalarSerializer<AtomicLong> {
        public AtomicLongSerializer() {
            super(AtomicLong.class, false);
        }

        @Override
        public void serialize(AtomicLong value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
            gen.writeNumber(value.get());
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG);
        }
    }

    public static class ByteArrayOutputStreamSerializer
    extends StdScalarSerializer<ByteArrayOutputStream> {
        public ByteArrayOutputStreamSerializer() {
            super(ByteArrayOutputStream.class, false);
        }

        @Override
        public void serialize(ByteArrayOutputStream value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
            gen.writeBinary(value.toByteArray());
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.acceptJsonFormatVisitorForBinary(visitor, typeHint);
        }
    }
}

