/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.Iterator;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.AsArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;

@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase<Iterable<?>> {
    public IterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        super(Iterable.class, elemType, staticTyping, vts, null);
    }

    @Deprecated
    public IterableSerializer(IterableSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        this(src, vts, valueSerializer, unwrapSingle, property, (Object)null, false);
    }

    public IterableSerializer(IterableSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property, Object suppressableValue, boolean suppressNulls) {
        super(src, vts, valueSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
    }

    @Override
    protected StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IterableSerializer(this, vts, this._elementSerializer, this._unwrapSingle, this._property, this._suppressableValue, this._suppressNulls);
    }

    public IterableSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new IterableSerializer(this, vts, elementSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Iterable<?> value) {
        return !value.iterator().hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterable<?> value) {
        Iterator<?> it;
        if (value != null && (it = value.iterator()).hasNext()) {
            it.next();
            if (!it.hasNext()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void serialize(Iterable<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if ((this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE) && this.hasSingleElement(value)) {
            this.serializeContents(value, g, ctxt);
            return;
        }
        g.writeStartArray(value);
        this.serializeContents(value, g, ctxt);
        g.writeEndArray();
    }

    @Override
    public void serializeContents(Iterable<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        boolean needsFiltering = this._needToCheckFiltering(ctxt);
        Iterator<?> it = value.iterator();
        if (it.hasNext()) {
            TypeSerializer typeSer = this._valueTypeSerializer;
            do {
                Class<?> cc;
                Object elem;
                if ((elem = it.next()) == null) {
                    if (needsFiltering && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                ValueSerializer<Object> serializer = this._elementSerializer;
                if (serializer == null && (serializer = this._dynamicValueSerializers.serializerFor(cc = elem.getClass())) == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                }
                if (needsFiltering && !this._shouldSerializeElement(ctxt, elem, this._elementSerializer)) continue;
                if (typeSer == null) {
                    serializer.serialize(elem, g, ctxt);
                    continue;
                }
                serializer.serializeWithType(elem, g, ctxt, typeSer);
            } while (it.hasNext());
        }
    }
}

