/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.StaticListSerializerBase;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>> {
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();

    protected IndexedStringListSerializer() {
        super(List.class, String.class);
    }

    @Deprecated
    public IndexedStringListSerializer(IndexedStringListSerializer src, Boolean unwrapSingle) {
        this(src, unwrapSingle, src._suppressableValue, src._suppressNulls);
    }

    public IndexedStringListSerializer(IndexedStringListSerializer src, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        super(src, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    @Deprecated
    public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new IndexedStringListSerializer(this, unwrapSingle, (Object)null, false);
    }

    @Override
    public ValueSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new IndexedStringListSerializer(this, unwrapSingle, suppressableValue, suppressNulls);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(List<String> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            if (this._needToCheckFiltering(ctxt)) {
                this.serializeContentsFiltered(value, g, ctxt, 1);
            } else {
                this.serializeContentsNonFiltered(value, g, ctxt, 1);
            }
            return;
        }
        g.writeStartArray(value, len);
        if (this._needToCheckFiltering(ctxt)) {
            this.serializeContentsFiltered(value, g, ctxt, len);
        } else {
            this.serializeContentsNonFiltered(value, g, ctxt, len);
        }
        g.writeEndArray();
    }

    @Override
    public void serializeWithType(List<String> value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        if (this._needToCheckFiltering(ctxt)) {
            this.serializeContentsFiltered(value, g, ctxt, value.size());
        } else {
            this.serializeContentsNonFiltered(value, g, ctxt, value.size());
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    private final void serializeContentsNonFiltered(List<String> value, JsonGenerator g, SerializationContext ctxt, int len) throws JacksonException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                g.writeString(str);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }

    private final void serializeContentsFiltered(List<String> value, JsonGenerator g, SerializationContext ctxt, int len) throws JacksonException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    if (this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                if (!this._shouldSerializeElement(str, null, ctxt)) continue;
                g.writeString(str);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }

    protected boolean _needToCheckFiltering(SerializationContext ctxt) {
        return (this._suppressableValue != null || this._suppressNulls) && ctxt.isEnabled(SerializationFeature.APPLY_JSON_INCLUDE_FOR_CONTAINERS);
    }
}

