/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.AsArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase<Object> {
    public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> valueSerializer) {
        super(List.class, elemType, staticTyping, vts, valueSerializer);
    }

    @Deprecated
    public IndexedListSerializer(IndexedListSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        this(src, vts, valueSerializer, unwrapSingle, property, src._suppressableValue, src._suppressNulls);
    }

    public IndexedListSerializer(IndexedListSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property, Object suppressableValue, boolean suppressNulls) {
        super(src, vts, valueSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
    }

    @Override
    protected StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IndexedListSerializer(this, vts, this._elementSerializer, this._unwrapSingle, this._property, this._suppressableValue, this._suppressNulls);
    }

    public IndexedListSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new IndexedListSerializer(this, vts, elementSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Object value) {
        return ((List)value).isEmpty();
    }

    @Override
    public boolean hasSingleElement(Object value) {
        return ((List)value).size() == 1;
    }

    @Override
    public final void serialize(Object value0, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        List value = (List)value0;
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g, ctxt);
            return;
        }
        g.writeStartArray((Object)value, len);
        this.serializeContents(value, g, ctxt);
        g.writeEndArray();
    }

    @Override
    public void serializeContents(Object value0, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        List value = (List)value0;
        if (this._elementSerializer != null) {
            this.serializeContentsUsingImpl(value, g, ctxt, this._elementSerializer);
        } else if (this._valueTypeSerializer != null) {
            this.serializeTypedContentsImpl(value, g, ctxt);
        } else {
            this.serializeContentsImpl(value, g, ctxt);
        }
    }

    private void serializeContentsImpl(List<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        int len = value.size();
        if (len == 0) {
            return;
        }
        boolean filtered = this._needToCheckFiltering(ctxt);
        try {
            for (i = 0; i < len; ++i) {
                Object elem = value.get(i);
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = this._dynamicValueSerializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, serializer)) continue;
                serializer.serialize(elem, g, ctxt);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }

    private void serializeContentsUsingImpl(List<?> value, JsonGenerator g, SerializationContext ctxt, ValueSerializer<Object> ser) throws JacksonException {
        int len = value.size();
        if (len == 0) {
            return;
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        boolean filtered = this._needToCheckFiltering(ctxt);
        for (int i = 0; i < len; ++i) {
            Object elem = value.get(i);
            try {
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, ser)) continue;
                if (typeSer == null) {
                    ser.serialize(elem, g, ctxt);
                    continue;
                }
                ser.serializeWithType(elem, g, ctxt, typeSer);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(ctxt, (Throwable)e, value, i);
            }
        }
    }

    private void serializeTypedContentsImpl(List<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        int len = value.size();
        if (len == 0) {
            return;
        }
        boolean filtered = this._needToCheckFiltering(ctxt);
        try {
            TypeSerializer typeSer = this._valueTypeSerializer;
            PropertySerializerMap serializers = this._dynamicValueSerializers;
            for (i = 0; i < len; ++i) {
                Object elem = value.get(i);
                if (elem == null) {
                    if (filtered && this._suppressNulls) continue;
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = serializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                    serializers = this._dynamicValueSerializers;
                }
                if (filtered && !this._shouldSerializeElement(ctxt, elem, serializer)) continue;
                serializer.serializeWithType(elem, g, ctxt, typeSer);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }
}

