/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.util.EnumDefinition;
import tools.jackson.databind.util.EnumValues;
import tools.jackson.databind.util.EnumValuesToWrite;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>> {
    protected final EnumValuesToWrite _enumValuesToWrite;
    protected final Boolean _serializeAsIndex;

    public EnumSerializer(EnumValuesToWrite enumValuesToWrite, Boolean serializeAsIndex) {
        super(enumValuesToWrite.enumClass(), false);
        this._enumValuesToWrite = enumValuesToWrite;
        this._serializeAsIndex = serializeAsIndex;
    }

    public static EnumSerializer construct(Class<?> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format) {
        EnumValuesToWrite writer = EnumDefinition.construct(config, beanDesc.getClassInfo()).valuesToWrite(config);
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format, true, null);
        return new EnumSerializer(writer, serializeAsIndex);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        Class<?> type;
        Boolean serializeAsIndex;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null && !Objects.equals(serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(type = this.handledType(), format, false, this._serializeAsIndex), this._serializeAsIndex)) {
            return new EnumSerializer(this._enumValuesToWrite, serializeAsIndex);
        }
        return this;
    }

    @Deprecated
    public EnumValues getEnumValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._serializeAsIndex(ctxt)) {
            g.writeNumber(en.ordinal());
            return;
        }
        SerializationConfig config = ctxt.getConfig();
        if (ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING)) {
            g.writeString(this._enumValuesToWrite.enumValueFromToString(config, en));
            return;
        }
        g.writeString(this._enumValuesToWrite.enumValueFromName(config, en));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        SerializationContext ctxt = visitor.getContext();
        if (this._serializeAsIndex(ctxt)) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
            return;
        }
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (stringVisitor != null) {
            LinkedHashSet<String> enumStrings = new LinkedHashSet<String>();
            List<Enum<?>> enums = this._enumValuesToWrite.enums();
            if (this._serializeAsIndex(ctxt)) {
                for (Enum<?> en : enums) {
                    enumStrings.add(String.valueOf(en.ordinal()));
                }
            } else {
                SerializableString[] values;
                SerializationConfig config = ctxt.getConfig();
                for (SerializableString sstr : values = ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_TO_STRING) ? this._enumValuesToWrite.allEnumValuesFromToString(config) : this._enumValuesToWrite.allEnumValuesFromName(config)) {
                    enumStrings.add(sstr.getValue());
                }
            }
            stringVisitor.enumTypes(enumStrings);
        }
    }

    protected final boolean _serializeAsIndex(SerializationContext ctxt) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format, boolean fromClass, Boolean defaultValue) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format == null ? null : format.getShape();
        if (shape == null) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.STRING || shape == JsonFormat.Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", shape, enumClass.getName(), fromClass ? "class" : "property"));
    }
}

