/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.AsArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;

public class CollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    private final boolean _maybeEnumSet;

    public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> valueSerializer) {
        super(Collection.class, elemType, staticTyping, vts, valueSerializer);
        this._maybeEnumSet = elemType.isEnumType() || elemType.isJavaLangObject();
    }

    @Deprecated
    protected CollectionSerializer(CollectionSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        this(src, vts, valueSerializer, unwrapSingle, property, (Object)null, false);
    }

    protected CollectionSerializer(CollectionSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property, Object suppressableValue, boolean suppressNulls) {
        super(src, vts, valueSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
        this._maybeEnumSet = src._maybeEnumSet;
    }

    @Override
    protected StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new CollectionSerializer(this, vts, this._elementSerializer, this._unwrapSingle, this._property, this._suppressableValue, this._suppressNulls);
    }

    protected CollectionSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, Object suppressableValue, boolean suppressNulls) {
        return new CollectionSerializer(this, vts, elementSerializer, unwrapSingle, property, suppressableValue, suppressNulls);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Collection<?> value) {
        return value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Collection<?> value) {
        return value.size() == 1;
    }

    @Override
    public final void serialize(Collection<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContentsImpl(value, g, ctxt);
            return;
        }
        g.writeStartArray(value, len);
        this.serializeContentsImpl(value, g, ctxt);
        g.writeEndArray();
    }

    @Override
    public void serializeContents(Collection<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        this.serializeContentsImpl(value, g, ctxt);
    }

    private void serializeContentsImpl(Collection<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._elementSerializer != null) {
            this.serializeContentsUsingImpl(value, g, ctxt, this._elementSerializer);
            return;
        }
        Iterator<?> it = value.iterator();
        if (!it.hasNext()) {
            return;
        }
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        TypeSerializer typeSer = this._maybeEnumSet && value instanceof EnumSet ? null : this._valueTypeSerializer;
        boolean filtered = this._needToCheckFiltering(ctxt);
        int i = 0;
        try {
            do {
                Object elem;
                if ((elem = it.next()) == null) {
                    if (filtered && this._suppressNulls) {
                        ++i;
                        continue;
                    }
                    ctxt.defaultSerializeNullValue(g);
                } else {
                    Class<?> cc = elem.getClass();
                    ValueSerializer<Object> serializer = serializers.serializerFor(cc);
                    if (serializer == null) {
                        serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                        serializers = this._dynamicValueSerializers;
                    }
                    if (filtered && !this._shouldSerializeElement(ctxt, elem, serializer)) {
                        ++i;
                        continue;
                    }
                    if (typeSer == null) {
                        serializer.serialize(elem, g, ctxt);
                    } else {
                        serializer.serializeWithType(elem, g, ctxt, typeSer);
                    }
                }
                ++i;
            } while (it.hasNext());
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }

    private void serializeContentsUsingImpl(Collection<?> value, JsonGenerator g, SerializationContext ctxt, ValueSerializer<Object> ser) throws JacksonException {
        Iterator<?> it = value.iterator();
        if (it.hasNext()) {
            boolean filtered = this._needToCheckFiltering(ctxt);
            TypeSerializer typeSer = this._maybeEnumSet && value instanceof EnumSet ? null : this._valueTypeSerializer;
            int i = 0;
            do {
                Object elem = it.next();
                try {
                    if (elem == null) {
                        if (filtered && this._suppressNulls) {
                            ++i;
                            continue;
                        }
                        ctxt.defaultSerializeNullValue(g);
                    } else {
                        if (filtered && !this._shouldSerializeElement(ctxt, elem, ser)) {
                            ++i;
                            continue;
                        }
                        if (typeSer == null) {
                            ser.serialize(elem, g, ctxt);
                        } else {
                            ser.serializeWithType(elem, g, ctxt, typeSer);
                        }
                    }
                    ++i;
                }
                catch (Exception e) {
                    this.wrapAndThrow(ctxt, (Throwable)e, value, i);
                }
            } while (it.hasNext());
        }
    }
}

