/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.bean;

import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.util.NameTransformer;

public class UnwrappingBeanSerializer
extends BeanSerializerBase {
    protected final NameTransformer _nameTransformer;

    public UnwrappingBeanSerializer(BeanSerializerBase src, NameTransformer transformer) {
        super(src, transformer);
        this._nameTransformer = transformer;
    }

    public UnwrappingBeanSerializer(UnwrappingBeanSerializer src, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)src, objectIdWriter);
        this._nameTransformer = src._nameTransformer;
    }

    public UnwrappingBeanSerializer(UnwrappingBeanSerializer src, ObjectIdWriter objectIdWriter, Object filterId) {
        super((BeanSerializerBase)src, objectIdWriter, filterId);
        this._nameTransformer = src._nameTransformer;
    }

    protected UnwrappingBeanSerializer(UnwrappingBeanSerializer src, Set<String> toIgnore) {
        this(src, toIgnore, null);
    }

    protected UnwrappingBeanSerializer(UnwrappingBeanSerializer src, Set<String> toIgnore, Set<String> toInclude) {
        super((BeanSerializerBase)src, toIgnore, toInclude);
        this._nameTransformer = src._nameTransformer;
    }

    protected UnwrappingBeanSerializer(UnwrappingBeanSerializer src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super((BeanSerializerBase)src, properties, filteredProperties);
        this._nameTransformer = src._nameTransformer;
    }

    @Override
    public ValueSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return true;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new UnwrappingBeanSerializer(this, objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new UnwrappingBeanSerializer(this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new UnwrappingBeanSerializer(this, toIgnore, toInclude);
    }

    @Override
    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return new UnwrappingBeanSerializer(this, properties, filteredProperties);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, ctxt, false);
            return;
        }
        gen.assignCurrentValue(bean);
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, gen, ctxt, this._propertyFilterId);
            return;
        }
        BeanPropertyWriter[] fProps = this._filteredProps;
        if (fProps != null && ctxt.getActiveView() != null) {
            this._serializePropertiesMaybeView(bean, gen, ctxt, fProps);
            return;
        }
        this._serializePropertiesNoView(bean, gen, ctxt, this._props);
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        if (ctxt.isEnabled(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS)) {
            ctxt.reportBadDefinition(this.handledType(), "Unwrapped property requires use of type information: cannot serialize without disabling `SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS`");
        }
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, ctxt, typeSer);
            return;
        }
        gen.assignCurrentValue(bean);
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, gen, ctxt, this._propertyFilterId);
            return;
        }
        BeanPropertyWriter[] fProps = this._filteredProps;
        if (fProps != null && ctxt.getActiveView() != null) {
            this._serializePropertiesMaybeView(bean, gen, ctxt, fProps);
            return;
        }
        this._serializePropertiesNoView(bean, gen, ctxt, this._props);
    }

    @Override
    public String toString() {
        return "UnwrappingBeanSerializer for " + this.handledType().getName();
    }
}

