/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.bean;

import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.databind.ser.bean.UnrolledBeanAsArraySerializer;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.util.NameTransformer;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase src) {
        super(src, (ObjectIdWriter)null);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super(src, toIgnore, toInclude);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId) {
        super(src, oiw, filterId);
        this._defaultSerializer = src;
    }

    public static BeanSerializerBase construct(BeanSerializerBase src) {
        UnrolledBeanAsArraySerializer ser = UnrolledBeanAsArraySerializer.tryConstruct(src);
        if (ser != null) {
            return ser;
        }
        return new BeanAsArraySerializer(src);
    }

    @Override
    public ValueSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return this._defaultSerializer.unwrappingSerializer(transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanAsArraySerializer withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, toIgnore, toInclude);
    }

    @Override
    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return this;
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        boolean filtered;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, ctxt, typeSer);
            return;
        }
        gen.assignCurrentValue(bean);
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_ARRAY);
        typeSer.writeTypePrefix(gen, ctxt, typeIdDef);
        boolean bl = filtered = this._filteredProps != null && ctxt.getActiveView() != null;
        if (filtered) {
            this.serializeFiltered(bean, gen, ctxt);
        } else {
            this.serializeNonFiltered(bean, gen, ctxt);
        }
        typeSer.writeTypeSuffix(gen, ctxt, typeIdDef);
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        boolean filtered;
        boolean bl = filtered = this._filteredProps != null && ctxt.getActiveView() != null;
        if (ctxt.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(ctxt)) {
            if (filtered) {
                this.serializeFiltered(bean, gen, ctxt);
            } else {
                this.serializeNonFiltered(bean, gen, ctxt);
            }
            return;
        }
        gen.writeStartArray(bean, this._props.length);
        if (filtered) {
            this.serializeFiltered(bean, gen, ctxt);
        } else {
            this.serializeNonFiltered(bean, gen, ctxt);
        }
        gen.writeEndArray();
    }

    private boolean hasSingleElement(SerializationContext ctxt) {
        return this._props.length == 1;
    }

    protected final void serializeNonFiltered(Object bean, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        BeanPropertyWriter[] props = this._props;
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    prop = props[i];
                    prop.serializeAsElement(bean, gen, ctxt);
                    prop = props[i + 1];
                    prop.serializeAsElement(bean, gen, ctxt);
                    prop = props[i + 2];
                    prop.serializeAsElement(bean, gen, ctxt);
                    prop = props[i + 3];
                    prop.serializeAsElement(bean, gen, ctxt);
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, ctxt);
                }
                case 2: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, ctxt);
                }
                case 1: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, ctxt);
                }
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, prop.getName());
        }
        catch (StackOverflowError e) {
            throw DatabindException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, prop.getName());
        }
    }

    protected final void serializeFiltered(Object bean, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        BeanPropertyWriter[] props = this._filteredProps;
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    if ((prop = props[i]) == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                    prop = props[i + 1];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                    prop = props[i + 2];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                    prop = props[i + 3];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                }
                case 2: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, ctxt);
                    }
                }
                case 1: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                        break;
                    }
                    prop.serializeAsElement(bean, gen, ctxt);
                }
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, prop.getName());
        }
        catch (StackOverflowError e) {
            throw DatabindException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, prop.getName());
        }
    }
}

