/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;
import tools.jackson.databind.util.ClassUtil;

public class POJONode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    protected final Object _value;

    public POJONode(Object v) {
        this._value = v;
    }

    @Override
    protected String _valueDesc() {
        return "{POJO of type " + ClassUtil.classNameOf(this._value) + "}";
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public boolean isEmbeddedValue() {
        return true;
    }

    @Override
    protected Boolean _asBoolean() {
        Object object = this._value;
        if (object instanceof Boolean) {
            Boolean B = (Boolean)object;
            return B;
        }
        if (this._value == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        Object object = this._value;
        if (object instanceof Boolean) {
            Boolean B = (Boolean)object;
            return B;
        }
        return defaultValue;
    }

    @Override
    public Optional<Boolean> asBooleanOpt() {
        Object object = this._value;
        if (object instanceof Boolean) {
            Boolean B = (Boolean)object;
            return B != false ? OPT_TRUE : OPT_FALSE;
        }
        return Optional.empty();
    }

    @Override
    protected String _asString() {
        Object object = this._value;
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        if (this._value == null) {
            return "";
        }
        return null;
    }

    @Override
    public String asString(String defaultValue) {
        Object object = this._value;
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        return defaultValue;
    }

    @Override
    public Optional<String> asStringOpt() {
        Object object = this._value;
        if (object instanceof String) {
            String str = (String)object;
            return Optional.of(str);
        }
        return Optional.empty();
    }

    @Override
    public byte[] binaryValue() {
        Object object = this._value;
        if (object instanceof byte[]) {
            byte[] byteArray = (byte[])object;
            return byteArray;
        }
        return super.binaryValue();
    }

    @Override
    public short asShort() {
        Long L;
        if (this._value == null) {
            return 0;
        }
        if (!(this._value instanceof Number)) {
            super.asShort();
        }
        if ((L = this._extractAsLong()) == null || L < -32768L || L > 32767L) {
            this._reportShortConversionRangeFail("asShort()");
        }
        return L.shortValue();
    }

    @Override
    public short asShort(short defaultValue) {
        if (this._value == null) {
            return defaultValue;
        }
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        Long L = this._extractAsLong();
        if (L == null || L < -32768L || L > 32767L) {
            return defaultValue;
        }
        return L.shortValue();
    }

    @Override
    public Optional<Short> asShortOpt() {
        if (this._value == null) {
            return Optional.empty();
        }
        if (!(this._value instanceof Number)) {
            return Optional.empty();
        }
        Long L = this._extractAsLong();
        if (L == null || L < -32768L || L > 32767L) {
            return Optional.empty();
        }
        return Optional.of(L.shortValue());
    }

    @Override
    public int asInt() {
        Long L;
        if (this._value == null) {
            return 0;
        }
        if (!(this._value instanceof Number)) {
            super.asInt();
        }
        if ((L = this._extractAsLong()) == null || L < Integer.MIN_VALUE || L > Integer.MAX_VALUE) {
            this._reportIntConversionRangeFail("asInt()");
        }
        return L.intValue();
    }

    @Override
    public int asInt(int defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        Long L = this._extractAsLong();
        if (L == null || L < Integer.MIN_VALUE || L > Integer.MAX_VALUE) {
            return defaultValue;
        }
        return L.intValue();
    }

    @Override
    public OptionalInt asIntOpt() {
        if (!(this._value instanceof Number)) {
            return OptionalInt.empty();
        }
        Long L = this._extractAsLong();
        if (L == null || L < Integer.MIN_VALUE || L > Integer.MAX_VALUE) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(L.intValue());
    }

    @Override
    public long asLong() {
        Long L;
        if (this._value == null) {
            return 0L;
        }
        if (!(this._value instanceof Number)) {
            super.asLong();
        }
        if ((L = this._extractAsLong()) == null) {
            this._reportLongConversionRangeFail("asLong()");
        }
        return L;
    }

    @Override
    public long asLong(long defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        Long L = this._extractAsLong();
        if (L == null) {
            return defaultValue;
        }
        return L;
    }

    @Override
    public OptionalLong asLongOpt() {
        if (!(this._value instanceof Number)) {
            return OptionalLong.empty();
        }
        Long L = this._extractAsLong();
        if (L == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(L);
    }

    @Override
    public BigInteger asBigInteger() {
        if (this._value == null) {
            return BigInteger.ZERO;
        }
        if (!(this._value instanceof Number)) {
            super.asBigInteger();
        }
        return this._extractAsBigInteger();
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        return this._extractAsBigInteger();
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        if (!(this._value instanceof Number)) {
            return Optional.empty();
        }
        return Optional.of(this._extractAsBigInteger());
    }

    @Override
    public float asFloat() {
        Float F;
        if (this._value == null) {
            return 0.0f;
        }
        if (!(this._value instanceof Number)) {
            super.asFloat();
        }
        if ((F = this._extractAsFloat()) == null) {
            this._reportFloatConversionRangeFail("asFloat()");
        }
        return F.floatValue();
    }

    @Override
    public float asFloat(float defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        Float F = this._extractAsFloat();
        if (F == null) {
            return defaultValue;
        }
        return F.floatValue();
    }

    @Override
    public Optional<Float> asFloatOpt() {
        if (!(this._value instanceof Number)) {
            return Optional.empty();
        }
        Float F = this._extractAsFloat();
        if (F == null) {
            return Optional.empty();
        }
        return Optional.of(F);
    }

    @Override
    public double asDouble() {
        Double D;
        if (this._value == null) {
            return 0.0;
        }
        if (!(this._value instanceof Number)) {
            super.asDouble();
        }
        if ((D = this._extractAsDouble()) == null) {
            this._reportDoubleConversionRangeFail("asDouble()");
        }
        return D;
    }

    @Override
    public double asDouble(double defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        Double D = this._extractAsDouble();
        if (D == null) {
            return defaultValue;
        }
        return D;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        if (!(this._value instanceof Number)) {
            return OptionalDouble.empty();
        }
        Double D = this._extractAsDouble();
        if (D == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(D);
    }

    @Override
    public BigDecimal asDecimal() {
        if (this._value == null) {
            return BigDecimal.ZERO;
        }
        if (!(this._value instanceof Number)) {
            super.asDecimal();
        }
        return this._extractAsBigDecimal();
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        if (!(this._value instanceof Number)) {
            return defaultValue;
        }
        return this._extractAsBigDecimal();
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        if (!(this._value instanceof Number)) {
            return Optional.empty();
        }
        return Optional.of(this._extractAsBigDecimal());
    }

    protected Long _extractAsLong() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof BigInteger) {
                BigInteger big = (BigInteger)N;
                if (big.compareTo(BI_MIN_LONG) >= 0 && big.compareTo(BI_MAX_LONG) <= 0) {
                    return big.longValue();
                }
            } else if (N instanceof BigDecimal) {
                BigDecimal dec = (BigDecimal)N;
                if (dec.compareTo(BD_MIN_LONG) >= 0 && dec.compareTo(BD_MAX_LONG) <= 0) {
                    return dec.longValue();
                }
            } else if (N instanceof Double) {
                Double D = (Double)N;
                if (D >= -9.223372036854776E18 && D <= 9.223372036854776E18) {
                    return D.longValue();
                }
            } else if (N instanceof Float) {
                Float F = (Float)N;
                if (F.floatValue() >= -9.223372E18f && F.floatValue() <= 9.223372E18f) {
                    return F.longValue();
                }
            } else {
                return N.longValue();
            }
        }
        return null;
    }

    protected BigInteger _extractAsBigInteger() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof BigInteger) {
                BigInteger big = (BigInteger)N;
                return big;
            }
            if (N instanceof BigDecimal) {
                BigDecimal dec = (BigDecimal)N;
                return dec.toBigInteger();
            }
            return BigInteger.valueOf(N.longValue());
        }
        return null;
    }

    protected Float _extractAsFloat() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof Float) {
                Float F = (Float)N;
                return F;
            }
            float f = N.floatValue();
            if (Float.isFinite(f)) {
                return Float.valueOf(f);
            }
        }
        return null;
    }

    protected Double _extractAsDouble() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof Double) {
                Double D = (Double)N;
                return D;
            }
            double d = N.doubleValue();
            if (Double.isFinite(d)) {
                return d;
            }
        }
        return null;
    }

    protected BigDecimal _extractAsBigDecimal() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof BigDecimal) {
                BigDecimal dec = (BigDecimal)N;
                return dec;
            }
            if (N instanceof BigInteger) {
                BigInteger big = (BigInteger)N;
                return new BigDecimal(big);
            }
            if (N instanceof Long || N instanceof Integer || N instanceof Short || N instanceof Byte) {
                return BigDecimal.valueOf(N.longValue());
            }
            try {
                return BigDecimal.valueOf(N.doubleValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final void serialize(JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (this._value == null) {
            ctxt.defaultSerializeNullValue(gen);
        } else if (this._value instanceof JacksonSerializable) {
            ((JacksonSerializable)this._value).serialize(gen, ctxt);
        } else {
            ctxt.writeValue(gen, this._value);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof POJONode) {
            POJONode pojoNode = (POJONode)o;
            return this._pojoEquals(pojoNode);
        }
        return false;
    }

    protected boolean _pojoEquals(POJONode other) {
        if (this._value == null) {
            return other._value == null;
        }
        return this._value.equals(other._value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

