/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericFPNode;

public class DecimalNode
extends NumericFPNode {
    private static final long serialVersionUID = 3L;
    public static final DecimalNode ZERO = new DecimalNode(BigDecimal.ZERO);
    protected final BigDecimal _value;

    public DecimalNode(BigDecimal v) {
        this._value = Objects.requireNonNull(v);
    }

    public static DecimalNode valueOf(BigDecimal d) {
        return new DecimalNode(d);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_DECIMAL;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public String _asString() {
        return this._value.toString();
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatConversionRangeFail("floatValue()");
    }

    @Override
    public float floatValue(float defaultValue) {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return defaultValue;
    }

    @Override
    public Optional<Float> floatValueOpt() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return Optional.of(Float.valueOf(f));
        }
        return Optional.empty();
    }

    @Override
    public float asFloat() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatConversionRangeFail("asFloat()");
    }

    @Override
    public float asFloat(float defaultValue) {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return defaultValue;
    }

    @Override
    public Optional<Float> asFloatOpt() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return Optional.of(Float.valueOf(f));
        }
        return Optional.empty();
    }

    @Override
    public double doubleValue() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleConversionRangeFail("doubleValue()");
    }

    @Override
    public double doubleValue(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(d);
        }
        return OptionalDouble.empty();
    }

    @Override
    public double asDouble() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleConversionRangeFail("asDouble()");
    }

    @Override
    public double asDouble(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(d);
        }
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this._value);
    }

    @Override
    public BigDecimal asDecimal() {
        return this._value;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        return Optional.of(this._value);
    }

    @Override
    public short _asShortValueUnchecked() {
        return this._value.shortValue();
    }

    @Override
    public int _asIntValueUnchecked() {
        return this._value.intValue();
    }

    @Override
    public long _asLongValueUnchecked() {
        return this._value.longValue();
    }

    @Override
    protected BigInteger _asBigIntegerValueUnchecked() {
        return this._value.toBigInteger();
    }

    @Override
    protected BigDecimal _asDecimalValueUnchecked() {
        return this._value;
    }

    @Override
    public boolean hasFractionalPart() {
        return this._value.signum() != 0 && this._value.scale() > 0 && this._value.stripTrailingZeros().scale() > 0;
    }

    @Override
    public boolean inShortRange() {
        return this._value.compareTo(BD_MIN_SHORT) >= 0 && this._value.compareTo(BD_MAX_SHORT) <= 0;
    }

    @Override
    public boolean inIntRange() {
        return this._value.compareTo(BD_MIN_INTEGER) >= 0 && this._value.compareTo(BD_MAX_INTEGER) <= 0;
    }

    @Override
    public boolean inLongRange() {
        return this._value.compareTo(BD_MIN_LONG) >= 0 && this._value.compareTo(BD_MAX_LONG) <= 0;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DecimalNode) {
            DecimalNode otherNode = (DecimalNode)o;
            return otherNode._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

