/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.exc.JsonNodeException;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.InternalNodeSerializer;
import tools.jackson.databind.node.MissingNode;
import tools.jackson.databind.node.NodeSerialization;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.TreeTraversingParser;
import tools.jackson.databind.util.ClassUtil;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected static final Optional<Boolean> OPT_FALSE = Optional.of(false);
    protected static final Optional<Boolean> OPT_TRUE = Optional.of(true);

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public boolean isMissingNode() {
        return false;
    }

    public boolean isEmbeddedValue() {
        return false;
    }

    @Override
    public Number numberValue() {
        return (Number)this._reportCoercionFail("numberValue()", Number.class, "value type not numeric");
    }

    @Override
    public short shortValue() {
        return (Short)this._reportCoercionFail("shortValue()", Short.TYPE, "value type not numeric");
    }

    @Override
    public short shortValue(short defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<Short> shortValueOpt() {
        return Optional.empty();
    }

    @Override
    public short asShort() {
        return (Short)this._reportCoercionFail("asShort()", Short.TYPE);
    }

    @Override
    public short asShort(short defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<Short> asShortOpt() {
        return Optional.empty();
    }

    @Override
    public int intValue() {
        return (Integer)this._reportCoercionFail("intValue()", Integer.TYPE, "value type not numeric");
    }

    @Override
    public int intValue(int defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalInt intValueOpt() {
        return OptionalInt.empty();
    }

    @Override
    public int asInt() {
        return (Integer)this._reportCoercionFail("asInt()", Integer.TYPE);
    }

    @Override
    public int asInt(int defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalInt asIntOpt() {
        return OptionalInt.empty();
    }

    @Override
    public long longValue() {
        return (Long)this._reportCoercionFail("longValue()", Long.TYPE, "value type not numeric");
    }

    @Override
    public long longValue(long defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalLong longValueOpt() {
        return OptionalLong.empty();
    }

    @Override
    public long asLong() {
        return (Long)this._reportCoercionFail("asLong()", Long.TYPE);
    }

    @Override
    public long asLong(long defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalLong asLongOpt() {
        return OptionalLong.empty();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return (BigInteger)this._reportCoercionFail("bigIntegerValue()", BigInteger.class, "value type not numeric");
    }

    @Override
    public BigInteger bigIntegerValue(BigInteger defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<BigInteger> bigIntegerValueOpt() {
        return Optional.empty();
    }

    @Override
    public BigInteger asBigInteger() {
        return (BigInteger)this._reportCoercionFail("asBigInteger()", BigInteger.class);
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        return Optional.empty();
    }

    @Override
    public float floatValue() {
        return ((Float)this._reportCoercionFail("floatValue()", Float.TYPE, "value type not numeric")).floatValue();
    }

    @Override
    public float floatValue(float defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<Float> floatValueOpt() {
        return Optional.empty();
    }

    @Override
    public float asFloat() {
        return ((Float)this._reportCoercionFail("asFloat()", Float.TYPE)).floatValue();
    }

    @Override
    public float asFloat(float defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<Float> asFloatOpt() {
        return Optional.empty();
    }

    @Override
    public double doubleValue() {
        return (Double)this._reportCoercionFail("doubleValue()", Double.TYPE, "value type not numeric");
    }

    @Override
    public double doubleValue(double defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.empty();
    }

    @Override
    public double asDouble() {
        return (Double)this._reportCoercionFail("asDouble()", Double.TYPE);
    }

    @Override
    public double asDouble(double defaultValue) {
        return defaultValue;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return (BigDecimal)this._reportCoercionFail("decimalValue()", BigDecimal.class, "value type not numeric");
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.empty();
    }

    @Override
    public BigDecimal asDecimal() {
        return (BigDecimal)this._reportCoercionFail("asDecimal()", BigDecimal.class);
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        return Optional.empty();
    }

    @Override
    public byte[] binaryValue() {
        return (byte[])this._reportConversionFail("binaryValue()", Boolean.TYPE, "value type not binary (or convertible to binary via Base64-decoding)");
    }

    @Override
    public boolean booleanValue() {
        return (Boolean)this._reportConversionFail("booleanValue()", Boolean.TYPE, "value type not boolean");
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<Boolean> booleanValueOpt() {
        return Optional.empty();
    }

    @Override
    public boolean asBoolean() {
        Boolean b = this._asBoolean();
        if (b == null) {
            return (Boolean)this._reportCoercionFail("asBoolean()", Boolean.TYPE);
        }
        return b;
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        Boolean b = this._asBoolean();
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    @Override
    public Optional<Boolean> asBooleanOpt() {
        Boolean b = this._asBoolean();
        if (b == null) {
            return Optional.empty();
        }
        return b != false ? OPT_TRUE : OPT_FALSE;
    }

    @Override
    public String stringValue() {
        return (String)this._reportConversionFail("stringValue()", String.class, "value type not String");
    }

    @Override
    public String stringValue(String defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<String> stringValueOpt() {
        return Optional.empty();
    }

    @Override
    public String asString() {
        String str = this._asString();
        if (str == null) {
            return (String)this._reportCoercionFail("asString()", String.class);
        }
        return str;
    }

    @Override
    public String asString(String defaultValue) {
        String str = this._asString();
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    @Override
    public Optional<String> asStringOpt() {
        return Optional.ofNullable(this._asString());
    }

    @Override
    public ArrayNode asArray() {
        return (ArrayNode)this._reportWrongNodeType("Can only call `asArray()` on `ArrayNode`, not %s", ClassUtil.nameOf(this.getClass()));
    }

    @Override
    public Optional<ArrayNode> asArrayOpt() {
        return Optional.empty();
    }

    @Override
    public ObjectNode asObject() {
        return (ObjectNode)this._reportWrongNodeType("Can only call `asObject()` on `ObjectNode`, not %s", ClassUtil.nameOf(this.getClass()));
    }

    @Override
    public Optional<ObjectNode> asObjectOpt() {
        return Optional.empty();
    }

    @Override
    public final JsonNode findPath(String fieldName) {
        JsonNode value = this.findValue(fieldName);
        if (value == null) {
            return MissingNode.getInstance();
        }
        return value;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String fieldName) {
        return (JsonNode)this._reportRequiredViolation("Node of type %s has no fields", ClassUtil.nameOf(this.getClass()));
    }

    @Override
    public JsonNode required(int index) {
        return (JsonNode)this._reportRequiredViolation("Node of type %s has no indexed values", ClassUtil.nameOf(this.getClass()));
    }

    public JsonParser traverse(ObjectReadContext readCtxt) {
        return new TreeTraversingParser(this, readCtxt);
    }

    public abstract JsonToken asToken();

    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public ObjectNode withObject(JsonPointer ptr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        ObjectNode n;
        if (ptr.matches()) {
            BaseJsonNode baseJsonNode = this;
            if (baseJsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)baseJsonNode;
                return objectNode;
            }
            this._reportWrongNodeType("Can only call `withObject()` with empty JSON Pointer on `ObjectNode`, not %s", ClassUtil.nameOf(this.getClass()));
        }
        if ((n = this._withObject(ptr, ptr, overwriteMode, preferIndex)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type %s) using `withObject()` with  JSON Pointer '%s'", ClassUtil.nameOf(this.getClass()), ptr);
        }
        return n;
    }

    protected ObjectNode _withObject(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        return null;
    }

    protected void _withXxxVerifyReplace(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex, JsonNode toReplace) {
        if (!this._withXxxMayReplace(toReplace, overwriteMode)) {
            this._reportWrongNodeType("Cannot replace `JsonNode` of type %s for property \"%s\" in JSON Pointer \"%s\" (mode `OverwriteMode.%s`)", new Object[]{ClassUtil.nameOf(toReplace.getClass()), currentPtr.getMatchingProperty(), origPtr, overwriteMode});
        }
    }

    protected boolean _withXxxMayReplace(JsonNode node, JsonNode.OverwriteMode overwriteMode) {
        switch (overwriteMode) {
            case NONE: {
                return false;
            }
            case NULLS: {
                return node.isNull();
            }
            case SCALARS: {
                return !node.isContainer();
            }
        }
        return true;
    }

    @Override
    public ArrayNode withArray(JsonPointer ptr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        ArrayNode n;
        if (ptr.matches()) {
            BaseJsonNode baseJsonNode = this;
            if (baseJsonNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)baseJsonNode;
                return arrayNode;
            }
            this._reportWrongNodeType("Can only call `withArray()` with empty JSON Pointer on `ArrayNode`, not %s", ClassUtil.nameOf(this.getClass()));
        }
        if ((n = this._withArray(ptr, ptr, overwriteMode, preferIndex)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type %s) using `withArray()` with  JSON Pointer '%s'", ClassUtil.nameOf(this.getClass()), ptr);
        }
        return n;
    }

    protected ArrayNode _withArray(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        return null;
    }

    protected Boolean _asBoolean() {
        return null;
    }

    protected String _asString() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializationContext var2) throws JacksonException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializationContext var2, TypeSerializer var3) throws JacksonException;

    @Override
    public String toString() {
        return InternalNodeSerializer.toString(this);
    }

    @Override
    public String toPrettyString() {
        return InternalNodeSerializer.toPrettyString(this);
    }

    protected <T> T _reportCoercionFail(String method, Class<?> targetType) {
        return this._reportCoercionFail(method, targetType, "value type not coercible");
    }

    protected <T> T _reportCoercionFail(String method, Class<?> targetType, String message) {
        throw JsonNodeException.from(this, "'%s' method `%s` cannot coerce value %s to %s: %s", this.getClass().getSimpleName(), method, this._valueDesc(), ClassUtil.nameOf(targetType), message);
    }

    protected <T> T _reportConversionFail(String method, Class<?> targetType, String message) {
        throw JsonNodeException.from(this, "'%s' method `%s` cannot convert value %s to %s: %s", this.getClass().getSimpleName(), method, this._valueDesc(), ClassUtil.nameOf(targetType), message);
    }

    protected short _reportShortConversionRangeFail(String method) {
        return (Short)this._reportConversionFail(method, Short.TYPE, "value not in 16-bit `short` range");
    }

    protected int _reportIntConversionRangeFail(String method) {
        return (Integer)this._reportConversionFail(method, Integer.TYPE, "value not in 32-bit `int` range");
    }

    protected long _reportLongConversionRangeFail(String method) {
        return (Long)this._reportConversionFail(method, Long.TYPE, "value not in 64-bit `long` range");
    }

    protected float _reportFloatConversionRangeFail(String method) {
        return ((Float)this._reportConversionFail(method, Float.TYPE, "value not in 32-bit `float` range")).floatValue();
    }

    protected double _reportDoubleConversionRangeFail(String method) {
        return (Double)this._reportConversionFail(method, Double.TYPE, "value not in 64-bit `double` range");
    }

    protected short _reportShortConversionFractionFail(String method) {
        return (Short)this._reportConversionFail(method, Short.TYPE, "value has fractional part");
    }

    protected int _reportIntConversionFractionFail(String method) {
        return (Integer)this._reportConversionFail(method, Integer.TYPE, "value has fractional part");
    }

    protected long _reportLongConversionFractionFail(String method) {
        return (Long)this._reportConversionFail(method, Long.TYPE, "value has fractional part");
    }

    protected BigInteger _reportBigIntegerConversionFractionFail(String method) {
        return (BigInteger)this._reportConversionFail(method, BigInteger.class, "value has fractional part");
    }

    protected int _reportIntConversionNaNFail(String method) {
        return (Integer)this._reportConversionFail(method, Integer.TYPE, "value non-Finite ('NaN')");
    }

    protected long _reportLongConversionNaNFail(String method) {
        return (Long)this._reportConversionFail(method, Long.TYPE, "value non-Finite ('NaN')");
    }

    protected BigInteger _reportBigIntegerConversionNaNFail(String method) {
        return (BigInteger)this._reportConversionFail(method, BigInteger.class, "value non-Finite ('NaN')");
    }

    protected BigDecimal _reportBigDecimalConversionNaNFail(String method) {
        return (BigDecimal)this._reportConversionFail(method, BigDecimal.class, "value non-Finite ('NaN')");
    }

    protected <T> T _reportWrongNodeType(String msgTemplate, Object ... args) {
        throw JsonNodeException.from(this, String.format(msgTemplate, args));
    }

    protected JsonPointer _jsonPointerIfValid(String exprOrProperty) {
        if (exprOrProperty.isEmpty() || exprOrProperty.charAt(0) == '/') {
            return JsonPointer.compile((String)exprOrProperty);
        }
        return null;
    }

    protected abstract String _valueDesc();
}

