/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.util.ClassUtil;

public class NoOpTypeDeserializer
extends TypeDeserializer {
    private final JavaType _baseType;
    private final BeanProperty _property;
    private volatile ValueDeserializer<Object> _deserializer;

    private NoOpTypeDeserializer(JavaType baseType, BeanProperty prop) {
        this._baseType = baseType;
        this._property = prop;
    }

    public static NoOpTypeDeserializer forBaseType(DeserializationContext ctxt, JavaType baseType) {
        return new NoOpTypeDeserializer(baseType, null);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        if (this._property == prop) {
            return this;
        }
        return new NoOpTypeDeserializer(this._baseType, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.NOTHING;
    }

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return null;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return null;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._deserialize(p, ctxt);
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._deserialize(p, ctxt);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._deserialize(p, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._deserialize(p, ctxt);
    }

    protected Object _deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        ValueDeserializer<Object> deser = this._deserializer;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._baseType, this._property);
            if (deser == null) {
                ctxt.reportBadDefinition(this._baseType, "Cannot find deserializer for type " + ClassUtil.getTypeDescription(this._baseType));
            }
            this._deserializer = deser;
        }
        return deser.deserialize(p, ctxt);
    }
}

