/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonDeserializeAs;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSerializeAs;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.EnumNaming;
import tools.jackson.databind.annotation.JsonAppend;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonNaming;
import tools.jackson.databind.annotation.JsonPOJOBuilder;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.annotation.JsonTypeIdResolver;
import tools.jackson.databind.annotation.JsonTypeResolver;
import tools.jackson.databind.annotation.JsonValueInstantiator;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.ext.beans.JavaBeansAnnotations;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.introspect.VirtualAnnotatedMember;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.VirtualBeanPropertyWriter;
import tools.jackson.databind.ser.impl.AttributePropertyWriter;
import tools.jackson.databind.ser.jackson.RawSerializer;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.ExceptionUtil;
import tools.jackson.databind.util.LookupCache;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.SimpleBeanPropertyDefinition;
import tools.jackson.databind.util.SimpleLookupCache;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_SER = new Class[]{JsonSerialize.class, JsonSerializeAs.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonRawValue.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_DESER = new Class[]{JsonDeserialize.class, JsonDeserializeAs.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class, JsonMerge.class};
    private static final JavaBeansAnnotations _javaBeansHelper;
    protected transient LookupCache<String, Boolean> _annotationsInside = new SimpleLookupCache<String, Boolean>(48, 96);
    protected boolean _cfgConstructorPropertiesImpliesCreator = true;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._annotationsInside == null) {
            this._annotationsInside = new SimpleLookupCache<String, Boolean>(48, 96);
        }
        return this;
    }

    public JacksonAnnotationIntrospector setConstructorPropertiesImpliesCreator(boolean b) {
        this._cfgConstructorPropertiesImpliesCreator = b;
        return this;
    }

    @Override
    public boolean isAnnotationBundle(Annotation ann) {
        Class<? extends Annotation> type = ann.annotationType();
        String typeName = type.getName();
        Boolean b = this._annotationsInside.get(typeName);
        if (b == null) {
            b = type.getAnnotation(JacksonAnnotationsInside.class) != null;
            this._annotationsInside.putIfAbsent(typeName, b);
        }
        return b;
    }

    @Override
    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[] names) {
        LinkedHashMap<String, String> enumToPropertyMap = new LinkedHashMap<String, String>();
        for (AnnotatedField field : annotatedClass.fields()) {
            String propValue;
            JsonProperty property = field.getAnnotation(JsonProperty.class);
            if (property == null || (propValue = property.value()) == null) continue;
            enumToPropertyMap.put(field.getName(), propValue);
        }
        int end = enumValues.length;
        for (int i = 0; i < end; ++i) {
            String defName = enumValues[i].name();
            String explValue = (String)enumToPropertyMap.get(defName);
            if (explValue == null) continue;
            names[i] = explValue;
        }
        return names;
    }

    @Override
    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[][] aliasList) {
        HashMap<String, String[]> enumToAliasMap = new HashMap<String, String[]>();
        for (AnnotatedField field : annotatedClass.fields()) {
            JsonAlias alias = field.getAnnotation(JsonAlias.class);
            if (alias == null) continue;
            enumToAliasMap.putIfAbsent(field.getName(), alias.value());
        }
        for (Enum<?> enumValue : enumValues) {
            aliasList[i] = enumToAliasMap.getOrDefault(enumValue.name(), new String[0]);
        }
    }

    @Override
    public Enum<?> findDefaultEnumValue(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues) {
        for (Annotated annotated : annotatedClass.fields()) {
            JsonEnumDefaultValue found;
            if (!annotated.getType().isEnumType() || (found = this._findAnnotation(annotated, JsonEnumDefaultValue.class)) == null) continue;
            for (Enum<?> enumValue : enumValues) {
                if (!enumValue.name().equals(annotated.getName())) continue;
                return enumValue;
            }
        }
        return null;
    }

    @Override
    public PropertyName findRootName(MapperConfig<?> config, AnnotatedClass ac) {
        JsonRootName ann = this._findAnnotation(ac, JsonRootName.class);
        if (ann == null) {
            return null;
        }
        String ns = ann.namespace();
        if (ns != null && ns.isEmpty()) {
            ns = null;
        }
        return PropertyName.construct(ann.value(), ns);
    }

    @Override
    public Boolean isIgnorableType(MapperConfig<?> config, AnnotatedClass ac) {
        JsonIgnoreType ignore = this._findAnnotation(ac, JsonIgnoreType.class);
        return ignore == null ? null : Boolean.valueOf(ignore.value());
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated a) {
        JsonIgnoreProperties v = this._findAnnotation(a, JsonIgnoreProperties.class);
        if (v == null) {
            return JsonIgnoreProperties.Value.empty();
        }
        return JsonIgnoreProperties.Value.from((JsonIgnoreProperties)v);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> config, Annotated a) {
        JsonIncludeProperties v = this._findAnnotation(a, JsonIncludeProperties.class);
        if (v == null) {
            return JsonIncludeProperties.Value.all();
        }
        return JsonIncludeProperties.Value.from((JsonIncludeProperties)v);
    }

    @Override
    public Object findFilterId(MapperConfig<?> config, Annotated a) {
        String id;
        JsonFilter ann = this._findAnnotation(a, JsonFilter.class);
        if (ann != null && !(id = ann.value()).isEmpty()) {
            return id;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(MapperConfig<?> config, AnnotatedClass ac) {
        JsonNaming ann = this._findAnnotation(ac, JsonNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Object findEnumNamingStrategy(MapperConfig<?> config, AnnotatedClass ac) {
        EnumNaming ann = this._findAnnotation(ac, EnumNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public String findClassDescription(MapperConfig<?> config, AnnotatedClass ac) {
        JsonClassDescription ann = this._findAnnotation(ac, JsonClassDescription.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public VisibilityChecker findAutoDetectVisibility(MapperConfig<?> config, AnnotatedClass ac, VisibilityChecker checker) {
        JsonAutoDetect ann = this._findAnnotation(ac, JsonAutoDetect.class);
        if (ann == null) {
            return checker;
        }
        return checker.withOverrides(JsonAutoDetect.Value.from((JsonAutoDetect)ann));
    }

    @Override
    public String findImplicitPropertyName(MapperConfig<?> config, AnnotatedMember m) {
        if (!config.isEnabled(MapperFeature.DETECT_PARAMETER_NAMES)) {
            return null;
        }
        if (m instanceof AnnotatedParameter) {
            AnnotatedParameter p = (AnnotatedParameter)m;
            AnnotatedWithParams owner = p.getOwner();
            if (owner instanceof AnnotatedConstructor) {
                PropertyName name;
                if (_javaBeansHelper != null && (name = _javaBeansHelper.findConstructorName(p)) != null) {
                    return name.getSimpleName();
                }
                return this._findImplicitName(owner, p.getIndex());
            }
            if (owner instanceof AnnotatedMethod && owner.isStatic()) {
                return this._findImplicitName(owner, p.getIndex());
            }
        }
        if (m instanceof AnnotatedField) {
            return m.getName();
        }
        return null;
    }

    protected String _findImplicitName(AnnotatedWithParams m, int index) {
        try {
            Parameter[] params = m.getNativeParameters();
            Parameter p = params[index];
            if (p.isNamePresent()) {
                return p.getName();
            }
        }
        catch (MalformedParametersException malformedParametersException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<PropertyName> findPropertyAliases(MapperConfig<?> config, Annotated m) {
        JsonAlias ann = this._findAnnotation(m, JsonAlias.class);
        if (ann == null) {
            return null;
        }
        String[] strs = ann.value();
        int len = strs.length;
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<PropertyName> result = new ArrayList<PropertyName>(len);
        for (int i = 0; i < len; ++i) {
            result.add(PropertyName.construct(strs[i]));
        }
        return result;
    }

    @Override
    public boolean hasIgnoreMarker(MapperConfig<?> config, AnnotatedMember m) {
        return this._isIgnorable(m);
    }

    @Override
    public Boolean hasRequiredMarker(MapperConfig<?> config, AnnotatedMember m) {
        JsonProperty ann = this._findAnnotation(m, JsonProperty.class);
        if (ann != null) {
            OptBoolean required = ann.isRequired();
            if (required != OptBoolean.DEFAULT) {
                return required.asBoolean();
            }
            if (ann.required()) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(MapperConfig<?> config, Annotated m) {
        JsonProperty ann = this._findAnnotation(m, JsonProperty.class);
        if (ann != null) {
            return ann.access();
        }
        return null;
    }

    @Override
    public String findPropertyDescription(MapperConfig<?> config, Annotated ann) {
        JsonPropertyDescription desc = this._findAnnotation(ann, JsonPropertyDescription.class);
        return desc == null ? null : desc.value();
    }

    @Override
    public Integer findPropertyIndex(MapperConfig<?> config, Annotated ann) {
        int ix;
        JsonProperty prop = this._findAnnotation(ann, JsonProperty.class);
        if (prop != null && (ix = prop.index()) != -1) {
            return ix;
        }
        return null;
    }

    @Override
    public String findPropertyDefaultValue(MapperConfig<?> config, Annotated ann) {
        JsonProperty prop = this._findAnnotation(ann, JsonProperty.class);
        if (prop == null) {
            return null;
        }
        String str = prop.defaultValue();
        return str.isEmpty() ? null : str;
    }

    @Override
    public JsonFormat.Value findFormat(MapperConfig<?> config, Annotated ann) {
        JsonFormat f = this._findAnnotation(ann, JsonFormat.class);
        return f == null ? null : JsonFormat.Value.from((JsonFormat)f);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(MapperConfig<?> config, AnnotatedMember member) {
        JsonManagedReference ref1 = this._findAnnotation(member, JsonManagedReference.class);
        if (ref1 != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(ref1.value());
        }
        JsonBackReference ref2 = this._findAnnotation(member, JsonBackReference.class);
        if (ref2 != null) {
            return AnnotationIntrospector.ReferenceProperty.back(ref2.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(MapperConfig<?> config, AnnotatedMember member) {
        JsonUnwrapped ann = this._findAnnotation(member, JsonUnwrapped.class);
        if (ann == null || !ann.enabled()) {
            return null;
        }
        String prefix = ann.prefix();
        String suffix = ann.suffix();
        return NameTransformer.simpleTransformer(prefix, suffix);
    }

    @Override
    public JacksonInject.Value findInjectableValue(MapperConfig<?> config, AnnotatedMember m) {
        JacksonInject ann = this._findAnnotation(m, JacksonInject.class);
        if (ann == null) {
            return null;
        }
        JacksonInject.Value v = JacksonInject.Value.from((JacksonInject)ann);
        if (!v.hasId()) {
            AnnotatedMethod am;
            String id = m instanceof AnnotatedMethod ? ((am = (AnnotatedMethod)m).getParameterCount() == 0 ? m.getRawType().getName() : am.getRawParameterType(0).getName()) : m.getRawType().getName();
            v = v.withId((Object)id);
        }
        return v;
    }

    @Override
    public Class<?>[] findViews(MapperConfig<?> config, Annotated a) {
        JsonView ann = this._findAnnotation(a, JsonView.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> config, AnnotatedMethod setter1, AnnotatedMethod setter2) {
        Class<?> cls1 = setter1.getRawParameterType(0);
        Class<?> cls2 = setter2.getRawParameterType(0);
        if (cls1.isPrimitive()) {
            if (!cls2.isPrimitive()) {
                return setter1;
            }
            return null;
        }
        if (cls2.isPrimitive()) {
            return setter2;
        }
        if (cls1 == String.class) {
            if (cls2 != String.class) {
                return setter1;
            }
        } else if (cls2 == String.class) {
            return setter2;
        }
        return null;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> config, AnnotatedField f, PropertyName implName) {
        return null;
    }

    @Override
    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> config, Annotated ann) {
        JsonTypeInfo t = this._findAnnotation(ann, JsonTypeInfo.class);
        return t == null ? null : JsonTypeInfo.Value.from((JsonTypeInfo)t);
    }

    @Override
    public Object findTypeResolverBuilder(MapperConfig<?> config, Annotated ann) {
        JsonTypeResolver a = this._findAnnotation(ann, JsonTypeResolver.class);
        return a == null ? a : a.value();
    }

    @Override
    public Object findTypeIdResolver(MapperConfig<?> config, Annotated ann) {
        JsonTypeIdResolver a = this._findAnnotation(ann, JsonTypeIdResolver.class);
        return a == null ? a : a.value();
    }

    @Override
    public List<NamedType> findSubtypes(MapperConfig<?> config, Annotated a) {
        Class clazz;
        JsonSubTypes t = this._findAnnotation(a, JsonSubTypes.class);
        if (t != null) {
            return this.findSubtypesByJsonSubTypesAnnotation(config, a, t);
        }
        AnnotatedElement annotatedElement = a.getAnnotated();
        if (annotatedElement instanceof Class && (clazz = (Class)annotatedElement).isSealed() && clazz.getPermittedSubclasses().length > 0) {
            return this.findSubtypesByPermittedSubclasses(config, a, clazz);
        }
        return null;
    }

    private List<NamedType> findSubtypesByJsonSubTypesAnnotation(MapperConfig<?> config, Annotated a, JsonSubTypes t) {
        JsonSubTypes.Type[] types = t.value();
        if (t.failOnRepeatedNames()) {
            return this.findSubtypesByJsonSubTypesAnnotationCheckRepeatedNames(a.getName(), types);
        }
        ArrayList<NamedType> result = new ArrayList<NamedType>(types.length);
        for (JsonSubTypes.Type type : types) {
            result.add(new NamedType(type.value(), type.name()));
            for (String name : type.names()) {
                result.add(new NamedType(type.value(), name));
            }
        }
        return result;
    }

    private List<NamedType> findSubtypesByJsonSubTypesAnnotationCheckRepeatedNames(String annotatedTypeName, JsonSubTypes.Type[] types) {
        ArrayList<NamedType> result = new ArrayList<NamedType>(types.length);
        HashSet<String> seenNames = new HashSet<String>();
        for (JsonSubTypes.Type type : types) {
            String typeName = type.name();
            if (!typeName.isEmpty() && seenNames.contains(typeName)) {
                throw new IllegalArgumentException("Annotated type [" + annotatedTypeName + "] got repeated subtype name [" + typeName + "]");
            }
            seenNames.add(typeName);
            result.add(new NamedType(type.value(), typeName));
            for (String altName : type.names()) {
                if (!altName.isEmpty() && seenNames.contains(altName)) {
                    throw new IllegalArgumentException("Annotated type [" + annotatedTypeName + "] got repeated subtype name [" + altName + "]");
                }
                seenNames.add(altName);
                result.add(new NamedType(type.value(), altName));
            }
        }
        return result;
    }

    private List<NamedType> findSubtypesByPermittedSubclasses(MapperConfig<?> config, Annotated a, Class<?> clazz) {
        Class<?>[] subtypes = clazz.getPermittedSubclasses();
        ArrayList<NamedType> result = new ArrayList<NamedType>(subtypes.length);
        for (Class<?> subtype : subtypes) {
            result.add(new NamedType(subtype));
        }
        return result;
    }

    @Override
    public String findTypeName(MapperConfig<?> config, AnnotatedClass ac) {
        JsonTypeName tn = this._findAnnotation(ac, JsonTypeName.class);
        return tn == null ? null : tn.value();
    }

    @Override
    public Boolean isTypeId(MapperConfig<?> config, AnnotatedMember member) {
        return this._hasAnnotation(member, JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(MapperConfig<?> config, Annotated ann) {
        JsonIdentityInfo info = this._findAnnotation(ann, JsonIdentityInfo.class);
        if (info == null || info.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName name = PropertyName.construct(info.property());
        return new ObjectIdInfo(name, info.scope(), info.generator(), info.resolver());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(MapperConfig<?> config, Annotated ann, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference ref = this._findAnnotation(ann, JsonIdentityReference.class);
        if (ref == null) {
            return objectIdInfo;
        }
        if (objectIdInfo == null) {
            objectIdInfo = ObjectIdInfo.empty();
        }
        return objectIdInfo.withAlwaysAsId(ref.alwaysAsId());
    }

    @Override
    public Object findSerializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        if (ann != null && (serClass = ann.using()) != ValueSerializer.None.class) {
            return serClass;
        }
        JsonRawValue annRaw = this._findAnnotation(a, JsonRawValue.class);
        if (annRaw != null && annRaw.value()) {
            Class<?> cls = a.getRawType();
            return new RawSerializer(cls);
        }
        return null;
    }

    @Override
    public Object findKeySerializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        if (ann != null && (serClass = ann.keyUsing()) != ValueSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Object findContentSerializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        if (ann != null && (serClass = ann.contentUsing()) != ValueSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueSerializer> serClass;
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        if (ann != null && (serClass = ann.nullsUsing()) != ValueSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Annotated a) {
        JsonInclude inc = this._findAnnotation(a, JsonInclude.class);
        JsonInclude.Value value = inc == null ? JsonInclude.Value.empty() : JsonInclude.Value.from((JsonInclude)inc);
        return value;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(MapperConfig<?> config, Annotated a) {
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Object findSerializationConverter(MapperConfig<?> config, Annotated a) {
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        JsonSerialize ann = this._findAnnotation(a, JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        JavaType contentType;
        Class<?> currRaw;
        JsonSerializeAs jsonSerAs;
        JsonSerialize jsonSer;
        TypeFactory tf;
        JavaType type;
        block29: {
            Class<?> serClass;
            type = baseType;
            tf = config.getTypeFactory();
            jsonSer = this._findAnnotation(a, JsonSerialize.class);
            jsonSerAs = this._findAnnotation(a, JsonSerializeAs.class);
            Class<?> clazz = serClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.as());
            if (serClass == null && jsonSerAs != null) {
                serClass = this._classIfExplicit(jsonSerAs.value());
            }
            if (serClass != null) {
                if (type.hasRawClass(serClass)) {
                    type = type.withStaticTyping();
                } else {
                    Class<?> currRaw2 = type.getRawClass();
                    try {
                        if (serClass.isAssignableFrom(currRaw2)) {
                            type = tf.constructGeneralizedType(type, serClass);
                            break block29;
                        }
                        if (currRaw2.isAssignableFrom(serClass)) {
                            type = tf.constructSpecializedType(type, serClass);
                            break block29;
                        }
                        if (this._primitiveAndWrapper(currRaw2, serClass)) {
                            type = type.withStaticTyping();
                            break block29;
                        }
                        throw this._databindException(String.format("Cannot refine serialization type %s into %s; types not related", type, serClass.getName()));
                    }
                    catch (IllegalArgumentException iae) {
                        throw this._databindException(iae, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", type, serClass.getName(), a.getName(), iae.getMessage()));
                    }
                }
            }
        }
        if (type.isMapLikeType()) {
            Class<?> keyClass;
            JavaType keyType = type.getKeyType();
            Class<?> clazz = keyClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.keyAs());
            if (keyClass == null && jsonSerAs != null) {
                keyClass = this._classIfExplicit(jsonSerAs.key());
            }
            if (keyClass != null) {
                block30: {
                    if (keyType.hasRawClass(keyClass)) {
                        keyType = keyType.withStaticTyping();
                    } else {
                        currRaw = keyType.getRawClass();
                        try {
                            if (keyClass.isAssignableFrom(currRaw)) {
                                keyType = tf.constructGeneralizedType(keyType, keyClass);
                                break block30;
                            }
                            if (currRaw.isAssignableFrom(keyClass)) {
                                keyType = tf.constructSpecializedType(keyType, keyClass);
                                break block30;
                            }
                            if (this._primitiveAndWrapper(currRaw, keyClass)) {
                                keyType = keyType.withStaticTyping();
                                break block30;
                            }
                            throw this._databindException(String.format("Cannot refine serialization key type %s into %s; types not related", keyType, keyClass.getName()));
                        }
                        catch (IllegalArgumentException iae) {
                            throw this._databindException(iae, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", type, keyClass.getName(), a.getName(), iae.getMessage()));
                        }
                    }
                }
                type = ((MapLikeType)type).withKeyType(keyType);
            }
        }
        if ((contentType = type.getContentType()) != null) {
            Class<?> contentClass;
            Class<?> clazz = contentClass = jsonSer == null ? null : this._classIfExplicit(jsonSer.contentAs());
            if (contentClass == null && jsonSerAs != null) {
                contentClass = this._classIfExplicit(jsonSerAs.content());
            }
            if (contentClass != null) {
                block31: {
                    if (contentType.hasRawClass(contentClass)) {
                        contentType = contentType.withStaticTyping();
                    } else {
                        currRaw = contentType.getRawClass();
                        try {
                            if (contentClass.isAssignableFrom(currRaw)) {
                                contentType = tf.constructGeneralizedType(contentType, contentClass);
                                break block31;
                            }
                            if (currRaw.isAssignableFrom(contentClass)) {
                                contentType = tf.constructSpecializedType(contentType, contentClass);
                                break block31;
                            }
                            if (this._primitiveAndWrapper(currRaw, contentClass)) {
                                contentType = contentType.withStaticTyping();
                                break block31;
                            }
                            throw this._databindException(String.format("Cannot refine serialization content type %s into %s; types not related", contentType, contentClass.getName()));
                        }
                        catch (IllegalArgumentException iae) {
                            throw this._databindException(iae, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", type, contentClass.getName(), a.getName(), iae.getMessage()));
                        }
                    }
                }
                type = type.withContentType(contentType);
            }
        }
        return type;
    }

    @Override
    public String[] findSerializationPropertyOrder(MapperConfig<?> config, AnnotatedClass ac) {
        JsonPropertyOrder order = this._findAnnotation(ac, JsonPropertyOrder.class);
        return order == null ? null : order.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(MapperConfig<?> config, Annotated ann) {
        return this._findSortAlpha(ann);
    }

    private final Boolean _findSortAlpha(Annotated ann) {
        JsonPropertyOrder order = this._findAnnotation(ann, JsonPropertyOrder.class);
        if (order != null && order.alphabetic()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        JsonAppend ann = this._findAnnotation(ac, JsonAppend.class);
        if (ann == null) {
            return;
        }
        boolean prepend = ann.prepend();
        JavaType propType = null;
        JsonAppend.Attr[] attrs = ann.attrs();
        int len = attrs.length;
        for (int i = 0; i < len; ++i) {
            if (propType == null) {
                propType = config.constructType(Object.class);
            }
            BeanPropertyWriter bpw = this._constructVirtualProperty(attrs[i], config, ac, propType);
            if (prepend) {
                properties.add(i, bpw);
                continue;
            }
            properties.add(bpw);
        }
        JsonAppend.Prop[] props = ann.props();
        int len2 = props.length;
        for (int i = 0; i < len2; ++i) {
            BeanPropertyWriter bpw = this._constructVirtualProperty(props[i], config, ac);
            if (prepend) {
                properties.add(i, bpw);
                continue;
            }
            properties.add(bpw);
        }
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Attr attr, MapperConfig<?> config, AnnotatedClass ac, JavaType type) {
        PropertyMetadata metadata = attr.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        String attrName = attr.value();
        PropertyName propName = this._propertyName(attr.propName(), attr.propNamespace());
        if (!propName.hasSimpleName()) {
            propName = PropertyName.construct(attrName);
        }
        VirtualAnnotatedMember member = new VirtualAnnotatedMember(ac, ac.getRawType(), attrName, type);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, propName, metadata, attr.include());
        return AttributePropertyWriter.construct(attrName, propDef, ac.getAnnotations(), type);
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop prop, MapperConfig<?> config, AnnotatedClass ac) {
        VirtualBeanPropertyWriter bpw;
        PropertyMetadata metadata = prop.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        PropertyName propName = this._propertyName(prop.name(), prop.namespace());
        JavaType type = config.constructType(prop.type());
        VirtualAnnotatedMember member = new VirtualAnnotatedMember(ac, ac.getRawType(), propName.getSimpleName(), type);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, propName, metadata, prop.include());
        Class<? extends VirtualBeanPropertyWriter> implClass = prop.value();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        VirtualBeanPropertyWriter virtualBeanPropertyWriter = bpw = hi == null ? null : hi.virtualPropertyWriterInstance(config, implClass);
        if (bpw == null) {
            bpw = ClassUtil.createInstance(implClass, config.canOverrideAccessModifiers());
        }
        return bpw.withConfig(config, ac, propDef, type);
    }

    @Override
    public PropertyName findNameForSerialization(MapperConfig<?> config, Annotated a) {
        JsonProperty pann;
        boolean useDefault = false;
        JsonGetter jg = this._findAnnotation(a, JsonGetter.class);
        if (jg != null) {
            String s = jg.value();
            if (!s.isEmpty()) {
                return PropertyName.construct(s);
            }
            useDefault = true;
        }
        if ((pann = this._findAnnotation(a, JsonProperty.class)) != null) {
            String ns = pann.namespace();
            if (ns != null && ns.isEmpty()) {
                ns = null;
            }
            return PropertyName.construct(pann.value(), ns);
        }
        if (useDefault || this._hasOneOf(a, ANNOTATIONS_TO_INFER_SER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> config, Annotated a) {
        JsonKey ann = this._findAnnotation(a, JsonKey.class);
        if (ann == null) {
            return null;
        }
        return ann.value();
    }

    @Override
    public Boolean hasAsValue(MapperConfig<?> config, Annotated a) {
        JsonValue ann = this._findAnnotation(a, JsonValue.class);
        if (ann == null) {
            return null;
        }
        return ann.value();
    }

    @Override
    public Boolean hasAnyGetter(MapperConfig<?> config, Annotated a) {
        JsonAnyGetter ann = this._findAnnotation(a, JsonAnyGetter.class);
        if (ann == null) {
            return null;
        }
        return ann.enabled();
    }

    @Override
    public Object findDeserializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.using()) != ValueDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(MapperConfig<?> config, Annotated a) {
        Class<? extends KeyDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.keyUsing()) != KeyDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findContentDeserializer(MapperConfig<?> config, Annotated a) {
        Class<? extends ValueDeserializer> deserClass;
        JsonDeserialize ann = this._findAnnotation(a, JsonDeserialize.class);
        if (ann != null && (deserClass = ann.contentUsing()) != ValueDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(MapperConfig<?> config, Annotated a) {
        JsonDeserialize ann = this._findAnnotation(a, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        JsonDeserialize ann = this._findAnnotation(a, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        JavaType contentType;
        Class<?> valueClass;
        JavaType type = baseType;
        TypeFactory tf = config.getTypeFactory();
        JsonDeserialize jsonDeser = this._findAnnotation(a, JsonDeserialize.class);
        JsonDeserializeAs jsonDeserAs = this._findAnnotation(a, JsonDeserializeAs.class);
        Class<?> clazz = valueClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.as());
        if (valueClass == null && jsonDeserAs != null) {
            valueClass = this._classIfExplicit(jsonDeserAs.value());
        }
        if (valueClass != null && !type.hasRawClass(valueClass) && !this._primitiveAndWrapper(type, valueClass)) {
            try {
                type = tf.constructSpecializedType(type, valueClass);
            }
            catch (IllegalArgumentException iae) {
                throw this._databindException(iae, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", type, valueClass.getName(), a.getName(), iae.getMessage()));
            }
        }
        if (type.isMapLikeType()) {
            Class<?> keyClass;
            JavaType keyType = type.getKeyType();
            Class<?> clazz2 = keyClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.keyAs());
            if (keyClass == null && jsonDeserAs != null) {
                keyClass = this._classIfExplicit(jsonDeserAs.keys());
            }
            if (keyClass != null && !this._primitiveAndWrapper(keyType, keyClass)) {
                try {
                    keyType = tf.constructSpecializedType(keyType, keyClass);
                    type = ((MapLikeType)type).withKeyType(keyType);
                }
                catch (IllegalArgumentException iae) {
                    throw this._databindException(iae, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", type, keyClass.getName(), a.getName(), iae.getMessage()));
                }
            }
        }
        if ((contentType = type.getContentType()) != null) {
            Class<?> contentClass;
            Class<?> clazz3 = contentClass = jsonDeser == null ? null : this._classIfExplicit(jsonDeser.contentAs());
            if (contentClass == null && jsonDeserAs != null) {
                contentClass = this._classIfExplicit(jsonDeserAs.content());
            }
            if (contentClass != null && !this._primitiveAndWrapper(contentType, contentClass)) {
                try {
                    contentType = tf.constructSpecializedType(contentType, contentClass);
                    type = type.withContentType(contentType);
                }
                catch (IllegalArgumentException iae) {
                    throw this._databindException(iae, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", type, contentClass.getName(), a.getName(), iae.getMessage()));
                }
            }
        }
        return type;
    }

    @Override
    public Object findValueInstantiator(MapperConfig<?> config, AnnotatedClass ac) {
        JsonValueInstantiator ann = this._findAnnotation(ac, JsonValueInstantiator.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Class<?> findPOJOBuilder(MapperConfig<?> config, AnnotatedClass ac) {
        JsonDeserialize ann = this._findAnnotation(ac, JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(MapperConfig<?> config, AnnotatedClass ac) {
        JsonPOJOBuilder ann = this._findAnnotation(ac, JsonPOJOBuilder.class);
        return ann == null ? null : new JsonPOJOBuilder.Value(ann);
    }

    @Override
    public String findBuilderPrefix(MapperConfig<?> config, AnnotatedClass valueClass) {
        String prefix;
        JsonDeserialize ann = this._findAnnotation(valueClass, JsonDeserialize.class);
        if (ann != null && !"\u0000".equals(prefix = ann.builderPrefix())) {
            return prefix;
        }
        return null;
    }

    @Override
    public PropertyName findNameForDeserialization(MapperConfig<?> config, Annotated a) {
        JsonProperty pann;
        boolean useDefault = false;
        JsonSetter js = this._findAnnotation(a, JsonSetter.class);
        if (js != null) {
            String s = js.value();
            if (s.isEmpty()) {
                useDefault = true;
            } else {
                return PropertyName.construct(s);
            }
        }
        if ((pann = this._findAnnotation(a, JsonProperty.class)) != null) {
            String ns = pann.namespace();
            if (ns != null && ns.isEmpty()) {
                ns = null;
            }
            return PropertyName.construct(pann.value(), ns);
        }
        if (useDefault || this._hasOneOf(a, ANNOTATIONS_TO_INFER_DESER)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAnySetter(MapperConfig<?> config, Annotated a) {
        JsonAnySetter ann = this._findAnnotation(a, JsonAnySetter.class);
        return ann == null ? null : Boolean.valueOf(ann.enabled());
    }

    @Override
    public JsonSetter.Value findSetterInfo(MapperConfig<?> config, Annotated a) {
        return JsonSetter.Value.from((JsonSetter)this._findAnnotation(a, JsonSetter.class));
    }

    @Override
    public Boolean findMergeInfo(MapperConfig<?> config, Annotated a) {
        JsonMerge ann = this._findAnnotation(a, JsonMerge.class);
        return ann == null ? null : ann.value().asBoolean();
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        Boolean b;
        JsonCreator.Mode mode;
        JsonCreator ann = this._findAnnotation(a, JsonCreator.class);
        if (ann == null) {
            mode = null;
        } else {
            mode = ann.mode();
            if (mode != JsonCreator.Mode.DEFAULT) {
                return mode;
            }
        }
        if (this._cfgConstructorPropertiesImpliesCreator && config.isEnabled(MapperFeature.INFER_CREATOR_FROM_CONSTRUCTOR_PROPERTIES) && _javaBeansHelper != null && (b = _javaBeansHelper.hasCreatorAnnotation(a)) != null && b.booleanValue()) {
            return JsonCreator.Mode.PROPERTIES;
        }
        return mode;
    }

    protected boolean _isIgnorable(Annotated a) {
        Boolean b;
        JsonIgnore ann = this._findAnnotation(a, JsonIgnore.class);
        if (ann != null) {
            return ann.value();
        }
        if (_javaBeansHelper != null && (b = _javaBeansHelper.findTransient(a)) != null) {
            return b;
        }
        return false;
    }

    protected Class<?> _classIfExplicit(Class<?> cls) {
        if (cls == null || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected Class<?> _classIfExplicit(Class<?> cls, Class<?> implicit) {
        return (cls = this._classIfExplicit(cls)) == null || cls == implicit ? null : cls;
    }

    protected PropertyName _propertyName(String localName, String namespace) {
        if (localName.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (namespace == null || namespace.isEmpty()) {
            return PropertyName.construct(localName);
        }
        return PropertyName.construct(localName, namespace);
    }

    private boolean _primitiveAndWrapper(Class<?> baseType, Class<?> refinement) {
        if (baseType.isPrimitive()) {
            return baseType == ClassUtil.primitiveType(refinement);
        }
        if (refinement.isPrimitive()) {
            return refinement == ClassUtil.primitiveType(baseType);
        }
        return false;
    }

    private boolean _primitiveAndWrapper(JavaType baseType, Class<?> refinement) {
        if (baseType.isPrimitive()) {
            return baseType.hasRawClass(ClassUtil.primitiveType(refinement));
        }
        if (refinement.isPrimitive()) {
            return refinement == ClassUtil.primitiveType(baseType.getRawClass());
        }
        return false;
    }

    private DatabindException _databindException(String msg) {
        return DatabindException.from((JsonParser)null, msg);
    }

    private DatabindException _databindException(Throwable t, String msg) {
        return DatabindException.from((JsonParser)null, msg, t);
    }

    static {
        JavaBeansAnnotations x = null;
        try {
            x = JavaBeansAnnotations.instance();
        }
        catch (Throwable t) {
            ExceptionUtil.rethrowIfFatal(t);
        }
        _javaBeansHelper = x;
    }
}

