/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.util.ClassUtil;

public class EnumNamingStrategyFactory {
    public static EnumNamingStrategy createEnumNamingStrategyInstance(Object namingDef, boolean canOverrideAccessModifiers, EnumNamingStrategy defaultNamingStrategy) {
        if (namingDef == null) {
            return defaultNamingStrategy;
        }
        if (namingDef instanceof EnumNamingStrategy) {
            EnumNamingStrategy strategy = (EnumNamingStrategy)namingDef;
            return strategy;
        }
        if (!(namingDef instanceof Class)) {
            throw new IllegalArgumentException(String.format("AnnotationIntrospector returned EnumNamingStrategy definition of type %s; expected type `Class<EnumNamingStrategy>` instead", ClassUtil.classNameOf(namingDef)));
        }
        Class namingClass = (Class)namingDef;
        if (namingClass == EnumNamingStrategy.class) {
            return null;
        }
        if (!EnumNamingStrategy.class.isAssignableFrom(namingClass)) {
            throw new IllegalArgumentException(String.format("Problem with AnnotationIntrospector returned Class %s; expected `Class<EnumNamingStrategy>`", ClassUtil.classNameOf(namingClass)));
        }
        return (EnumNamingStrategy)ClassUtil.createInstance(namingClass, canOverrideAccessModifiers);
    }
}

