/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.ser.InstantSerializerBase;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;

public class ZonedDateTimeSerializer
extends InstantSerializerBase<ZonedDateTime> {
    public static final ZonedDateTimeSerializer INSTANCE = new ZonedDateTimeSerializer();
    protected final Boolean _writeZoneId;

    protected ZonedDateTimeSerializer() {
        this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public ZonedDateTimeSerializer(DateTimeFormatter formatter) {
        super(ZonedDateTime.class, (T dt) -> dt.toInstant().toEpochMilli(), ChronoZonedDateTime::toEpochSecond, ZonedDateTime::getNano, formatter);
        this._writeZoneId = null;
    }

    protected ZonedDateTimeSerializer(ZonedDateTimeSerializer base, DateTimeFormatter formatter, Boolean useTimestamp, Boolean useNanoseconds, Boolean writeZoneId, JsonFormat.Shape shape) {
        super(base, formatter, useTimestamp, useNanoseconds, shape);
        this._writeZoneId = writeZoneId;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFormat(DateTimeFormatter formatter, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new ZonedDateTimeSerializer(this, formatter, useTimestamp, this._useNanoseconds, this._writeZoneId, shape);
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean useNanoseconds) {
        return new ZonedDateTimeSerializer(this, this._formatter, this._useTimestamp, useNanoseconds, writeZoneId, this._shape);
    }

    @Override
    public void serialize(ZonedDateTime value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (!this.useTimestamp(ctxt) && (this._formatter == null || this._shape != JsonFormat.Shape.STRING) && this.shouldWriteWithZoneId(ctxt)) {
            if (ctxt.isEnabled(DateTimeFeature.TRUNCATE_TO_MSECS_ON_WRITE)) {
                value = value.truncatedTo(ChronoUnit.MILLIS);
            }
            g.writeString(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value));
            return;
        }
        super.serialize(value, g, ctxt);
    }

    @Override
    protected String formatValue(ZonedDateTime value, SerializationContext ctxt) {
        Object formatted = super.formatValue(value, ctxt);
        if (this._formatter != null && this._shape == JsonFormat.Shape.STRING && Boolean.TRUE.equals(this._writeZoneId)) {
            formatted = (String)formatted + "[" + value.getZone().getId() + "]";
        }
        return formatted;
    }

    public boolean shouldWriteWithZoneId(SerializationContext ctxt) {
        return this._writeZoneId != null ? this._writeZoneId.booleanValue() : ctxt.isEnabled(DateTimeFeature.WRITE_DATES_WITH_ZONE_ID);
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        if (!this.useTimestamp(ctxt) && this.shouldWriteWithZoneId(ctxt)) {
            return JsonToken.VALUE_STRING;
        }
        return super.serializationShape(ctxt);
    }
}

