/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.deser.JSR310DateTimeDeserializerBase;

public class OffsetTimeDeserializer
extends JSR310DateTimeDeserializerBase<OffsetTime> {
    public static final OffsetTimeDeserializer INSTANCE = new OffsetTimeDeserializer();
    protected final Boolean _readTimestampsAsNanosOverride;

    protected OffsetTimeDeserializer() {
        this(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    protected OffsetTimeDeserializer(DateTimeFormatter dtf) {
        super(OffsetTime.class, dtf);
        this._readTimestampsAsNanosOverride = null;
    }

    protected OffsetTimeDeserializer(OffsetTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
    }

    protected OffsetTimeDeserializer(OffsetTimeDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape, Boolean readTimestampsAsNanosOverride) {
        super(base, leniency, formatter, shape);
        this._readTimestampsAsNanosOverride = readTimestampsAsNanosOverride;
    }

    protected OffsetTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new OffsetTimeDeserializer(this, this._isLenient, dtf, this._shape, this._readTimestampsAsNanosOverride);
    }

    @Override
    protected OffsetTimeDeserializer withLeniency(Boolean leniency) {
        return new OffsetTimeDeserializer(this, leniency);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext ctxt, BeanProperty property, JsonFormat.Value formatOverrides) {
        OffsetTimeDeserializer deser = (OffsetTimeDeserializer)super._withFormatOverrides(ctxt, property, formatOverrides);
        Boolean readTimestampsAsNanosOverride = formatOverrides.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(readTimestampsAsNanosOverride, deser._readTimestampsAsNanosOverride)) {
            return new OffsetTimeDeserializer(deser, deser._isLenient, deser._formatter, deser._shape, readTimestampsAsNanosOverride);
        }
        return deser;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OffsetTime deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        OffsetTime result;
        block20: {
            if (p.hasToken(JsonToken.VALUE_STRING)) {
                result = this._fromString(p, ctxt, p.getString());
            } else if (p.isExpectedStartObjectToken()) {
                String str = ctxt.extractScalarFromObject(p, this, this.handledType());
                if (str == null) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.START_ARRAY, "Expected array or string");
                }
                result = this._fromString(p, ctxt, str);
            } else {
                if (!p.isExpectedStartArrayToken()) {
                    if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                        result = (OffsetTime)p.getEmbeddedObject();
                        break block20;
                    } else {
                        if (!p.hasToken(JsonToken.VALUE_NUMBER_INT)) throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.START_ARRAY, "Expected array or string");
                        return (OffsetTime)this._throwNoNumericTimestampNeedTimeZone(p, ctxt);
                    }
                }
                JsonToken t = p.nextToken();
                if (t != JsonToken.VALUE_NUMBER_INT) {
                    if (t == JsonToken.END_ARRAY) {
                        return null;
                    }
                    if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                        OffsetTime parsed = this.deserialize(p, ctxt);
                        if (p.nextToken() == JsonToken.END_ARRAY) return parsed;
                        this.handleMissingEndArrayForSingle(p, ctxt);
                        return parsed;
                    }
                    result = (OffsetTime)ctxt.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", t);
                }
                int hour = p.getIntValue();
                int minute = p.nextIntValue(-1);
                if (minute == -1) {
                    t = p.currentToken();
                    if (t == JsonToken.END_ARRAY) {
                        return null;
                    }
                    if (t == JsonToken.VALUE_NUMBER_INT) {
                        minute = p.getIntValue();
                    } else {
                        result = (OffsetTime)this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, "minutes");
                    }
                }
                int partialSecond = 0;
                int second = 0;
                if (p.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                    second = p.getIntValue();
                    if (p.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                        partialSecond = p.getIntValue();
                        if (partialSecond < 1000 && !this.shouldReadTimestampsAsNanoseconds(ctxt)) {
                            partialSecond *= 1000000;
                        }
                        p.nextToken();
                    }
                }
                if (p.currentToken() != JsonToken.VALUE_STRING) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.VALUE_STRING, "Expected string for TimeZone after numeric values");
                }
                result = OffsetTime.of(hour, minute, second, partialSecond, ZoneOffset.of(p.getString()));
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this._reportWrongToken(ctxt, JsonToken.END_ARRAY, "timezone");
                }
            }
        }
        if (result == null) return result;
        if (!ctxt.isEnabled(DateTimeFeature.TRUNCATE_TO_MSECS_ON_READ)) return result;
        return result.truncatedTo(ChronoUnit.MILLIS);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext context) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : context.isEnabled(DateTimeFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected OffsetTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws JacksonException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (OffsetTime)this._fromEmptyString(p, ctxt, string);
        }
        try {
            return OffsetTime.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (OffsetTime)this._handleDateTimeFormatException(ctxt, e, this._formatter, string);
        }
    }
}

