/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.exc;

import java.util.Collection;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.exc.PropertyBindingException;

public class UnrecognizedPropertyException
extends PropertyBindingException {
    private static final long serialVersionUID = 1L;

    public UnrecognizedPropertyException(JsonParser p, String msg, TokenStreamLocation loc, Class<?> referringClass, String propName, Collection<Object> propertyIds) {
        super(p, msg, loc, referringClass, propName, propertyIds);
    }

    public static UnrecognizedPropertyException from(JsonParser p, Object fromObjectOrClass, String propertyName, Collection<Object> propertyIds) {
        Class class1;
        Class ref = fromObjectOrClass instanceof Class ? (class1 = (Class)fromObjectOrClass) : fromObjectOrClass.getClass();
        String msg = String.format("Unrecognized property \"%s\" (class %s), not marked as ignorable", propertyName, ref.getName());
        UnrecognizedPropertyException e = new UnrecognizedPropertyException(p, msg, p.currentLocation(), ref, propertyName, propertyIds);
        e.prependPath(fromObjectOrClass, propertyName);
        return e;
    }
}

