/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import java.math.BigInteger;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdScalarDeserializer;
import tools.jackson.databind.util.ClassUtil;

public class FromStringWithRadixToNumberDeserializer
extends StdScalarDeserializer<Number> {
    private final int radix;

    public FromStringWithRadixToNumberDeserializer(StdScalarDeserializer<?> src, int radix) {
        super(src);
        this.radix = radix;
    }

    @Override
    public Number deserialize(JsonParser p, DeserializationContext ctxt) {
        Class<?> handledType = this.handledType();
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            ctxt.reportInputMismatch(handledType, "Need String when deserializing a value using `FromStringWithRadixToNumberDeserializer` (radix: %d)", this.radix);
        }
        String text = p.getString();
        p.streamReadConstraints().validateIntegerLength(text.length());
        try {
            if (handledType.equals(BigInteger.class)) {
                return new BigInteger(text, this.radix);
            }
            Class<?> primitiveType = ClassUtil.primitiveType(handledType);
            if (primitiveType == Long.TYPE) {
                return Long.parseLong(text, this.radix);
            }
            if (primitiveType == Integer.TYPE) {
                return Integer.parseInt(text, this.radix);
            }
            if (primitiveType == Short.TYPE) {
                return Short.parseShort(text, this.radix);
            }
            if (primitiveType == Byte.TYPE) {
                return Byte.parseByte(text, this.radix);
            }
        }
        catch (IllegalArgumentException iae) {
            return (Number)ctxt.handleWeirdStringValue(handledType, text, "not a valid representation of %s value with radix %d", ClassUtil.nameOf(handledType), this.radix);
        }
        return (Number)ctxt.reportInputMismatch(handledType, "Trying to deserialize a non-whole number with `NumberToStringWithRadixSerializer`", new Object[0]);
    }
}

