/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.TokenBuffer;

public class UnwrappedPropertyHandler {
    public static final String JSON_UNWRAPPED_NAME_PREFIX = "@JsonUnwrapped/";
    protected final List<SettableBeanProperty> _creatorProperties;
    protected final List<SettableBeanProperty> _properties;
    protected final Set<String> _unwrappedPropertyNames;
    protected final boolean _hasUnwrappedAnySetter;

    public UnwrappedPropertyHandler() {
        this._creatorProperties = new ArrayList<SettableBeanProperty>();
        this._properties = new ArrayList<SettableBeanProperty>();
        this._unwrappedPropertyNames = Collections.emptySet();
        this._hasUnwrappedAnySetter = false;
    }

    protected UnwrappedPropertyHandler(List<SettableBeanProperty> creatorProps, List<SettableBeanProperty> props, Set<String> unwrappedPropertyNames, boolean hasUnwrappedAnySetter) {
        this._creatorProperties = creatorProps;
        this._properties = props;
        this._unwrappedPropertyNames = unwrappedPropertyNames;
        this._hasUnwrappedAnySetter = hasUnwrappedAnySetter;
    }

    public UnwrappedPropertyHandler initializeUnwrappedPropertyNames() {
        HashSet<String> unwrappedNames = new HashSet<String>();
        boolean hasAnySetter = this._collectUnwrappedPropertyNames(this._properties, this._creatorProperties, unwrappedNames);
        return new UnwrappedPropertyHandler(this._creatorProperties, this._properties, unwrappedNames, hasAnySetter);
    }

    public void addCreatorProperty(SettableBeanProperty property) {
        this._creatorProperties.add(property);
    }

    public void addProperty(SettableBeanProperty property) {
        this._properties.add(property);
    }

    public UnwrappedPropertyHandler renameAll(DeserializationContext ctxt, NameTransformer transformer) {
        List<SettableBeanProperty> renamedCreatorProps = this.renameProperties(ctxt, this._creatorProperties, transformer);
        List<SettableBeanProperty> renamedProps = this.renameProperties(ctxt, this._properties, transformer);
        HashSet<String> names = new HashSet<String>();
        boolean hasAnySetter = this._collectUnwrappedPropertyNames(renamedProps, renamedCreatorProps, names);
        return new UnwrappedPropertyHandler(renamedCreatorProps, renamedProps, names, hasAnySetter);
    }

    private List<SettableBeanProperty> renameProperties(DeserializationContext ctxt, Collection<SettableBeanProperty> properties, NameTransformer transformer) {
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(properties.size());
        for (SettableBeanProperty prop : properties) {
            if (prop == null) {
                newProps.add(null);
                continue;
            }
            newProps.add(prop.unwrapped(ctxt, transformer));
        }
        return newProps;
    }

    public PropertyValueBuffer processUnwrappedCreatorProperties(JsonParser originalParser, DeserializationContext ctxt, PropertyValueBuffer values, TokenBuffer buffered) {
        for (SettableBeanProperty prop : this._creatorProperties) {
            JsonParser p = buffered.asParserOnFirstToken(ctxt);
            values.assignParameter(prop, prop.deserialize(p, ctxt));
        }
        return values;
    }

    public Object processUnwrapped(JsonParser originalParser, DeserializationContext ctxt, Object bean, TokenBuffer buffered, boolean hasUnwrappedContent) {
        if (hasUnwrappedContent || this._unwrappedPropertyNames.isEmpty() || !ctxt.isEnabled(DeserializationFeature.USE_NULL_FOR_EMPTY_UNWRAPPED)) {
            for (SettableBeanProperty prop : this._properties) {
                try (JsonParser p = buffered.asParserOnFirstToken(ctxt);){
                    prop.deserializeAndSet(p, ctxt, bean);
                }
            }
        }
        return bean;
    }

    @Deprecated
    public Object processUnwrapped(JsonParser originalParser, DeserializationContext ctxt, Object bean, TokenBuffer buffered) {
        return this.processUnwrapped(originalParser, ctxt, bean, buffered, true);
    }

    public static PropertyName creatorParamName(int index) {
        return new PropertyName(JSON_UNWRAPPED_NAME_PREFIX + index);
    }

    public boolean hasUnwrappedProperty(String propName) {
        if (this._hasUnwrappedAnySetter) {
            return true;
        }
        return this._unwrappedPropertyNames.contains(propName);
    }

    public void collectUnwrappedPropertyNamesTo(Set<String> names) {
        this._collectUnwrappedPropertyNames(this._properties, this._creatorProperties, names);
    }

    private boolean _collectUnwrappedPropertyNames(List<SettableBeanProperty> properties, List<SettableBeanProperty> creatorProperties, Set<String> names) {
        boolean hasAnySetter = false;
        for (SettableBeanProperty prop : properties) {
            if (!this._collectDeserializerPropertyNames(prop, names)) continue;
            hasAnySetter = true;
        }
        for (SettableBeanProperty prop : creatorProperties) {
            if (!this._collectDeserializerPropertyNames(prop, names)) continue;
            hasAnySetter = true;
        }
        return hasAnySetter;
    }

    private boolean _collectDeserializerPropertyNames(SettableBeanProperty prop, Set<String> names) {
        ValueDeserializer<Object> deser;
        if (prop != null && (deser = prop.getValueDeserializer()) instanceof BeanDeserializerBase) {
            BeanDeserializerBase bd = (BeanDeserializerBase)deser;
            bd.collectAllPropertyNamesTo(names);
            return bd.hasAnySetter();
        }
        return false;
    }
}

