/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.AbstractTypeResolver;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.BaseSettings;
import tools.jackson.databind.cfg.CacheProvider;
import tools.jackson.databind.cfg.CoercionConfigs;
import tools.jackson.databind.cfg.ConfigFeature;
import tools.jackson.databind.cfg.ConfigOverrides;
import tools.jackson.databind.cfg.ConstructorDetector;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.DefaultCacheProvider;
import tools.jackson.databind.cfg.DeserializationContexts;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.JsonNodeFeature;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.cfg.ModuleContextBase;
import tools.jackson.databind.cfg.MutableCoercionConfig;
import tools.jackson.databind.cfg.MutableConfigOverride;
import tools.jackson.databind.cfg.SerializationContexts;
import tools.jackson.databind.deser.BeanDeserializerFactory;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.ext.javatime.JavaTimeInitializer;
import tools.jackson.databind.introspect.AccessorNamingStrategy;
import tools.jackson.databind.introspect.BasicClassIntrospector;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import tools.jackson.databind.introspect.JacksonAnnotationIntrospector;
import tools.jackson.databind.introspect.MixInHandler;
import tools.jackson.databind.introspect.MixInResolver;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.jsontype.DefaultBaseTypeLimitingValidator;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.SubtypeResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeResolverProvider;
import tools.jackson.databind.jsontype.impl.DefaultTypeResolverBuilder;
import tools.jackson.databind.jsontype.impl.StdSubtypeResolver;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.ser.BeanSerializerFactory;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.type.TypeModifier;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.LinkedNode;
import tools.jackson.databind.util.RootNameLookup;
import tools.jackson.databind.util.StdDateFormat;

public abstract class MapperBuilder<M extends ObjectMapper, B extends MapperBuilder<M, B>> {
    protected static final long DEFAULT_MAPPER_FEATURES = MapperFeature.collectLongDefaults();
    protected static final int DEFAULT_SER_FEATURES = ConfigFeature.collectFeatureDefaults(SerializationFeature.class);
    protected static final int DEFAULT_DESER_FEATURES = ConfigFeature.collectFeatureDefaults(DeserializationFeature.class);
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final PolymorphicTypeValidator DEFAULT_TYPE_VALIDATOR = new DefaultBaseTypeLimitingValidator();
    protected static final AccessorNamingStrategy.Provider DEFAULT_ACCESSOR_NAMING = new DefaultAccessorNamingStrategy.Provider();
    protected static final BaseSettings DEFAULT_BASE_SETTINGS = new BaseSettings(DEFAULT_ANNOTATION_INTROSPECTOR, null, null, DEFAULT_ACCESSOR_NAMING, null, DEFAULT_TYPE_VALIDATOR, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant(), DefaultCacheProvider.defaultInstance(), JsonNodeFactory.instance, null);
    protected static final TypeResolverProvider DEFAULT_TYPE_RESOLVER_PROVIDER = new TypeResolverProvider();
    protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
    protected BaseSettings _baseSettings;
    protected TokenStreamFactory _streamFactory;
    protected final ConfigOverrides _configOverrides;
    protected final CoercionConfigs _coercionConfigs;
    protected Map<Object, JacksonModule> _modules;
    protected TypeFactory _typeFactory;
    protected ClassIntrospector _classIntrospector;
    protected TypeResolverProvider _typeResolverProvider;
    protected SubtypeResolver _subtypeResolver;
    protected MixInHandler _mixInHandler;
    protected SerializationContexts _serializationContexts;
    protected SerializerFactory _serializerFactory;
    protected FilterProvider _filterProvider;
    protected PrettyPrinter _defaultPrettyPrinter;
    protected DeserializationContexts _deserializationContexts;
    protected DeserializerFactory _deserializerFactory;
    protected InjectableValues _injectableValues;
    protected LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected AbstractTypeResolver[] _abstractTypeResolvers;
    protected ContextAttributes _defaultAttributes;
    protected Class<?> _defaultSerializationView;
    protected Class<?> _defaultDeserializationView;
    protected long _mapperFeatures;
    protected int _serFeatures;
    protected int _deserFeatures;
    protected DatatypeFeatures _datatypeFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected int _formatReadFeatures;
    protected int _formatWriteFeatures;
    protected transient MapperBuilderState _savedState;

    protected MapperBuilder(TokenStreamFactory streamFactory) {
        this._streamFactory = streamFactory;
        this._baseSettings = DEFAULT_BASE_SETTINGS;
        this._configOverrides = new ConfigOverrides();
        this._coercionConfigs = new CoercionConfigs();
        this._modules = null;
        this._streamReadFeatures = streamFactory.getStreamReadFeatures();
        this._streamWriteFeatures = streamFactory.getStreamWriteFeatures();
        this._formatReadFeatures = streamFactory.getFormatReadFeatures();
        this._formatWriteFeatures = streamFactory.getFormatWriteFeatures();
        this._mapperFeatures = DEFAULT_MAPPER_FEATURES;
        if (streamFactory.requiresPropertyOrdering()) {
            this._mapperFeatures |= MapperFeature.SORT_PROPERTIES_ALPHABETICALLY.getLongMask();
        }
        this._deserFeatures = DEFAULT_DESER_FEATURES;
        this._serFeatures = DEFAULT_SER_FEATURES;
        this._datatypeFeatures = DatatypeFeatures.defaultFeatures();
        this._typeFactory = null;
        this._classIntrospector = null;
        this._typeResolverProvider = null;
        this._subtypeResolver = null;
        this._mixInHandler = null;
        this._serializerFactory = null;
        this._serializationContexts = null;
        this._filterProvider = null;
        this._deserializerFactory = null;
        this._deserializationContexts = null;
        this._injectableValues = null;
        this._problemHandlers = null;
        this._abstractTypeResolvers = NO_ABSTRACT_TYPE_RESOLVERS;
        this._defaultAttributes = null;
        this._defaultSerializationView = null;
        this._defaultDeserializationView = null;
    }

    protected MapperBuilder(MapperBuilderState state) {
        this._streamFactory = state._streamFactory;
        this._baseSettings = state._baseSettings;
        this._configOverrides = (ConfigOverrides)Snapshottable.takeSnapshot((Snapshottable)state._configOverrides);
        this._coercionConfigs = (CoercionConfigs)Snapshottable.takeSnapshot((Snapshottable)state._coercionConfigs);
        this._streamReadFeatures = state._streamReadFeatures;
        this._streamWriteFeatures = state._streamWriteFeatures;
        this._formatReadFeatures = state._formatReadFeatures;
        this._formatWriteFeatures = state._formatWriteFeatures;
        this._mapperFeatures = state._mapperFeatures;
        this._deserFeatures = state._deserFeatures;
        this._serFeatures = state._serFeatures;
        this._datatypeFeatures = state._datatypeFeatures;
        this._typeFactory = (TypeFactory)Snapshottable.takeSnapshot((Snapshottable)state._typeFactory);
        this._classIntrospector = state._classIntrospector;
        this._typeResolverProvider = state._typeResolverProvider;
        this._subtypeResolver = (SubtypeResolver)Snapshottable.takeSnapshot((Snapshottable)state._subtypeResolver);
        this._mixInHandler = (MixInHandler)Snapshottable.takeSnapshot((Snapshottable)state._mixInHandler);
        this._serializationContexts = state._serializationContexts;
        this._serializerFactory = state._serializerFactory;
        this._filterProvider = state._filterProvider;
        this._defaultPrettyPrinter = state._defaultPrettyPrinter;
        this._deserializationContexts = state._deserializationContexts;
        this._deserializerFactory = state._deserializerFactory;
        this._injectableValues = (InjectableValues)Snapshottable.takeSnapshot((Snapshottable)state._injectableValues);
        this._problemHandlers = state._problemHandlers;
        this._abstractTypeResolvers = state._abstractTypeResolvers;
        this._defaultAttributes = (ContextAttributes)Snapshottable.takeSnapshot((Snapshottable)state._defaultAttributes);
        this._defaultSerializationView = state._defaultSerializationView;
        this._defaultDeserializationView = state._defaultDeserializationView;
        if (state._modules == null) {
            this._modules = null;
        } else {
            this._modules = new LinkedHashMap<Object, JacksonModule>();
            for (JacksonModule mod : state._modules) {
                this.addModule(mod);
            }
        }
    }

    public abstract M build();

    public MapperBuilderState saveStateApplyModules() {
        if (this._savedState == null) {
            this._savedState = this._saveState();
            ModuleContextBase ctxt = this._constructModuleContext();
            JavaTimeInitializer.getInstance().setupModule(ctxt);
            if (this._modules != null) {
                this._modules.values().forEach(m -> m.setupModule(ctxt));
                ctxt.applyChanges(this);
            }
        }
        return this._savedState;
    }

    protected ModuleContextBase _constructModuleContext() {
        return new ModuleContextBase(this, this._configOverrides);
    }

    protected abstract MapperBuilderState _saveState();

    public SerializationConfig buildSerializationConfig(ConfigOverrides configOverrides, MixInHandler mixins, TypeFactory tf, ClassIntrospector classIntr, SubtypeResolver str, RootNameLookup rootNames, FilterProvider filterProvider) {
        return new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._streamWriteFeatures, this._formatWriteFeatures, configOverrides, tf, classIntr, mixins, str, this.defaultAttributes(), rootNames, filterProvider);
    }

    public DeserializationConfig buildDeserializationConfig(ConfigOverrides configOverrides, MixInHandler mixins, TypeFactory tf, ClassIntrospector classIntr, SubtypeResolver str, RootNameLookup rootNames, CoercionConfigs coercionConfigs) {
        return new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._streamReadFeatures, this._formatReadFeatures, configOverrides, coercionConfigs, tf, classIntr, mixins, str, this.defaultAttributes(), rootNames, this._abstractTypeResolvers);
    }

    public boolean isEnabled(MapperFeature f) {
        return f.enabledIn(this._mapperFeatures);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return f.enabledIn(this._deserFeatures);
    }

    public boolean isEnabled(SerializationFeature f) {
        return f.enabledIn(this._serFeatures);
    }

    public boolean isEnabled(DatatypeFeature f) {
        return this._datatypeFeatures.isEnabled(f);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return f.enabledIn(this._streamReadFeatures);
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return f.enabledIn(this._streamWriteFeatures);
    }

    public DatatypeFeatures datatypeFeatures() {
        return this._datatypeFeatures;
    }

    public BaseSettings baseSettings() {
        return this._baseSettings;
    }

    public TokenStreamFactory streamFactory() {
        return this._streamFactory;
    }

    public AnnotationIntrospector annotationIntrospector() {
        return this._baseSettings.getAnnotationIntrospector();
    }

    public ContextAttributes defaultAttributes() {
        if (this._defaultAttributes == null) {
            return ContextAttributes.getEmpty();
        }
        return this._defaultAttributes;
    }

    protected ContextAttributes _defaultDefaultAttributes() {
        return ContextAttributes.getEmpty();
    }

    public TypeFactory typeFactory() {
        if (this._typeFactory == null) {
            this._typeFactory = this._defaultTypeFactory();
        }
        return this._typeFactory;
    }

    protected TypeFactory _defaultTypeFactory() {
        return TypeFactory.createDefaultInstance();
    }

    public ClassIntrospector classIntrospector() {
        if (this._classIntrospector == null) {
            this._classIntrospector = this._defaultClassIntrospector();
        }
        return this._classIntrospector;
    }

    protected ClassIntrospector _defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    public TypeResolverProvider typeResolverProvider() {
        if (this._typeResolverProvider == null) {
            this._typeResolverProvider = this._defaultTypeResolverProvider();
        }
        return this._typeResolverProvider;
    }

    protected TypeResolverProvider _defaultTypeResolverProvider() {
        return new TypeResolverProvider();
    }

    public SubtypeResolver subtypeResolver() {
        if (this._subtypeResolver == null) {
            this._subtypeResolver = this._defaultSubtypeResolver();
        }
        return this._subtypeResolver;
    }

    protected SubtypeResolver _defaultSubtypeResolver() {
        return new StdSubtypeResolver();
    }

    public MixInHandler mixInHandler() {
        if (this._mixInHandler == null) {
            this._mixInHandler = this._defaultMixInHandler();
        }
        return this._mixInHandler;
    }

    protected MixInHandler _defaultMixInHandler() {
        return new MixInHandler(null);
    }

    public SerializationContexts serializationContexts() {
        if (this._serializationContexts == null) {
            this._serializationContexts = this._defaultSerializationContexts();
        }
        return this._serializationContexts;
    }

    protected SerializationContexts _defaultSerializationContexts() {
        return new SerializationContexts.DefaultImpl();
    }

    public SerializerFactory serializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = this._defaultSerializerFactory();
        }
        return this._serializerFactory;
    }

    protected SerializerFactory _defaultSerializerFactory() {
        return BeanSerializerFactory.instance;
    }

    public FilterProvider filterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter defaultPrettyPrinter() {
        if (this._defaultPrettyPrinter == null) {
            this._defaultPrettyPrinter = this._defaultPrettyPrinter();
        }
        return this._defaultPrettyPrinter;
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return DEFAULT_PRETTY_PRINTER;
    }

    public Class<?> defaultSerializationView() {
        return this._defaultSerializationView;
    }

    public Class<?> defaultDeserializationView() {
        return this._defaultDeserializationView;
    }

    public DeserializationContexts deserializationContexts() {
        if (this._deserializationContexts == null) {
            this._deserializationContexts = this._defaultDeserializationContexts();
        }
        return this._deserializationContexts;
    }

    protected DeserializationContexts _defaultDeserializationContexts() {
        return new DeserializationContexts.DefaultImpl();
    }

    public DeserializerFactory deserializerFactory() {
        if (this._deserializerFactory == null) {
            this._deserializerFactory = this._defaultDeserializerFactory();
        }
        return this._deserializerFactory;
    }

    DeserializerFactory _defaultDeserializerFactory() {
        return BeanDeserializerFactory.instance;
    }

    public InjectableValues injectableValues() {
        return this._injectableValues;
    }

    public LinkedNode<DeserializationProblemHandler> deserializationProblemHandlers() {
        return this._problemHandlers;
    }

    public B enable(MapperFeature ... features) {
        for (MapperFeature f : features) {
            this._mapperFeatures |= f.getLongMask();
        }
        return this._this();
    }

    public B disable(MapperFeature ... features) {
        for (MapperFeature f : features) {
            this._mapperFeatures &= f.getLongMask() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this._this();
    }

    public B configure(MapperFeature feature, boolean state) {
        this._mapperFeatures = state ? (this._mapperFeatures |= feature.getLongMask()) : (this._mapperFeatures &= feature.getLongMask() ^ 0xFFFFFFFFFFFFFFFFL);
        return this._this();
    }

    public B enable(SerializationFeature ... features) {
        for (SerializationFeature f : features) {
            this._serFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(SerializationFeature ... features) {
        for (SerializationFeature f : features) {
            this._serFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(SerializationFeature feature, boolean state) {
        this._serFeatures = state ? (this._serFeatures |= feature.getMask()) : (this._serFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(DeserializationFeature ... features) {
        for (DeserializationFeature f : features) {
            this._deserFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(DeserializationFeature ... features) {
        for (DeserializationFeature f : features) {
            this._deserFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(DeserializationFeature feature, boolean state) {
        this._deserFeatures = state ? (this._deserFeatures |= feature.getMask()) : (this._deserFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(DatatypeFeature ... features) {
        this._datatypeFeatures = this._datatypeFeatures.withFeatures(features);
        return this._this();
    }

    public B disable(DatatypeFeature ... features) {
        this._datatypeFeatures = this._datatypeFeatures.withoutFeatures(features);
        return this._this();
    }

    public B configure(DatatypeFeature feature, boolean state) {
        this._datatypeFeatures = state ? this._datatypeFeatures.with(feature) : this._datatypeFeatures.without(feature);
        return this._this();
    }

    public B configureForJackson2() {
        return ((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)this.disable(DateTimeFeature.ONE_BASED_MONTHS)).enable(DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS)).enable(DateTimeFeature.WRITE_DURATIONS_AS_TIMESTAMPS)).enable(DateTimeFeature.WRITE_UTC_AS_OFFSET)).disable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)).disable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).disable(EnumFeature.READ_ENUMS_USING_TO_STRING)).disable(EnumFeature.WRITE_ENUMS_USING_TO_STRING)).enable(JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES)).enable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS)).disable(MapperFeature.DETECT_PARAMETER_NAMES)).disable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)).enable(MapperFeature.USE_GETTERS_AS_SETTERS)).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public B enable(StreamReadFeature ... features) {
        for (StreamReadFeature f : features) {
            this._streamReadFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature ... features) {
        for (StreamReadFeature f : features) {
            this._streamReadFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature feature, boolean state) {
        this._streamReadFeatures = state ? (this._streamReadFeatures |= feature.getMask()) : (this._streamReadFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(StreamWriteFeature ... features) {
        for (StreamWriteFeature f : features) {
            this._streamWriteFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature ... features) {
        for (StreamWriteFeature f : features) {
            this._streamWriteFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature feature, boolean state) {
        this._streamWriteFeatures = state ? (this._streamWriteFeatures |= feature.getMask()) : (this._streamWriteFeatures &= ~feature.getMask());
        return this._this();
    }

    public B withConfigOverride(Class<?> forType, Consumer<MutableConfigOverride> handler) {
        handler.accept(this._configOverrides.findOrCreateOverride(forType));
        return this._this();
    }

    public B withAllConfigOverrides(Consumer<ConfigOverrides> handler) {
        handler.accept(this._configOverrides);
        return this._this();
    }

    public B changeDefaultVisibility(UnaryOperator<VisibilityChecker> handler) {
        VisibilityChecker oldV = this._configOverrides.getDefaultVisibility();
        VisibilityChecker newV = (VisibilityChecker)handler.apply(oldV);
        if (newV != oldV) {
            Objects.requireNonNull(newV, "Cannot assign null default VisibilityChecker");
            this._configOverrides.setDefaultVisibility(newV);
        }
        return this._this();
    }

    public B changeDefaultPropertyInclusion(UnaryOperator<JsonInclude.Value> handler) {
        JsonInclude.Value oldIncl = this._configOverrides.getDefaultInclusion();
        JsonInclude.Value newIncl = (JsonInclude.Value)handler.apply(oldIncl);
        if (newIncl != oldIncl) {
            Objects.requireNonNull(newIncl, "Cannot assign null default Property Inclusion");
            this._configOverrides.setDefaultInclusion(newIncl);
        }
        return this._this();
    }

    public B changeDefaultNullHandling(UnaryOperator<JsonSetter.Value> handler) {
        JsonSetter.Value oldIncl = this._configOverrides.getDefaultNullHandling();
        JsonSetter.Value newIncl = (JsonSetter.Value)handler.apply(oldIncl);
        if (newIncl != oldIncl) {
            Objects.requireNonNull(newIncl, "Cannot assign null default Null Handling");
            this._configOverrides.setDefaultNullHandling(newIncl);
        }
        return this._this();
    }

    public B defaultMergeable(Boolean b) {
        this._configOverrides.setDefaultMergeable(b);
        return this._this();
    }

    public B defaultLeniency(Boolean b) {
        this._configOverrides.setDefaultLeniency(b);
        return this._this();
    }

    public B defaultFormat(JsonFormat.Value format) {
        this._configOverrides.setDefaultFormat(format);
        return this._this();
    }

    public B withCoercionConfig(LogicalType forType, Consumer<MutableCoercionConfig> handler) {
        handler.accept(this._coercionConfigs.findOrCreateCoercion(forType));
        return this._this();
    }

    public B withCoercionConfig(Class<?> forType, Consumer<MutableCoercionConfig> handler) {
        handler.accept(this._coercionConfigs.findOrCreateCoercion(forType));
        return this._this();
    }

    public B withCoercionConfigDefaults(Consumer<MutableCoercionConfig> handler) {
        handler.accept(this._coercionConfigs.defaultCoercions());
        return this._this();
    }

    public B withAllCoercionConfigs(Consumer<CoercionConfigs> handler) {
        handler.accept(this._coercionConfigs);
        return this._this();
    }

    public B removeAllModules() {
        this._modules = null;
        this._savedState = null;
        return this._this();
    }

    public B addModule(JacksonModule module) {
        Objects.requireNonNull(module, "Cannot add null `JacksonModule`");
        this._verifyModuleMetadata(module);
        Object moduleId = module.getRegistrationId();
        if (this._modules == null) {
            this._modules = new LinkedHashMap<Object, JacksonModule>();
        } else {
            this._modules.remove(moduleId);
        }
        for (JacksonModule jacksonModule : module.getDependencies()) {
            this._verifyModuleMetadata(jacksonModule);
            this._modules.putIfAbsent(jacksonModule.getRegistrationId(), jacksonModule);
        }
        this._modules.put(moduleId, module);
        this._savedState = null;
        return this._this();
    }

    private void _verifyModuleMetadata(JacksonModule module) {
        if (module.getModuleName() == null) {
            throw new IllegalArgumentException("Module (" + module.getClass().getName() + ") without defined name");
        }
        if (module.version() == null) {
            throw new IllegalArgumentException("Module (" + module.getClass().getName() + ") without defined version");
        }
    }

    public B addModules(JacksonModule ... modules) {
        for (JacksonModule module : modules) {
            this.addModule(module);
        }
        return this._this();
    }

    public B addModules(Iterable<? extends JacksonModule> modules) {
        for (JacksonModule jacksonModule : modules) {
            this.addModule(jacksonModule);
        }
        return this._this();
    }

    public static List<JacksonModule> findModules() {
        return MapperBuilder.findModules(null);
    }

    public static List<JacksonModule> findModules(ClassLoader classLoader) {
        ArrayList<JacksonModule> modules = new ArrayList<JacksonModule>();
        ServiceLoader<JacksonModule> loader = MapperBuilder.secureGetServiceLoader(JacksonModule.class, classLoader);
        for (JacksonModule module : loader) {
            modules.add(module);
        }
        return modules;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(final Class<T> clazz, final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<T>>(){

            @Override
            public ServiceLoader<T> run() {
                return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
            }
        });
    }

    public B findAndAddModules() {
        return this.addModules(MapperBuilder.findModules());
    }

    public B findAndAddModules(ClassLoader cl) {
        return this.addModules(MapperBuilder.findModules(cl));
    }

    public B withModules(Consumer<JacksonModule> handler) {
        if (this._modules != null) {
            this._modules.values().forEach(handler);
        }
        return this._this();
    }

    public B baseSettings(BaseSettings b) {
        this._baseSettings = b;
        return this._this();
    }

    public B annotationIntrospector(AnnotationIntrospector intr) {
        this._baseSettings = this._baseSettings.withAnnotationIntrospector(intr);
        return this._this();
    }

    public B defaultAttributes(ContextAttributes attrs) {
        this._defaultAttributes = attrs;
        return this._this();
    }

    public B typeFactory(TypeFactory f) {
        this._typeFactory = f;
        return this._this();
    }

    public B addTypeModifier(TypeModifier modifier) {
        this._typeFactory = this.typeFactory().withModifier(modifier);
        return this._this();
    }

    protected B typeResolverProvider(TypeResolverProvider p) {
        this._typeResolverProvider = p;
        return this._this();
    }

    public B classIntrospector(ClassIntrospector ci) {
        this._classIntrospector = ci;
        return this._this();
    }

    public B subtypeResolver(SubtypeResolver r) {
        this._subtypeResolver = r;
        return this._this();
    }

    public B polymorphicTypeValidator(PolymorphicTypeValidator ptv) {
        this._baseSettings = this._baseSettings.with(ptv);
        return this._this();
    }

    public B handlerInstantiator(HandlerInstantiator hi) {
        this._baseSettings = this._baseSettings.with(hi);
        return this._this();
    }

    public B propertyNamingStrategy(PropertyNamingStrategy s) {
        this._baseSettings = this._baseSettings.with(s);
        return this._this();
    }

    public B enumNamingStrategy(EnumNamingStrategy s) {
        this._baseSettings = this._baseSettings.with(s);
        return this._this();
    }

    public B accessorNaming(AccessorNamingStrategy.Provider s) {
        if (s == null) {
            s = new DefaultAccessorNamingStrategy.Provider();
        }
        this._baseSettings = this._baseSettings.with(s);
        return this._this();
    }

    public B serializerFactory(SerializerFactory f) {
        this._serializerFactory = f;
        return this._this();
    }

    public B serializationContexts(SerializationContexts ctxt) {
        this._serializationContexts = ctxt;
        return this._this();
    }

    public B filterProvider(FilterProvider prov) {
        this._filterProvider = prov;
        return this._this();
    }

    public B defaultPrettyPrinter(PrettyPrinter pp) {
        this._defaultPrettyPrinter = pp;
        return this._this();
    }

    public B deserializerFactory(DeserializerFactory f) {
        this._deserializerFactory = f;
        return this._this();
    }

    public B deserializationContexts(DeserializationContexts ctxt) {
        this._deserializationContexts = ctxt;
        return this._this();
    }

    public B injectableValues(InjectableValues v) {
        this._injectableValues = v;
        return this._this();
    }

    public B nodeFactory(JsonNodeFactory f) {
        this._baseSettings = this._baseSettings.with(f);
        return this._this();
    }

    public B constructorDetector(ConstructorDetector cd) {
        this._baseSettings = this._baseSettings.with(cd);
        return this._this();
    }

    public B cacheProvider(CacheProvider cacheProvider) {
        this._baseSettings = this._baseSettings.with(cacheProvider);
        TypeFactory tf = this.typeFactory().withCache(cacheProvider.forTypeFactory());
        return this.typeFactory(tf);
    }

    public B addHandler(DeserializationProblemHandler h) {
        if (!LinkedNode.contains(this._problemHandlers, h)) {
            this._problemHandlers = new LinkedNode<DeserializationProblemHandler>(h, this._problemHandlers);
        }
        return this._this();
    }

    public B clearProblemHandlers() {
        this._problemHandlers = null;
        return this._this();
    }

    public B addAbstractTypeResolver(AbstractTypeResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Cannot pass null resolver");
        }
        this._abstractTypeResolvers = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, resolver);
        return this._this();
    }

    public B defaultDateFormat(DateFormat f) {
        this._baseSettings = this._baseSettings.with(f);
        this.configure(DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, f == null);
        return this._this();
    }

    public B defaultTimeZone(TimeZone tz) {
        this._baseSettings = this._baseSettings.with(tz);
        return this._this();
    }

    public B defaultLocale(Locale locale) {
        this._baseSettings = this._baseSettings.with(locale);
        return this._this();
    }

    public B defaultBase64Variant(Base64Variant v) {
        this._baseSettings = this._baseSettings.with(v);
        return this._this();
    }

    public B defaultSerializationView(Class<?> view) {
        this._defaultSerializationView = view;
        return this._this();
    }

    public B defaultDeserializationView(Class<?> view) {
        this._defaultDeserializationView = view;
        return this._this();
    }

    public B defaultView(Class<?> view) {
        this._defaultSerializationView = view;
        this._defaultDeserializationView = view;
        return this._this();
    }

    public B mixInHandler(MixInHandler h) {
        this._mixInHandler = h;
        return this._this();
    }

    public B mixInOverrides(MixInResolver r) {
        this._mixInHandler = this.mixInHandler().withOverrides(r);
        return this._this();
    }

    public B addMixIns(Map<Class<?>, Class<?>> sourceMixins) {
        this.mixInHandler().addLocalDefinitions(sourceMixins);
        return this._this();
    }

    public B addMixIn(Class<?> target, Class<?> mixinSource) {
        this.mixInHandler().addLocalDefinition(target, mixinSource);
        return this._this();
    }

    public B removeMixIn(Class<?> target) {
        this.mixInHandler().addLocalDefinition(target, null);
        return this._this();
    }

    public B registerSubtypes(Class<?> ... subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B registerSubtypes(NamedType ... subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B registerSubtypes(Collection<Class<?>> subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator subtypeValidator) {
        return this.activateDefaultTyping(subtypeValidator, DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public B activateDefaultTyping(PolymorphicTypeValidator subtypeValidator, DefaultTyping dti) {
        return this.activateDefaultTyping(subtypeValidator, dti, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    public B activateDefaultTyping(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        if (includeAs == JsonTypeInfo.As.EXTERNAL_PROPERTY) {
            throw new IllegalArgumentException("Cannot use includeAs of " + String.valueOf(includeAs) + " for Default Typing");
        }
        return this.setDefaultTyping(this._defaultDefaultTypingResolver(subtypeValidator, applicability, includeAs));
    }

    public B activateDefaultTypingAsProperty(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, String propertyName) {
        return this.setDefaultTyping(this._defaultDefaultTypingResolver(subtypeValidator, applicability, propertyName));
    }

    public B deactivateDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public B setDefaultTyping(TypeResolverBuilder<?> typer) {
        this._baseSettings = this._baseSettings.with(typer);
        return this._this();
    }

    protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        return new DefaultTypeResolverBuilder(subtypeValidator, applicability, includeAs);
    }

    protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, String propertyName) {
        return new DefaultTypeResolverBuilder(subtypeValidator, applicability, propertyName);
    }

    protected final B _this() {
        return (B)this;
    }
}

