/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import tools.jackson.databind.cfg.DatatypeFeature;

public enum DateTimeFeature implements DatatypeFeature
{
    ADJUST_DATES_TO_CONTEXT_TIME_ZONE(true),
    ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS(false),
    NORMALIZE_DESERIALIZED_ZONE_ID(true),
    ONE_BASED_MONTHS(true),
    READ_DATE_TIMESTAMPS_AS_NANOSECONDS(true),
    TRUNCATE_TO_MSECS_ON_READ(false),
    TRUNCATE_TO_MSECS_ON_WRITE(false),
    USE_TIME_ZONE_FOR_LENIENT_DATE_PARSING(false),
    WRITE_DATES_AS_TIMESTAMPS(false),
    WRITE_DATE_KEYS_AS_TIMESTAMPS(false),
    WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS(true),
    WRITE_DATES_WITH_CONTEXT_TIME_ZONE(true),
    WRITE_DATES_WITH_ZONE_ID(false),
    WRITE_DURATIONS_AS_TIMESTAMPS(false),
    WRITE_UTC_AS_OFFSET(false);

    private static final int FEATURE_INDEX = 2;
    private final boolean _enabledByDefault;
    private final int _mask;

    private DateTimeFeature(boolean enabledByDefault) {
        this._enabledByDefault = enabledByDefault;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._enabledByDefault;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    public int getMask() {
        return this._mask;
    }

    @Override
    public int featureIndex() {
        return 2;
    }
}

