/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import android.view.View;
import java.util.concurrent.CountDownLatch;
import tools.fastlane.screengrab.ScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotStrategy;

public final class DecorViewScreenshotStrategy
implements ScreenshotStrategy {
    private final Activity mActivity;

    public DecorViewScreenshotStrategy(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void takeScreenshot(String screenshotName, ScreenshotCallback callback) {
        try {
            callback.screenshotCaptured(screenshotName, DecorViewScreenshotStrategy.takeScreenshot(this.mActivity));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }
    }

    private static Bitmap takeScreenshot(Activity activity) {
        final View view = activity.getWindow().getDecorView();
        final Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            DecorViewScreenshotStrategy.drawViewToBitmap(view, bitmap);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecorViewScreenshotStrategy.drawViewToBitmap(view, bitmap);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to capture screenshot", e);
            }
        }
        return bitmap;
    }

    private static void drawViewToBitmap(View decorView, Bitmap bitmap) {
        decorView.draw(new Canvas(bitmap));
    }
}

