/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import tools.fastlane.screengrab.ScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotStrategy;

public class DecorViewScreenshotStrategy
implements ScreenshotStrategy {
    @Override
    public void takeScreenshot(String screenshotName, ScreenshotCallback callback) {
        Espresso.onView((Matcher)ViewMatchers.isRoot()).perform(new ViewAction[]{new ScreenshotViewAction(screenshotName, callback)});
    }

    static class ScreenshotViewAction
    implements ViewAction {
        private final String screenshotName;
        private final ScreenshotCallback callback;

        public ScreenshotViewAction(String screenshotName, ScreenshotCallback callback) {
            this.screenshotName = screenshotName;
            this.callback = callback;
        }

        public Matcher<View> getConstraints() {
            return ViewMatchers.isDisplayed();
        }

        public String getDescription() {
            return "taking screenshot of the Activity";
        }

        public void perform(UiController uiController, View view) {
            Activity activity = this.scanForActivity(view.getContext());
            if (activity == null) {
                throw new IllegalStateException("Couldn't get the activity from the view context");
            }
            try {
                this.callback.screenshotCaptured(this.screenshotName, ScreenshotViewAction.takeScreenshot(activity));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to capture screenshot.", e);
            }
        }

        private Activity scanForActivity(Context context) {
            if (context == null) {
                return null;
            }
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (context instanceof ContextWrapper) {
                return this.scanForActivity(((ContextWrapper)context).getBaseContext());
            }
            return null;
        }

        private static Bitmap takeScreenshot(final Activity activity) throws IOException {
            View view = activity.getWindow().getDecorView();
            final Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (Looper.myLooper() == Looper.getMainLooper()) {
                ScreenshotViewAction.drawDecorViewToBitmap(activity, bitmap);
            } else {
                final CountDownLatch latch = new CountDownLatch(1);
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ScreenshotViewAction.drawDecorViewToBitmap(activity, bitmap);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unable to capture screenshot", e);
                }
            }
            return bitmap;
        }

        private static void drawDecorViewToBitmap(Activity activity, Bitmap bitmap) {
            activity.getWindow().getDecorView().draw(new Canvas(bitmap));
        }
    }
}

