/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class PushoverMessage
implements Message {
    private static final Logger LOGGER = Logger.getLogger(PushoverMessage.class.getName());
    private final String userToken;
    private final String appToken;
    private String content;
    private String title;
    private Integer priority = 0;
    private String url;
    private String urlTitle;

    public PushoverMessage(String userToken, String appToken) {
        this.userToken = userToken;
        this.appToken = appToken;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrl(String url, String title) {
        this.url = url;
        this.urlTitle = title;
    }

    @Override
    public void highPriority() {
        this.priority = 1;
    }

    @Override
    public void normalPriority() {
        this.priority = 0;
    }

    @Override
    public void lowPriority() {
        this.priority = -1;
    }

    @Override
    public void send() {
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod("https://api.pushover.net/1/messages.json");
            String data = "token=" + this.appToken + "&user=" + this.userToken + "&message=" + this.encode(this.content) + "&title=" + this.encode(this.title) + "&priority=" + this.priority + "&url=" + this.url + "&url_title=" + this.urlTitle;
            post.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            client.executeMethod((HttpMethod)post);
        }
        catch (IOException e) {
            LOGGER.severe("Error while sending notification: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }
}

