/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import jenkins.model.Jenkins;
import tools.devnull.jenkins.plugins.buildnotifications.BuildNotifier;
import tools.devnull.jenkins.plugins.buildnotifications.BuildStatus;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public abstract class BaseNotifier
extends Notifier {
    private final String globalTarget;
    private final String successfulTarget;
    private final String brokenTarget;
    private final String stillBrokenTarget;
    private final String fixedTarget;
    private final boolean sendIfSuccess;

    public BaseNotifier(String globalTarget, String successfulTarget, String brokenTarget, String stillBrokenTarget, String fixedTarget, boolean sendIfSuccess) {
        this.globalTarget = globalTarget;
        this.successfulTarget = successfulTarget;
        this.brokenTarget = brokenTarget;
        this.stillBrokenTarget = stillBrokenTarget;
        this.fixedTarget = fixedTarget;
        this.sendIfSuccess = sendIfSuccess;
    }

    public String getGlobalTarget() {
        return this.globalTarget;
    }

    public String getSuccessfulTarget() {
        return this.successfulTarget;
    }

    public String getBrokenTarget() {
        return this.brokenTarget;
    }

    public String getStillBrokenTarget() {
        return this.stillBrokenTarget;
    }

    public String getFixedTarget() {
        return this.fixedTarget;
    }

    public boolean isSendIfSuccess() {
        return this.sendIfSuccess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String target = null;
        BuildStatus status = BuildStatus.of(build);
        switch (status) {
            case BROKEN: {
                target = this.brokenTarget;
                break;
            }
            case STILL_BROKEN: {
                target = this.stillBrokenTarget;
                break;
            }
            case FIXED: {
                target = this.fixedTarget;
                break;
            }
            case SUCCESSFUL: {
                target = this.successfulTarget;
            }
        }
        if ((target == null || target.isEmpty()) && (status != BuildStatus.SUCCESSFUL || this.sendIfSuccess)) {
            target = this.globalTarget;
        }
        if (target != null && !target.isEmpty()) {
            Message message = this.createMessage(target, build, launcher, listener);
            BuildNotifier notifier = this.createNotifier(build, message);
            notifier.sendNotification();
        }
        return true;
    }

    protected BuildNotifier createNotifier(AbstractBuild<?, ?> build, Message message) {
        return new BuildNotifier(message, build, Jenkins.getInstance().getRootUrl());
    }

    protected abstract Message createMessage(String var1, AbstractBuild<?, ?> var2, Launcher var3, BuildListener var4);
}

