/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import tools.devnull.jenkins.plugins.buildnotifications.BaseNotifier;
import tools.devnull.jenkins.plugins.buildnotifications.Message;
import tools.devnull.jenkins.plugins.buildnotifications.PushoverMessage;

public class PushoverNotifier
extends BaseNotifier {
    @DataBoundConstructor
    public PushoverNotifier(String globalTarget, String successfulTarget, String brokenTarget, String stillBrokenTarget, String fixedTarget, boolean sendIfSuccess) {
        super(globalTarget, successfulTarget, brokenTarget, stillBrokenTarget, fixedTarget, sendIfSuccess);
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Override
    protected Message createMessage(String target, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PushoverDescriptor descriptor = (PushoverDescriptor)this.getDescriptor();
        return new PushoverMessage(target, descriptor.appToken);
    }

    @Extension
    public static class PushoverDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String appToken;

        public PushoverDescriptor() {
            this.load();
        }

        public String getAppToken() {
            return this.appToken;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            JSONObject config = json.getJSONObject("pushover");
            this.appToken = config.getString("appToken");
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Pushover Notification";
        }
    }
}

