/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib;

import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;

public class MorseCode {
    private static final int MAX_MORSE_LENGTH = 6;
    public static HashMap<String, Character> morseMap = new HashMap();
    public static HashMap<Character, String> charMap = new HashMap();
    public static char[] morseCharMap = new char[(int)Math.pow(3.0, 6.0)];

    public static String getMorseEquivalent(CharSequence text) {
        StringJoiner joiner = new StringJoiner("X");
        for (int i = 0; i < text.length(); ++i) {
            joiner.add(charMap.get(Character.valueOf(text.charAt(i))));
        }
        return joiner.toString();
    }

    public static String getMorse(char ch) {
        return charMap.get(Character.valueOf(ch));
    }

    public static String getMorseEquivalent(Character[] text) {
        StringJoiner joiner = new StringJoiner("X");
        Character[] characterArray = text;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char character = characterArray[i].charValue();
            joiner.add(charMap.get(Character.valueOf(character)));
        }
        return joiner.toString();
    }

    public static Character getCharFromMorse(String morse) throws NullPointerException {
        return morseMap.get(morse);
    }

    public static Character getCharFromMorse(char[] morse, int index, int length) {
        int i;
        int lookup = 0;
        for (i = 0; i < length; ++i) {
            char ch = morse[index + i];
            if (ch == '-') {
                lookup = (int)((double)lookup + Math.pow(3.0, i));
                continue;
            }
            if (ch == '.') continue;
            return Character.valueOf(' ');
        }
        for (i = length; i < 6; ++i) {
            lookup = (int)((double)lookup + 2.0 * Math.pow(3.0, i));
        }
        if (lookup < 0 || lookup >= morseCharMap.length) {
            return null;
        }
        return Character.valueOf(morseCharMap[lookup]);
    }

    public static void putCharacter(char character, String morse) {
        int i;
        morseMap.put(morse, Character.valueOf(character));
        charMap.put(Character.valueOf(character), morse);
        int lookup = 0;
        for (i = 0; i < morse.length(); ++i) {
            int value = -1;
            char ch = morse.charAt(i);
            if (ch == '.') {
                value = 0;
            } else if (ch == '-') {
                value = 1;
            }
            lookup = (int)((double)lookup + (double)value * Math.pow(3.0, i));
        }
        for (i = morse.length(); i < 6; ++i) {
            lookup = (int)((double)lookup + 2.0 * Math.pow(3.0, i));
        }
        if (lookup != -1) {
            MorseCode.morseCharMap[lookup] = character;
        }
    }

    static {
        Arrays.fill(morseCharMap, ' ');
        MorseCode.putCharacter(' ', "");
        MorseCode.putCharacter('A', ".-");
        MorseCode.putCharacter('B', "-...");
        MorseCode.putCharacter('C', "-.-.");
        MorseCode.putCharacter('D', "-..");
        MorseCode.putCharacter('E', ".");
        MorseCode.putCharacter('F', "..-.");
        MorseCode.putCharacter('G', "--.");
        MorseCode.putCharacter('H', "....");
        MorseCode.putCharacter('I', "..");
        MorseCode.putCharacter('J', ".---");
        MorseCode.putCharacter('K', "-.-");
        MorseCode.putCharacter('L', ".-..");
        MorseCode.putCharacter('M', "--");
        MorseCode.putCharacter('N', "-.");
        MorseCode.putCharacter('O', "---");
        MorseCode.putCharacter('P', ".--.");
        MorseCode.putCharacter('Q', "--.-");
        MorseCode.putCharacter('R', ".-.");
        MorseCode.putCharacter('S', "...");
        MorseCode.putCharacter('T', "-");
        MorseCode.putCharacter('U', "..-");
        MorseCode.putCharacter('V', "...-");
        MorseCode.putCharacter('W', ".--");
        MorseCode.putCharacter('X', "-..-");
        MorseCode.putCharacter('Y', "-.--");
        MorseCode.putCharacter('Z', "--..");
        MorseCode.putCharacter('1', ".----");
        MorseCode.putCharacter('2', "..---");
        MorseCode.putCharacter('3', "...--");
        MorseCode.putCharacter('4', "....-");
        MorseCode.putCharacter('5', ".....");
        MorseCode.putCharacter('6', "-....");
        MorseCode.putCharacter('7', "--...");
        MorseCode.putCharacter('8', "---..");
        MorseCode.putCharacter('9', "----.");
        MorseCode.putCharacter('0', "-----");
        MorseCode.putCharacter('.', ".-.-.-");
        MorseCode.putCharacter(',', "--..--");
        MorseCode.putCharacter(':', "---...");
        MorseCode.putCharacter('\"', ".-..-.");
        MorseCode.putCharacter('\'', ".----.");
        MorseCode.putCharacter('!', "-.-.--");
        MorseCode.putCharacter('?', "..--..");
        MorseCode.putCharacter('@', ".--.-.");
        MorseCode.putCharacter('-', "-....-");
        MorseCode.putCharacter(';', "-.-.-.");
        MorseCode.putCharacter('(', "-.--.");
        MorseCode.putCharacter(')', "-.--.-");
        MorseCode.putCharacter('=', "-...-");
    }
}

