/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class DocumentUtils {
    public static DocumentFilter createTextFilter(String filterRegex) {
        return new DocumentTextFilter(filterRegex);
    }

    public static void addUndoManager(JTextArea textArea) {
        final UndoManager undoManager = new UndoManager();
        textArea.getDocument().addUndoableEditListener(undoManager);
        InputMap im = textArea.getInputMap(0);
        ActionMap am = textArea.getActionMap();
        im.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Undo");
        im.put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Redo");
        am.put("Undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException exp) {
                    exp.printStackTrace();
                }
            }
        });
        am.put("Redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotUndoException exp) {
                    exp.printStackTrace();
                }
            }
        });
    }

    public static abstract class DocumentChangeAdapter
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent event) {
            this.onUpdate(event);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.onUpdate(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.onUpdate(event);
        }

        public abstract void onUpdate(DocumentEvent var1);
    }

    public static class DocumentIntegerRangeInput
    extends DocumentFilter {
        private JTextComponent textComponent;

        public DocumentIntegerRangeInput(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String textFull = this.textComponent.getText();
            String textLeft = textFull.substring(0, offset) + textFull.substring(offset + length, textFull.length());
            if (textLeft.indexOf(45) != -1 && text.contains("-")) {
                text = text.replaceAll("-", "");
            }
            text = text.replaceAll("[^0-9-]", "");
            super.replace(fb, offset, length, text, attrs);
        }
    }

    public static class DocumentDoubleInput
    extends DocumentFilter {
        private JTextComponent textComponent;

        public DocumentDoubleInput(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String textFull = this.textComponent.getText();
            String textLeft = textFull.substring(0, offset) + textFull.substring(offset + length, textFull.length());
            if (textLeft.isEmpty() && ((String)text).startsWith(".")) {
                text = "0" + (String)text;
            }
            if (textLeft.indexOf(46) != -1 && ((String)text).contains(".")) {
                text = ((String)text).replaceAll(".", "");
            }
            text = ((String)text).replaceAll("[^0-9.]", "");
            super.replace(fb, offset, length, (String)text, attrs);
        }
    }

    public static class DocumentIntegerInput
    extends DocumentFilter {
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.replaceAll("[^0-9]", "");
            super.replace(fb, offset, length, text, attrs);
        }
    }

    public static class DocumentCardInput
    extends DocumentFilter {
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.replaceAll("[^0-9ATJQKcdhs,]", "");
            super.replace(fb, offset, length, text, attrs);
        }
    }

    public static class DocumentUpperCaseInput
    extends DocumentFilter {
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.toUpperCase();
            super.replace(fb, offset, length, text, attrs);
        }
    }

    public static class DocumentTextFilter
    extends DocumentFilter {
        private String filterRegex;

        private DocumentTextFilter(String filterRegex) {
            this.filterRegex = filterRegex;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.replaceAll(this.filterRegex, "");
            super.replace(fb, offset, length, text, attrs);
        }
    }
}

