/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.fitness;

import com.alexbarter.lib.util.MathUtil;
import java.util.Arrays;
import java.util.Map;

public class NGramData {
    private final Double[] valueMapping;
    private final int nGramLength;
    private final int[] powValues;
    private final double floor;
    private final double fitnessPerChar;
    private final double maxValue;

    public NGramData(Map<String, Double> mapping, double floor, double fitnessPerChar, int nGram) {
        this.floor = floor;
        this.fitnessPerChar = fitnessPerChar;
        this.nGramLength = nGram;
        this.powValues = new int[nGram];
        for (int i = 0; i < this.powValues.length; ++i) {
            this.powValues[this.powValues.length - i - 1] = (int)Math.pow(26.0, i);
        }
        this.maxValue = (Double)MathUtil.getSmallest(mapping.values());
        this.valueMapping = new Double[(int)Math.pow(26.0, nGram)];
        Arrays.fill((Object[])this.valueMapping, (Object)floor);
        for (Map.Entry<String, Double> entry : mapping.entrySet()) {
            String ngram = entry.getKey();
            for (int i = 0; i < this.nGramLength && ngram.charAt(i) >= 'A' && ngram.charAt(i) <= 'Z'; ++i) {
            }
            int value = 0;
            for (int i = 0; i < this.nGramLength; ++i) {
                value += (ngram.charAt(i) - 65) * this.powValues[i];
            }
            this.valueMapping[value] = entry.getValue();
        }
        for (int i = 0; i < this.valueMapping.length; ++i) {
            if (this.valueMapping[i] != null) continue;
            this.valueMapping[i] = this.floor;
        }
    }

    public double getValue(char[] gram, int startIndex) {
        int intConversion = 0;
        for (int i = startIndex; i < startIndex + this.nGramLength; ++i) {
            if (gram[i] < 'A' || gram[i] > 'Z') {
                return this.floor;
            }
            intConversion += (gram[i] - 65) * this.powValues[i - startIndex];
        }
        return this.valueMapping[intConversion];
    }

    public double getValue(CharSequence gram, int startIndex) {
        int intConversion = 0;
        for (int i = startIndex; i < startIndex + this.nGramLength; ++i) {
            if (gram.charAt(i) < 'A' || gram.charAt(i) > 'Z') {
                return this.floor;
            }
            intConversion += (gram.charAt(i) - 65) * this.powValues[i - startIndex];
        }
        return this.valueMapping[intConversion];
    }

    public double getAverageFitness() {
        return this.fitnessPerChar;
    }

    public int getLength() {
        return this.nGramLength;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

