/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.identify;

import com.alexbarter.ciphertool.identify.holder.DataBoolean;
import com.alexbarter.ciphertool.identify.holder.DataDeviation;
import com.alexbarter.ciphertool.identify.holder.DataHolder;
import com.alexbarter.ciphertool.identify.holder.DataInteger;
import com.alexbarter.ciphertool.lib.Cache;
import com.alexbarter.ciphertool.lib.constants.StatisticsLib;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class CipherStatistics
extends StatisticsLib {
    private static Cache<Map<String, Object>> cipherStatistics = Cache.create(CipherStatistics::createCipherStatistics);

    public static Map<String, Object> getOtherCipherStatistics() {
        return (Map)cipherStatistics.get();
    }

    public static Map<String, Object> createCipherStatistics() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        HashMap<String, DataHolder<?>> hill2x2 = CipherStatistics.createOrGetList(map, "Hill", "2x2");
        hill2x2.put("ic_1_x10000", new DataDeviation(42.0, 2.61));
        hill2x2.put("ic_max_x1000", new DataDeviation(47.18, 5.07));
        hill2x2.put("ic_2_true_x10000", new DataDeviation(32.75, 2.99));
        hill2x2.put("ic_2_false_x10000", new DataDeviation(76.77, 7.28));
        hill2x2.put("ic_3_false_x100000", new DataDeviation(40.67, 16.8));
        hill2x2.put("ic_kappa_x1000", new DataDeviation(56.24, 8.47));
        hill2x2.put("log_digraph", new DataDeviation(435.93, 26.44));
        hill2x2.put("long_repeat", new DataDeviation(11.07, 1.48));
        hill2x2.put("long_repeat_odd_percentage", new DataDeviation(21.86, 3.43));
        hill2x2.put("normal_order", new DataDeviation(215.51, 30.18));
        hill2x2.put("text_length_multiple", new DataInteger(2));
        HashMap<String, DataHolder<?>> hill3x3 = CipherStatistics.createOrGetList(map, "Hill", "3x3");
        hill3x3.put("ic_1_x10000", new DataDeviation(39.19, 0.79));
        hill3x3.put("ic_max_x1000", new DataDeviation(41.99, 2.28));
        hill3x3.put("ic_2_true_x10000", new DataDeviation(19.03, 2.05));
        hill3x3.put("ic_2_false_x10000", new DataDeviation(18.89, 2.49));
        hill3x3.put("ic_3_false_x100000", new DataDeviation(169.82, 58.61));
        hill3x3.put("ic_kappa_x1000", new DataDeviation(51.43, 6.54));
        hill3x3.put("log_digraph", new DataDeviation(428.97, 16.43));
        hill3x3.put("long_repeat", new DataDeviation(10.46, 1.35));
        hill3x3.put("long_repeat_odd_percentage", new DataDeviation(49.89, 3.07));
        hill3x3.put("normal_order", new DataDeviation(221.35, 28.74));
        hill3x3.put("text_length_multiple", new DataInteger(3));
        HashMap<String, DataHolder<?>> cadenusx = CipherStatistics.createOrGetList(map, "Cadenus", "w/x");
        cadenusx.put("ic_1_x10000", new DataDeviation(64.81, 7.69));
        cadenusx.put("ic_max_x1000", new DataDeviation(66.22, 7.63));
        cadenusx.put("ic_2_true_x10000", new DataDeviation(66.37, 70.9));
        cadenusx.put("ic_2_false_x10000", new DataDeviation(66.14, 70.1));
        cadenusx.put("ic_3_false_x100000", new DataDeviation(193.88, 459.83));
        cadenusx.put("ic_kappa_x1000", new DataDeviation(109.06, 39.35));
        cadenusx.put("log_digraph", new DataDeviation(630.82, 29.4));
        cadenusx.put("log_digraph_reversed", new DataDeviation(473.01, 277.33));
        cadenusx.put("long_repeat", new DataDeviation(16.4, 9.74));
        cadenusx.put("long_repeat_odd_percentage", new DataDeviation(49.57, 1.72));
        cadenusx.put("normal_order", new DataDeviation(83.5, 29.86));
        cadenusx.put("text_length_multiple", new DataInteger(25));
        HashMap<String, DataHolder<?>> cadenus = CipherStatistics.createOrGetList(map, "Cadenus", "!w/x");
        cadenus.put("ic_1_x10000", new DataDeviation(66.14, 2.73));
        cadenus.put("ic_max_x1000", new DataDeviation(68.47, 3.52));
        cadenus.put("ic_2_true_x10000", new DataDeviation(44.07, 4.22));
        cadenus.put("ic_2_false_x10000", new DataDeviation(44.42, 6.05));
        cadenus.put("ic_3_false_x100000", new DataDeviation(31.48, 15.17));
        cadenus.put("ic_kappa_x1000", new DataDeviation(80.65, 7.91));
        cadenus.put("log_digraph", new DataDeviation(658.0, 9.13));
        cadenus.put("log_digraph_reversed", new DataDeviation(488.87, 289.3));
        cadenus.put("long_repeat", new DataDeviation(11.86, 1.43));
        cadenus.put("long_repeat_odd_percentage", new DataDeviation(49.43, 2.44));
        cadenus.put("normal_order", new DataDeviation(76.69, 31.99));
        cadenus.put("text_length_multiple", new DataInteger(25));
        HashMap<String, DataHolder<?>> beaufortSlidefair = CipherStatistics.createOrGetList(map, "Slidefair", "Beaufort");
        beaufortSlidefair.put("ic_1_x10000", new DataDeviation(41.86, 3.4));
        beaufortSlidefair.put("ic_max_x1000", new DataDeviation(56.99, 7.41));
        beaufortSlidefair.put("ic_2_true_x10000", new DataDeviation(19.62, 4.37));
        beaufortSlidefair.put("ic_2_false_x10000", new DataDeviation(24.23, 8.09));
        beaufortSlidefair.put("ic_3_false_x100000", new DataDeviation(17.28, 13.32));
        beaufortSlidefair.put("ic_kappa_x1000", new DataDeviation(57.16, 11.13));
        beaufortSlidefair.put("log_digraph", new DataDeviation(419.53, 25.15));
        beaufortSlidefair.put("log_digraph_reversed", new DataDeviation(422.77, 27.03));
        beaufortSlidefair.put("long_repeat", new DataDeviation(7.03, 1.56));
        beaufortSlidefair.put("long_repeat_odd_percentage", new DataDeviation(44.38, 3.87));
        beaufortSlidefair.put("normal_order", new DataDeviation(235.75, 30.16));
        beaufortSlidefair.put("log_digraph_slidefair_beaufort", new DataDeviation(747.42, 8.51));
        beaufortSlidefair.put("log_digraph_slidefair_variant", new DataDeviation(553.56, 26.85));
        beaufortSlidefair.put("log_digraph_slidefair_vigenere", new DataDeviation(553.88, 26.67));
        HashMap<String, DataHolder<?>> variantSlidefair = CipherStatistics.createOrGetList(map, "Slidefair", "Variant");
        variantSlidefair.put("ic_1_x10000", new DataDeviation(40.23, 1.94));
        variantSlidefair.put("ic_max_x1000", new DataDeviation(57.03, 7.23));
        variantSlidefair.put("ic_2_true_x10000", new DataDeviation(18.56, 3.16));
        variantSlidefair.put("ic_2_false_x10000", new DataDeviation(25.43, 8.01));
        variantSlidefair.put("ic_3_false_x100000", new DataDeviation(16.46, 12.88));
        variantSlidefair.put("ic_kappa_x1000", new DataDeviation(56.45, 10.88));
        variantSlidefair.put("log_digraph", new DataDeviation(422.12, 25.51));
        variantSlidefair.put("log_digraph_reversed", new DataDeviation(427.09, 31.96));
        variantSlidefair.put("long_repeat", new DataDeviation(6.74, 1.36));
        variantSlidefair.put("long_repeat_odd_percentage", new DataDeviation(40.22, 6.14));
        variantSlidefair.put("normal_order", new DataDeviation(239.82, 37.68));
        variantSlidefair.put("log_digraph_slidefair_beaufort", new DataDeviation(554.14, 26.65));
        variantSlidefair.put("log_digraph_slidefair_variant", new DataDeviation(748.43, 7.98));
        variantSlidefair.put("log_digraph_slidefair_vigenere", new DataDeviation(748.52, 7.86));
        HashMap<String, DataHolder<?>> vigenereSlidefair = CipherStatistics.createOrGetList(map, "Slidefair", "Vigenere");
        vigenereSlidefair.put("ic_1_x10000", new DataDeviation(40.23, 1.92));
        vigenereSlidefair.put("ic_max_x1000", new DataDeviation(57.17, 7.32));
        vigenereSlidefair.put("ic_2_true_x10000", new DataDeviation(18.64, 3.19));
        vigenereSlidefair.put("ic_2_false_x10000", new DataDeviation(25.4, 7.99));
        vigenereSlidefair.put("ic_3_false_x100000", new DataDeviation(16.91, 13.29));
        vigenereSlidefair.put("ic_kappa_x1000", new DataDeviation(56.72, 10.95));
        vigenereSlidefair.put("log_digraph", new DataDeviation(421.89, 24.81));
        vigenereSlidefair.put("log_digraph_reversed", new DataDeviation(426.44, 31.2));
        vigenereSlidefair.put("long_repeat", new DataDeviation(6.71, 1.33));
        vigenereSlidefair.put("long_repeat_odd_percentage", new DataDeviation(40.22, 6.29));
        vigenereSlidefair.put("normal_order", new DataDeviation(239.49, 37.85));
        vigenereSlidefair.put("log_digraph_slidefair_beaufort", new DataDeviation(554.22, 26.75));
        vigenereSlidefair.put("log_digraph_slidefair_variant", new DataDeviation(748.67, 7.85));
        vigenereSlidefair.put("log_digraph_slidefair_vigenere", new DataDeviation(748.52, 8.04));
        HashMap<String, DataHolder<?>> beaufortAutokey = CipherStatistics.createOrGetList(map, "Autokey", "Beaufort");
        beaufortAutokey.put("ic_1_x10000", new DataDeviation(39.8, 0.77));
        beaufortAutokey.put("ic_max_x1000", new DataDeviation(41.37, 1.89));
        beaufortAutokey.put("ic_2_true_x10000", new DataDeviation(16.72, 1.58));
        beaufortAutokey.put("ic_2_false_x10000", new DataDeviation(16.68, 2.14));
        beaufortAutokey.put("ic_3_false_x100000", new DataDeviation(11.37, 13.78));
        beaufortAutokey.put("ic_kappa_x1000", new DataDeviation(51.67, 5.75));
        beaufortAutokey.put("log_digraph", new DataDeviation(440.05, 12.71));
        beaufortAutokey.put("log_digraph_reversed", new DataDeviation(151.06, 209.34));
        beaufortAutokey.put("long_repeat", new DataDeviation(6.1, 1.2));
        beaufortAutokey.put("long_repeat_odd_percentage", new DataDeviation(49.74, 2.95));
        beaufortAutokey.put("normal_order", new DataDeviation(206.95, 25.4));
        beaufortAutokey.put("log_digraph_autokey_beaufort", new DataDeviation(759.59, 6.66));
        beaufortAutokey.put("log_digraph_autokey_porta", new DataDeviation(464.2, 23.0));
        beaufortAutokey.put("log_digraph_autokey_variant", new DataDeviation(567.29, 24.57));
        beaufortAutokey.put("log_digraph_autokey_vignere", new DataDeviation(533.37, 33.17));
        HashMap<String, DataHolder<?>> portaAutokey = CipherStatistics.createOrGetList(map, "Autokey", "Porta");
        portaAutokey.put("ic_1_x10000", new DataDeviation(39.32, 0.68));
        portaAutokey.put("ic_max_x1000", new DataDeviation(40.96, 1.9));
        portaAutokey.put("ic_2_true_x10000", new DataDeviation(16.29, 1.64));
        portaAutokey.put("ic_2_false_x10000", new DataDeviation(16.26, 2.22));
        portaAutokey.put("ic_3_false_x100000", new DataDeviation(11.47, 14.61));
        portaAutokey.put("ic_kappa_x1000", new DataDeviation(50.75, 5.65));
        portaAutokey.put("log_digraph", new DataDeviation(428.91, 14.65));
        portaAutokey.put("log_digraph_reversed", new DataDeviation(147.2, 204.01));
        portaAutokey.put("long_repeat", new DataDeviation(6.02, 1.3));
        portaAutokey.put("long_repeat_odd_percentage", new DataDeviation(49.5, 2.86));
        portaAutokey.put("normal_order", new DataDeviation(224.47, 28.31));
        portaAutokey.put("log_digraph_autokey_beaufort", new DataDeviation(532.18, 31.99));
        portaAutokey.put("log_digraph_autokey_porta", new DataDeviation(616.85, 147.33));
        portaAutokey.put("log_digraph_autokey_variant", new DataDeviation(532.39, 33.03));
        portaAutokey.put("log_digraph_autokey_vignere", new DataDeviation(532.28, 32.78));
        HashMap<String, DataHolder<?>> variantAutokey = CipherStatistics.createOrGetList(map, "Autokey", "Variant");
        variantAutokey.put("ic_1_x10000", new DataDeviation(39.79, 0.77));
        variantAutokey.put("ic_max_x1000", new DataDeviation(41.39, 1.87));
        variantAutokey.put("ic_2_true_x10000", new DataDeviation(16.75, 1.64));
        variantAutokey.put("ic_2_false_x10000", new DataDeviation(16.71, 2.22));
        variantAutokey.put("ic_3_false_x100000", new DataDeviation(11.42, 14.19));
        variantAutokey.put("ic_kappa_x1000", new DataDeviation(51.63, 5.76));
        variantAutokey.put("log_digraph", new DataDeviation(440.8, 12.92));
        variantAutokey.put("log_digraph_reversed", new DataDeviation(151.16, 209.43));
        variantAutokey.put("long_repeat", new DataDeviation(6.12, 1.23));
        variantAutokey.put("long_repeat_odd_percentage", new DataDeviation(49.74, 2.95));
        variantAutokey.put("normal_order", new DataDeviation(204.98, 24.77));
        variantAutokey.put("log_digraph_autokey_beaufort", new DataDeviation(568.11, 24.42));
        variantAutokey.put("log_digraph_autokey_porta", new DataDeviation(463.9, 22.99));
        variantAutokey.put("log_digraph_autokey_variant", new DataDeviation(759.63, 6.65));
        variantAutokey.put("log_digraph_autokey_vignere", new DataDeviation(533.99, 32.91));
        HashMap<String, DataHolder<?>> vigenereAutokey = CipherStatistics.createOrGetList(map, "Autokey", "Vigenere");
        vigenereAutokey.put("ic_1_x10000", new DataDeviation(39.84, 0.74));
        vigenereAutokey.put("ic_max_x1000", new DataDeviation(41.52, 2.01));
        vigenereAutokey.put("ic_2_true_x10000", new DataDeviation(16.88, 1.69));
        vigenereAutokey.put("ic_2_false_x10000", new DataDeviation(16.87, 2.25));
        vigenereAutokey.put("ic_3_false_x100000", new DataDeviation(11.85, 14.23));
        vigenereAutokey.put("ic_kappa_x1000", new DataDeviation(65.58, 8.7));
        vigenereAutokey.put("log_digraph", new DataDeviation(442.89, 13.09));
        vigenereAutokey.put("log_digraph_reversed", new DataDeviation(152.26, 211.0));
        vigenereAutokey.put("long_repeat", new DataDeviation(6.23, 1.22));
        vigenereAutokey.put("long_repeat_odd_percentage", new DataDeviation(49.6, 2.85));
        vigenereAutokey.put("normal_order", new DataDeviation(195.94, 22.13));
        vigenereAutokey.put("log_digraph_autokey_beaufort", new DataDeviation(533.36, 33.31));
        vigenereAutokey.put("log_digraph_autokey_porta", new DataDeviation(463.89, 23.86));
        vigenereAutokey.put("log_digraph_autokey_variant", new DataDeviation(533.27, 33.13));
        vigenereAutokey.put("log_digraph_autokey_vignere", new DataDeviation(759.59, 6.73));
        HashMap<String, DataHolder<?>> beaufort = CipherStatistics.createOrGetList(map, "Beaufort");
        beaufort.put("ic_1_x10000", new DataDeviation(42.02, 3.53));
        beaufort.put("ic_max_x1000", new DataDeviation(66.59, 3.2));
        beaufort.put("ic_2_true_x10000", new DataDeviation(24.55, 7.86));
        beaufort.put("ic_2_false_x10000", new DataDeviation(30.56, 15.41));
        beaufort.put("ic_3_false_x100000", new DataDeviation(50.17, 48.68));
        beaufort.put("ic_kappa_x1000", new DataDeviation(69.11, 9.74));
        beaufort.put("log_digraph", new DataDeviation(427.12, 26.45));
        beaufort.put("log_digraph_reversed", new DataDeviation(146.47, 203.46));
        beaufort.put("long_repeat", new DataDeviation(10.4, 2.88));
        beaufort.put("long_repeat_odd_percentage", new DataDeviation(39.32, 11.92));
        beaufort.put("normal_order", new DataDeviation(224.29, 31.48));
        beaufort.put("log_digraph_beaufort", new DataDeviation(759.74, 6.58));
        beaufort.put("log_digraph_porta", new DataDeviation(558.38, 20.65));
        beaufort.put("log_digraph_portax", new DataDeviation(148.38, 205.96));
        beaufort.put("log_digraph_variant", new DataDeviation(576.71, 23.25));
        beaufort.put("log_digraph_vigenere", new DataDeviation(576.84, 23.53));
        HashMap<String, DataHolder<?>> porta = CipherStatistics.createOrGetList(map, "Porta");
        porta.put("ic_1_x10000", new DataDeviation(42.25, 3.82));
        porta.put("ic_max_x1000", new DataDeviation(66.56, 3.18));
        porta.put("ic_2_true_x10000", new DataDeviation(24.58, 8.08));
        porta.put("ic_2_false_x10000", new DataDeviation(29.96, 15.07));
        porta.put("ic_3_false_x100000", new DataDeviation(49.68, 48.22));
        porta.put("ic_kappa_x1000", new DataDeviation(68.88, 9.6));
        porta.put("log_digraph", new DataDeviation(424.35, 30.25));
        porta.put("log_digraph_reversed", new DataDeviation(145.19, 201.84));
        porta.put("long_repeat", new DataDeviation(10.41, 2.89));
        porta.put("long_repeat_odd_percentage", new DataDeviation(39.36, 12.19));
        porta.put("normal_order", new DataDeviation(227.19, 35.3));
        porta.put("log_digraph_beaufort", new DataDeviation(575.25, 22.92));
        porta.put("log_digraph_porta", new DataDeviation(759.66, 6.73));
        porta.put("log_digraph_portax", new DataDeviation(145.88, 202.51));
        porta.put("log_digraph_variant", new DataDeviation(594.95, 22.62));
        porta.put("log_digraph_vigenere", new DataDeviation(595.53, 22.93));
        HashMap<String, DataHolder<?>> portax = CipherStatistics.createOrGetList(map, "Portax");
        portax.put("ic_1_x10000", new DataDeviation(42.77, 1.26));
        portax.put("ic_max_x1000", new DataDeviation(48.63, 3.74));
        portax.put("ic_2_true_x10000", new DataDeviation(19.43, 1.71));
        portax.put("ic_2_false_x10000", new DataDeviation(20.95, 3.37));
        portax.put("ic_3_false_x100000", new DataDeviation(12.72, 9.66));
        portax.put("ic_kappa_x1000", new DataDeviation(54.79, 6.67));
        portax.put("log_digraph", new DataDeviation(438.81, 14.72));
        portax.put("log_digraph_reversed", new DataDeviation(437.86, 16.21));
        portax.put("long_repeat", new DataDeviation(6.76, 1.06));
        portax.put("long_repeat_odd_percentage", new DataDeviation(46.65, 3.66));
        portax.put("normal_order", new DataDeviation(219.68, 15.77));
        portax.put("log_digraph_beaufort", new DataDeviation(546.34, 28.84));
        portax.put("log_digraph_porta", new DataDeviation(525.09, 26.0));
        portax.put("log_digraph_portax", new DataDeviation(663.47, 41.26));
        portax.put("log_digraph_variant", new DataDeviation(546.62, 28.31));
        portax.put("log_digraph_vigenere", new DataDeviation(546.8, 28.51));
        portax.put("text_length_multiple", new DataInteger(2));
        HashMap<String, DataHolder<?>> variant = CipherStatistics.createOrGetList(map, "Variant");
        variant.put("ic_1_x10000", new DataDeviation(42.11, 3.65));
        variant.put("ic_max_x1000", new DataDeviation(66.56, 3.19));
        variant.put("ic_2_true_x10000", new DataDeviation(24.44, 7.95));
        variant.put("ic_2_false_x10000", new DataDeviation(30.21, 15.46));
        variant.put("ic_3_false_x100000", new DataDeviation(49.2, 46.13));
        variant.put("ic_kappa_x1000", new DataDeviation(69.03, 9.75));
        variant.put("log_digraph", new DataDeviation(426.96, 25.72));
        variant.put("log_digraph_reversed", new DataDeviation(146.57, 203.59));
        variant.put("long_repeat", new DataDeviation(10.41, 2.91));
        variant.put("long_repeat_odd_percentage", new DataDeviation(39.64, 11.87));
        variant.put("normal_order", new DataDeviation(223.77, 32.07));
        variant.put("log_digraph_beaufort", new DataDeviation(576.18, 22.98));
        variant.put("log_digraph_porta", new DataDeviation(567.5, 21.75));
        variant.put("log_digraph_portax", new DataDeviation(148.52, 206.13));
        variant.put("log_digraph_variant", new DataDeviation(759.76, 6.53));
        variant.put("log_digraph_vigenere", new DataDeviation(759.74, 6.59));
        HashMap<String, DataHolder<?>> vigenere = CipherStatistics.createOrGetList(map, "Vigenere");
        vigenere.put("ic_1_x10000", new DataDeviation(42.11, 3.63));
        vigenere.put("ic_max_x1000", new DataDeviation(66.55, 3.21));
        vigenere.put("ic_2_true_x10000", new DataDeviation(24.4, 7.92));
        vigenere.put("ic_2_false_x10000", new DataDeviation(30.04, 15.28));
        vigenere.put("ic_3_false_x100000", new DataDeviation(47.32, 45.42));
        vigenere.put("ic_kappa_x1000", new DataDeviation(68.84, 9.57));
        vigenere.put("log_digraph", new DataDeviation(427.82, 26.26));
        vigenere.put("log_digraph_reversed", new DataDeviation(145.92, 202.62));
        vigenere.put("long_repeat", new DataDeviation(10.42, 2.89));
        vigenere.put("long_repeat_odd_percentage", new DataDeviation(39.7, 11.85));
        vigenere.put("normal_order", new DataDeviation(223.29, 32.66));
        vigenere.put("log_digraph_beaufort", new DataDeviation(576.47, 23.67));
        vigenere.put("log_digraph_porta", new DataDeviation(566.66, 22.35));
        vigenere.put("log_digraph_portax", new DataDeviation(148.42, 205.99));
        vigenere.put("log_digraph_variant", new DataDeviation(759.74, 6.61));
        vigenere.put("log_digraph_vigenere", new DataDeviation(759.72, 6.62));
        HashMap<String, DataHolder<?>> beaufortNicodemus = CipherStatistics.createOrGetList(map, "Nicodemus", "Beaufort");
        beaufortNicodemus.put("ic_1_x10000", new DataDeviation(41.37, 2.51));
        beaufortNicodemus.put("ic_max_x1000", new DataDeviation(46.82, 6.4));
        beaufortNicodemus.put("ic_2_true_x10000", new DataDeviation(17.92, 2.7));
        beaufortNicodemus.put("ic_2_false_x10000", new DataDeviation(17.88, 3.03));
        beaufortNicodemus.put("ic_3_false_x100000", new DataDeviation(8.29, 6.37));
        beaufortNicodemus.put("ic_kappa_x1000", new DataDeviation(62.84, 7.94));
        beaufortNicodemus.put("log_digraph", new DataDeviation(427.68, 23.64));
        beaufortNicodemus.put("log_digraph_reversed", new DataDeviation(146.9, 203.87));
        beaufortNicodemus.put("long_repeat", new DataDeviation(6.14, 1.11));
        beaufortNicodemus.put("long_repeat_odd_percentage", new DataDeviation(49.48, 2.62));
        beaufortNicodemus.put("normal_order", new DataDeviation(223.57, 31.44));
        beaufortNicodemus.put("nicodemus_max_3to15", new DataDeviation(66.57, 3.23));
        HashMap<String, DataHolder<?>> portaNicodemus = CipherStatistics.createOrGetList(map, "Nicodemus", "Porta");
        portaNicodemus.put("ic_1_x10000", new DataDeviation(41.49, 2.67));
        portaNicodemus.put("ic_max_x1000", new DataDeviation(46.09, 6.67));
        portaNicodemus.put("ic_2_true_x10000", new DataDeviation(18.33, 2.81));
        portaNicodemus.put("ic_2_false_x10000", new DataDeviation(18.4, 3.23));
        portaNicodemus.put("ic_3_false_x100000", new DataDeviation(8.63, 6.96));
        portaNicodemus.put("ic_kappa_x1000", new DataDeviation(64.43, 7.93));
        portaNicodemus.put("log_digraph", new DataDeviation(426.53, 27.65));
        portaNicodemus.put("log_digraph_reversed", new DataDeviation(146.44, 203.39));
        portaNicodemus.put("long_repeat", new DataDeviation(6.3, 1.15));
        portaNicodemus.put("long_repeat_odd_percentage", new DataDeviation(49.52, 2.67));
        portaNicodemus.put("normal_order", new DataDeviation(227.18, 34.74));
        portaNicodemus.put("nicodemus_max_3to15", new DataDeviation(66.53, 3.23));
        HashMap<String, DataHolder<?>> variantNicodemus = CipherStatistics.createOrGetList(map, "Nicodemus", "Variant");
        variantNicodemus.put("ic_1_x10000", new DataDeviation(41.37, 2.5));
        variantNicodemus.put("ic_max_x1000", new DataDeviation(46.9, 6.55));
        variantNicodemus.put("ic_2_true_x10000", new DataDeviation(17.93, 2.69));
        variantNicodemus.put("ic_2_false_x10000", new DataDeviation(17.98, 3.07));
        variantNicodemus.put("ic_3_false_x100000", new DataDeviation(8.22, 6.23));
        variantNicodemus.put("ic_kappa_x1000", new DataDeviation(62.8, 7.84));
        variantNicodemus.put("log_digraph", new DataDeviation(428.13, 23.01));
        variantNicodemus.put("log_digraph_reversed", new DataDeviation(146.6, 203.44));
        variantNicodemus.put("long_repeat", new DataDeviation(6.1, 1.11));
        variantNicodemus.put("long_repeat_odd_percentage", new DataDeviation(49.46, 2.71));
        variantNicodemus.put("normal_order", new DataDeviation(223.26, 32.23));
        variantNicodemus.put("nicodemus_max_3to15", new DataDeviation(66.55, 3.21));
        HashMap<String, DataHolder<?>> vigenereNicodemus = CipherStatistics.createOrGetList(map, "Nicodemus", "Vigenere");
        vigenereNicodemus.put("ic_1_x10000", new DataDeviation(41.38, 2.51));
        vigenereNicodemus.put("ic_max_x1000", new DataDeviation(46.85, 6.54));
        vigenereNicodemus.put("ic_2_true_x10000", new DataDeviation(17.96, 2.69));
        vigenereNicodemus.put("ic_2_false_x10000", new DataDeviation(17.94, 3.17));
        vigenereNicodemus.put("ic_3_false_x100000", new DataDeviation(8.16, 6.01));
        vigenereNicodemus.put("ic_kappa_x1000", new DataDeviation(62.95, 7.91));
        vigenereNicodemus.put("log_digraph", new DataDeviation(427.76, 23.49));
        vigenereNicodemus.put("log_digraph_reversed", new DataDeviation(146.4, 203.18));
        vigenereNicodemus.put("long_repeat", new DataDeviation(6.14, 1.14));
        vigenereNicodemus.put("long_repeat_odd_percentage", new DataDeviation(49.52, 2.78));
        vigenereNicodemus.put("normal_order", new DataDeviation(223.68, 31.92));
        vigenereNicodemus.put("nicodemus_max_3to15", new DataDeviation(66.52, 3.19));
        HashMap<String, DataHolder<?>> beaufortProgressive = CipherStatistics.createOrGetList(map, "Progressive Key", "Same Period", "Beaufort");
        beaufortProgressive.put("ic_1_x10000", new DataDeviation(38.57, 0.76));
        beaufortProgressive.put("ic_max_x1000", new DataDeviation(42.96, 4.89));
        beaufortProgressive.put("ic_2_true_x10000", new DataDeviation(15.34, 1.71));
        beaufortProgressive.put("ic_2_false_x10000", new DataDeviation(15.82, 3.36));
        beaufortProgressive.put("ic_3_false_x100000", new DataDeviation(8.65, 9.56));
        beaufortProgressive.put("ic_kappa_x1000", new DataDeviation(51.49, 6.47));
        beaufortProgressive.put("log_digraph", new DataDeviation(427.76, 13.24));
        beaufortProgressive.put("log_digraph_reversed", new DataDeviation(146.28, 202.69));
        beaufortProgressive.put("long_repeat", new DataDeviation(5.65, 1.2));
        beaufortProgressive.put("long_repeat_odd_percentage", new DataDeviation(48.28, 4.17));
        beaufortProgressive.put("normal_order", new DataDeviation(223.22, 28.39));
        HashMap<String, DataHolder<?>> portaProgressive = CipherStatistics.createOrGetList(map, "Progressive Key", "Same Period", "Porta");
        portaProgressive.put("ic_1_x10000", new DataDeviation(38.66, 0.71));
        portaProgressive.put("ic_max_x1000", new DataDeviation(42.76, 4.84));
        portaProgressive.put("ic_2_true_x10000", new DataDeviation(15.66, 1.53));
        portaProgressive.put("ic_2_false_x10000", new DataDeviation(16.12, 2.94));
        portaProgressive.put("ic_3_false_x100000", new DataDeviation(9.21, 9.09));
        portaProgressive.put("ic_kappa_x1000", new DataDeviation(52.19, 6.83));
        portaProgressive.put("log_digraph", new DataDeviation(430.15, 12.31));
        portaProgressive.put("log_digraph_reversed", new DataDeviation(147.78, 204.77));
        portaProgressive.put("long_repeat", new DataDeviation(5.8, 1.21));
        portaProgressive.put("long_repeat_odd_percentage", new DataDeviation(48.13, 4.43));
        portaProgressive.put("normal_order", new DataDeviation(216.78, 26.92));
        HashMap<String, DataHolder<?>> variantProgressive = CipherStatistics.createOrGetList(map, "Progressive Key", "Same Period", "Variant");
        variantProgressive.put("ic_1_x10000", new DataDeviation(38.56, 0.68));
        variantProgressive.put("ic_max_x1000", new DataDeviation(43.04, 5.0));
        variantProgressive.put("ic_2_true_x10000", new DataDeviation(15.35, 1.73));
        variantProgressive.put("ic_2_false_x10000", new DataDeviation(15.7, 2.99));
        variantProgressive.put("ic_3_false_x100000", new DataDeviation(8.52, 9.21));
        variantProgressive.put("ic_kappa_x1000", new DataDeviation(51.53, 6.46));
        variantProgressive.put("log_digraph", new DataDeviation(427.14, 13.25));
        variantProgressive.put("log_digraph_reversed", new DataDeviation(146.58, 203.11));
        variantProgressive.put("long_repeat", new DataDeviation(5.61, 1.21));
        variantProgressive.put("long_repeat_odd_percentage", new DataDeviation(48.23, 4.14));
        variantProgressive.put("normal_order", new DataDeviation(223.02, 29.01));
        HashMap<String, DataHolder<?>> vigenereProgressive = CipherStatistics.createOrGetList(map, "Progressive Key", "Same Period", "Vigenere");
        vigenereProgressive.put("ic_1_x10000", new DataDeviation(38.58, 0.77));
        vigenereProgressive.put("ic_max_x1000", new DataDeviation(43.01, 5.0));
        vigenereProgressive.put("ic_2_true_x10000", new DataDeviation(15.36, 1.76));
        vigenereProgressive.put("ic_2_false_x10000", new DataDeviation(15.74, 3.07));
        vigenereProgressive.put("ic_3_false_x100000", new DataDeviation(8.45, 8.8));
        vigenereProgressive.put("ic_kappa_x1000", new DataDeviation(51.64, 6.58));
        vigenereProgressive.put("log_digraph", new DataDeviation(427.38, 13.26));
        vigenereProgressive.put("log_digraph_reversed", new DataDeviation(146.46, 202.94));
        vigenereProgressive.put("long_repeat", new DataDeviation(5.65, 1.22));
        vigenereProgressive.put("long_repeat_odd_percentage", new DataDeviation(48.28, 4.1));
        vigenereProgressive.put("normal_order", new DataDeviation(222.92, 28.55));
        HashMap<String, DataHolder<?>> fractionatedMorse = CipherStatistics.createOrGetList(map, "Fractionated Morse");
        fractionatedMorse.put("ic_1_x10000", new DataDeviation(57.53, 1.5));
        fractionatedMorse.put("ic_max_x1000", new DataDeviation(59.29, 1.89));
        fractionatedMorse.put("ic_2_true_x10000", new DataDeviation(57.22, 2.57));
        fractionatedMorse.put("ic_2_false_x10000", new DataDeviation(57.68, 3.29));
        fractionatedMorse.put("ic_3_false_x100000", new DataDeviation(103.28, 24.2));
        fractionatedMorse.put("ic_kappa_x1000", new DataDeviation(70.24, 8.16));
        fractionatedMorse.put("log_digraph", new DataDeviation(428.02, 48.31));
        fractionatedMorse.put("log_digraph_reversed", new DataDeviation(262.88, 211.72));
        fractionatedMorse.put("long_repeat", new DataDeviation(19.48, 0.89));
        fractionatedMorse.put("long_repeat_odd_percentage", new DataDeviation(49.43, 2.02));
        fractionatedMorse.put("normal_order", new DataDeviation(229.47, 26.68));
        HashMap<String, DataHolder<?>> playfair = CipherStatistics.createOrGetList(map, "Digraph Substitution", "Playfair");
        playfair.put("ic_1_x10000", new DataDeviation(50.37, 2.82));
        playfair.put("ic_max_x1000", new DataDeviation(53.45, 3.26));
        playfair.put("ic_2_true_x10000", new DataDeviation(39.93, 3.8));
        playfair.put("ic_2_false_x10000", new DataDeviation(76.88, 7.37));
        playfair.put("ic_3_false_x100000", new DataDeviation(53.17, 18.66));
        playfair.put("ic_kappa_x1000", new DataDeviation(62.89, 6.94));
        playfair.put("log_digraph", new DataDeviation(449.58, 42.83));
        playfair.put("log_digraph_reversed", new DataDeviation(448.26, 44.98));
        playfair.put("long_repeat", new DataDeviation(13.12, 1.28));
        playfair.put("long_repeat_odd_percentage", new DataDeviation(30.4, 3.64));
        playfair.put("normal_order", new DataDeviation(232.68, 33.07));
        playfair.put("text_length_multiple", new DataInteger(2));
        playfair.put("double_letter_even", new DataBoolean(false));
        playfair.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> fourSquare = CipherStatistics.createOrGetList(map, "Digraph Substitution", "Four Square");
        fourSquare.put("ic_1_x10000", new DataDeviation(46.24, 1.72));
        fourSquare.put("ic_max_x1000", new DataDeviation(54.21, 2.44));
        fourSquare.put("ic_2_true_x10000", new DataDeviation(35.43, 2.96));
        fourSquare.put("ic_2_false_x10000", new DataDeviation(76.93, 7.27));
        fourSquare.put("ic_3_false_x100000", new DataDeviation(47.18, 16.16));
        fourSquare.put("ic_kappa_x1000", new DataDeviation(61.92, 6.74));
        fourSquare.put("log_digraph", new DataDeviation(449.57, 28.82));
        fourSquare.put("log_digraph_reversed", new DataDeviation(449.29, 31.43));
        fourSquare.put("long_repeat", new DataDeviation(12.33, 1.18));
        fourSquare.put("long_repeat_odd_percentage", new DataDeviation(22.08, 3.81));
        fourSquare.put("normal_order", new DataDeviation(232.13, 27.1));
        fourSquare.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> twoSquare = CipherStatistics.createOrGetList(map, "Digraph Substitution", "Two Square");
        twoSquare.put("ic_1_x10000", new DataDeviation(46.1, 2.25));
        twoSquare.put("ic_max_x1000", new DataDeviation(52.91, 3.57));
        twoSquare.put("ic_2_true_x10000", new DataDeviation(35.67, 3.1));
        twoSquare.put("ic_2_false_x10000", new DataDeviation(76.84, 7.28));
        twoSquare.put("ic_3_false_x100000", new DataDeviation(46.08, 17.66));
        twoSquare.put("ic_kappa_x1000", new DataDeviation(61.02, 7.35));
        twoSquare.put("log_digraph", new DataDeviation(485.88, 30.91));
        twoSquare.put("log_digraph_reversed", new DataDeviation(503.94, 34.83));
        twoSquare.put("long_repeat", new DataDeviation(12.33, 1.15));
        twoSquare.put("long_repeat_odd_percentage", new DataDeviation(22.94, 3.75));
        twoSquare.put("normal_order", new DataDeviation(190.71, 33.16));
        twoSquare.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> triSquare = CipherStatistics.createOrGetList(map, "Tri Square");
        triSquare.put("ic_1_x10000", new DataDeviation(42.41, 1.05));
        triSquare.put("ic_max_x1000", new DataDeviation(47.47, 2.14));
        triSquare.put("ic_2_true_x10000", new DataDeviation(20.83, 1.12));
        triSquare.put("ic_2_false_x10000", new DataDeviation(20.88, 1.61));
        triSquare.put("ic_3_false_x100000", new DataDeviation(30.96, 7.9));
        triSquare.put("ic_kappa_x1000", new DataDeviation(53.28, 4.89));
        triSquare.put("log_digraph", new DataDeviation(473.9, 19.35));
        triSquare.put("log_digraph_reversed", new DataDeviation(256.81, 236.13));
        triSquare.put("long_repeat", new DataDeviation(7.45, 0.61));
        triSquare.put("long_repeat_odd_percentage", new DataDeviation(49.45, 1.76));
        triSquare.put("normal_order", new DataDeviation(194.46, 28.14));
        triSquare.put("text_length_multiple", new DataInteger(3));
        triSquare.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> railfence = CipherStatistics.createOrGetList(map, "Transposition", "Railfence");
        railfence.put("ic_1_x10000", new DataDeviation(66.05, 2.72));
        railfence.put("ic_max_x1000", new DataDeviation(68.16, 3.22));
        railfence.put("ic_2_true_x10000", new DataDeviation(45.07, 4.93));
        railfence.put("ic_2_false_x10000", new DataDeviation(45.2, 5.78));
        railfence.put("ic_3_false_x100000", new DataDeviation(32.93, 14.72));
        railfence.put("ic_kappa_x1000", new DataDeviation(81.1, 8.02));
        railfence.put("log_digraph", new DataDeviation(656.59, 8.12));
        railfence.put("log_digraph_reversed", new DataDeviation(225.26, 311.93));
        railfence.put("long_repeat", new DataDeviation(12.09, 1.5));
        railfence.put("long_repeat_odd_percentage", new DataDeviation(49.37, 1.78));
        railfence.put("normal_order", new DataDeviation(73.71, 28.63));
        HashMap<String, DataHolder<?>> myszkowski = CipherStatistics.createOrGetList(map, "Transposition", "Myszkowski");
        myszkowski.put("ic_1_x10000", new DataDeviation(66.05, 2.72));
        myszkowski.put("ic_max_x1000", new DataDeviation(68.15, 3.13));
        myszkowski.put("ic_2_true_x10000", new DataDeviation(45.19, 5.14));
        myszkowski.put("ic_2_false_x10000", new DataDeviation(45.45, 6.08));
        myszkowski.put("ic_3_false_x100000", new DataDeviation(33.19, 16.3));
        myszkowski.put("ic_kappa_x1000", new DataDeviation(81.33, 7.65));
        myszkowski.put("log_digraph", new DataDeviation(660.63, 12.1));
        myszkowski.put("log_digraph_reversed", new DataDeviation(225.34, 312.03));
        myszkowski.put("long_repeat", new DataDeviation(12.13, 1.66));
        myszkowski.put("long_repeat_odd_percentage", new DataDeviation(49.33, 2.04));
        myszkowski.put("normal_order", new DataDeviation(73.71, 28.63));
        HashMap<String, DataHolder<?>> phillipsRow = CipherStatistics.createOrGetList(map, "Phillips", "Rows");
        phillipsRow.put("ic_1_x10000", new DataDeviation(51.88, 2.75));
        phillipsRow.put("ic_max_x1000", new DataDeviation(55.24, 3.04));
        phillipsRow.put("ic_2_true_x10000", new DataDeviation(35.64, 3.92));
        phillipsRow.put("ic_2_false_x10000", new DataDeviation(35.81, 4.66));
        phillipsRow.put("ic_3_false_x100000", new DataDeviation(38.88, 18.28));
        phillipsRow.put("ic_kappa_x1000", new DataDeviation(63.32, 7.15));
        phillipsRow.put("log_digraph", new DataDeviation(439.3, 37.1));
        phillipsRow.put("log_digraph_reversed", new DataDeviation(150.22, 209.12));
        phillipsRow.put("long_repeat", new DataDeviation(12.48, 1.61));
        phillipsRow.put("long_repeat_odd_percentage", new DataDeviation(49.28, 1.94));
        phillipsRow.put("normal_order", new DataDeviation(240.0, 25.53));
        phillipsRow.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> phillipsCol = CipherStatistics.createOrGetList(map, "Phillips", "Columns");
        phillipsCol.put("ic_1_x10000", new DataDeviation(51.88, 2.78));
        phillipsCol.put("ic_max_x1000", new DataDeviation(55.24, 3.01));
        phillipsCol.put("ic_2_true_x10000", new DataDeviation(35.58, 3.9));
        phillipsCol.put("ic_2_false_x10000", new DataDeviation(35.78, 4.55));
        phillipsCol.put("ic_3_false_x100000", new DataDeviation(38.96, 18.47));
        phillipsCol.put("ic_kappa_x1000", new DataDeviation(63.29, 7.18));
        phillipsCol.put("log_digraph", new DataDeviation(439.49, 36.29));
        phillipsCol.put("log_digraph_reversed", new DataDeviation(151.08, 210.3));
        phillipsCol.put("long_repeat", new DataDeviation(12.48, 1.63));
        phillipsCol.put("long_repeat_odd_percentage", new DataDeviation(49.32, 1.96));
        phillipsCol.put("normal_order", new DataDeviation(239.62, 25.92));
        phillipsCol.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> phillipsRowCol = CipherStatistics.createOrGetList(map, "Phillips", "Rows & Columns");
        phillipsRowCol.put("ic_1_x10000", new DataDeviation(47.06, 2.16));
        phillipsRowCol.put("ic_max_x1000", new DataDeviation(51.66, 2.79));
        phillipsRowCol.put("ic_2_true_x10000", new DataDeviation(27.45, 2.71));
        phillipsRowCol.put("ic_2_false_x10000", new DataDeviation(27.73, 3.45));
        phillipsRowCol.put("ic_3_false_x100000", new DataDeviation(24.71, 13.79));
        phillipsRowCol.put("ic_kappa_x1000", new DataDeviation(57.99, 6.68));
        phillipsRowCol.put("log_digraph", new DataDeviation(439.81, 29.37));
        phillipsRowCol.put("log_digraph_reversed", new DataDeviation(150.74, 209.46));
        phillipsRowCol.put("long_repeat", new DataDeviation(10.12, 1.43));
        phillipsRowCol.put("long_repeat_odd_percentage", new DataDeviation(49.1, 2.21));
        phillipsRowCol.put("normal_order", new DataDeviation(241.57, 25.93));
        phillipsRowCol.put("max_unique_characters", new DataInteger(25));
        HashMap<String, DataHolder<?>> caesar = CipherStatistics.createOrGetList(map, "Simple Substitution", "Caesar Shift");
        caesar.put("ic_1_x10000", new DataDeviation(66.05, 2.72));
        caesar.put("ic_max_x1000", new DataDeviation(68.38, 3.08));
        caesar.put("ic_2_true_x10000", new DataDeviation(76.71, 6.7));
        caesar.put("ic_2_false_x10000", new DataDeviation(76.99, 7.24));
        caesar.put("ic_3_false_x100000", new DataDeviation(168.14, 61.95));
        caesar.put("ic_kappa_x1000", new DataDeviation(80.69, 8.86));
        caesar.put("log_digraph", new DataDeviation(419.22, 49.38));
        caesar.put("log_digraph_reversed", new DataDeviation(144.43, 201.92));
        caesar.put("long_repeat", new DataDeviation(23.91, 2.04));
        caesar.put("long_repeat_odd_percentage", new DataDeviation(49.67, 1.56));
        caesar.put("normal_order", new DataDeviation(232.01, 24.12));
        caesar.put("log_digraph_caesar", new DataDeviation(760.04, 6.7));
        caesar.put("log_digraph_affine", new DataDeviation(602.31, 9.15));
        HashMap<String, DataHolder<?>> keyword = CipherStatistics.createOrGetList(map, "Simple Substitution", "Generic");
        keyword.put("ic_1_x10000", new DataDeviation(66.05, 2.72));
        keyword.put("ic_max_x1000", new DataDeviation(68.38, 3.08));
        keyword.put("ic_2_true_x10000", new DataDeviation(76.71, 6.7));
        keyword.put("ic_2_false_x10000", new DataDeviation(76.99, 7.24));
        keyword.put("ic_3_false_x100000", new DataDeviation(168.14, 61.95));
        keyword.put("ic_kappa_x1000", new DataDeviation(80.69, 8.86));
        keyword.put("log_digraph", new DataDeviation(426.4, 58.37));
        keyword.put("log_digraph_reversed", new DataDeviation(147.15, 206.55));
        keyword.put("long_repeat", new DataDeviation(23.91, 2.04));
        keyword.put("long_repeat_odd_percentage", new DataDeviation(49.67, 1.56));
        keyword.put("normal_order", new DataDeviation(225.46, 28.28));
        keyword.put("log_digraph_caesar", new DataDeviation(539.81, 22.21));
        keyword.put("log_digraph_affine", new DataDeviation(576.99, 15.98));
        HashMap<String, DataHolder<?>> affine = CipherStatistics.createOrGetList(map, "Simple Substitution", "Affine");
        affine.put("ic_1_x10000", new DataDeviation(66.05, 2.72));
        affine.put("ic_max_x1000", new DataDeviation(68.38, 3.08));
        affine.put("ic_2_true_x10000", new DataDeviation(76.71, 6.7));
        affine.put("ic_2_false_x10000", new DataDeviation(76.99, 7.24));
        affine.put("ic_3_false_x100000", new DataDeviation(168.14, 61.95));
        affine.put("ic_kappa_x1000", new DataDeviation(80.69, 8.86));
        affine.put("log_digraph", new DataDeviation(429.37, 59.85));
        affine.put("log_digraph_reversed", new DataDeviation(147.42, 207.11));
        affine.put("long_repeat", new DataDeviation(23.91, 2.04));
        affine.put("long_repeat_odd_percentage", new DataDeviation(49.67, 1.56));
        affine.put("normal_order", new DataDeviation(225.51, 27.86));
        affine.put("log_digraph_caesar", new DataDeviation(543.08, 24.88));
        affine.put("log_digraph_affine", new DataDeviation(760.04, 6.7));
        HashMap<String, DataHolder<?>> substitution = CipherStatistics.createOrGetList(map, "Substitution");
        substitution.put("ic_1_x10000", new DataDeviation(66.01, 2.71));
        substitution.put("ic_max_x1000", new DataDeviation(68.32, 3.07));
        substitution.put("ic_kappa_x1000", new DataDeviation(80.63, 8.91));
        substitution.put("ic_2_true_x10000", new DataDeviation(76.8, 6.7));
        substitution.put("ic_2_false_x10000", new DataDeviation(77.11, 7.21));
        substitution.put("long_repeat", new DataDeviation(23.97, 2.01));
        substitution.put("long_repeat_odd_percentage", new DataDeviation(49.65, 1.57));
        substitution.put("normal_order", new DataDeviation(225.32, 27.91));
        substitution.put("bifid_0", new DataDeviation(271.18, 26.95));
        substitution.put("bifid_max_3to15", new DataDeviation(474.12, 76.01));
        substitution.put("nicodemus_max_3to15", new DataDeviation(66.02, 8.48));
        substitution.put("trifid_max_3to15", new DataDeviation(3739.1, 1076.86));
        substitution.put("log_digraph", new DataDeviation(428.49, 60.44));
        substitution.put("log_digraph_beaufort", new DataDeviation(581.67, 24.57));
        substitution.put("log_digraph_vigenere", new DataDeviation(582.17, 25.37));
        substitution.put("log_digraph_porta", new DataDeviation(563.44, 24.75));
        HashMap<String, DataHolder<?>> seriatedPlayfair = CipherStatistics.createOrGetList(map, "Seriated Playfair");
        seriatedPlayfair.put("ic_1_x10000", new DataDeviation(49.11, 2.5));
        seriatedPlayfair.put("ic_max_x1000", new DataDeviation(50.98, 3.01));
        seriatedPlayfair.put("ic_kappa_x1000", new DataDeviation(61.54, 6.77));
        seriatedPlayfair.put("ic_2_true_x10000", new DataDeviation(26.42, 2.85));
        seriatedPlayfair.put("ic_2_false_x10000", new DataDeviation(26.67, 3.58));
        seriatedPlayfair.put("long_repeat", new DataDeviation(8.59, 1.26));
        seriatedPlayfair.put("long_repeat_odd_percentage", new DataDeviation(49.44, 2.34));
        seriatedPlayfair.put("normal_order", new DataDeviation(232.46, 32.85));
        seriatedPlayfair.put("bifid_0", new DataDeviation(150.77, 19.73));
        seriatedPlayfair.put("bifid_max_3to15", new DataDeviation(227.3, 70.01));
        seriatedPlayfair.put("nicodemus_max_3to15", new DataDeviation(50.7, 3.0));
        seriatedPlayfair.put("trifid_max_3to15", new DataDeviation(552.35, 348.77));
        seriatedPlayfair.put("log_digraph", new DataDeviation(450.54, 39.54));
        seriatedPlayfair.put("log_digraph_beaufort", new DataDeviation(551.36, 28.03));
        seriatedPlayfair.put("log_digraph_vigenere", new DataDeviation(552.18, 27.97));
        seriatedPlayfair.put("log_digraph_porta", new DataDeviation(538.39, 25.16));
        seriatedPlayfair.put("text_length_multiple", new DataInteger(2));
        seriatedPlayfair.put("double_letter_even_2to40", new DataBoolean(false));
        HashMap<String, DataHolder<?>> solitaire = CipherStatistics.createOrGetList(map, "Solitaire");
        solitaire.put("ic_1_x10000", new DataDeviation(38.46, 0.42));
        solitaire.put("ic_max_x1000", new DataDeviation(49.92, 5.73));
        solitaire.put("ic_kappa_x1000", new DataDeviation(40.03, 1.68));
        solitaire.put("ic_2_true_x10000", new DataDeviation(14.79, 0.87));
        solitaire.put("ic_2_false_x10000", new DataDeviation(14.78, 1.63));
        solitaire.put("long_repeat", new DataDeviation(5.14, 0.89));
        solitaire.put("long_repeat_odd_percentage", new DataDeviation(49.62, 2.96));
        solitaire.put("normal_order", new DataDeviation(222.46, 29.75));
        solitaire.put("bifid_0", new DataDeviation(92.37, 10.5));
        solitaire.put("bifid_max_3to15", new DataDeviation(105.27, 13.88));
        solitaire.put("nicodemus_max_3to15", new DataDeviation(40.0, 2.58));
        solitaire.put("trifid_max_3to15", new DataDeviation(233.81, 159.81));
        solitaire.put("log_digraph", new DataDeviation(427.6, 12.22));
        solitaire.put("log_digraph_beaufort", new DataDeviation(531.78, 32.8));
        solitaire.put("log_digraph_vigenere", new DataDeviation(531.75, 33.0));
        solitaire.put("log_digraph_porta", new DataDeviation(517.67, 28.99));
        HashMap<String, DataHolder<?>> amsco = CipherStatistics.createOrGetList(map, "Transposition", "AMSCO");
        amsco.put("ic_1_x10000", new DataDeviation(66.0, 2.71));
        amsco.put("ic_max_x1000", new DataDeviation(68.12, 3.15));
        amsco.put("ic_kappa_x1000", new DataDeviation(80.85, 7.47));
        amsco.put("ic_2_true_x10000", new DataDeviation(46.67, 4.14));
        amsco.put("ic_2_false_x10000", new DataDeviation(46.68, 4.95));
        amsco.put("long_repeat", new DataDeviation(12.36, 1.22));
        amsco.put("long_repeat_odd_percentage", new DataDeviation(49.51, 1.71));
        amsco.put("normal_order", new DataDeviation(72.55, 30.11));
        amsco.put("bifid_0", new DataDeviation(277.92, 31.4));
        amsco.put("bifid_max_3to15", new DataDeviation(307.49, 48.82));
        amsco.put("nicodemus_max_3to15", new DataDeviation(66.88, 8.69));
        amsco.put("trifid_max_3to15", new DataDeviation(930.32, 328.88));
        amsco.put("log_digraph", new DataDeviation(691.99, 7.79));
        amsco.put("log_digraph_beaufort", new DataDeviation(579.08, 25.3));
        amsco.put("log_digraph_vigenere", new DataDeviation(693.02, 7.01));
        amsco.put("log_digraph_porta", new DataDeviation(565.05, 22.86));
        HashMap<String, DataHolder<?>> bifid = CipherStatistics.createOrGetList(map, "Bifid", "P:3-15", "Single");
        bifid.put("ic_1_x10000", new DataDeviation(45.71, 3.08));
        bifid.put("ic_max_x1000", new DataDeviation(51.69, 4.42));
        bifid.put("ic_kappa_x1000", new DataDeviation(60.6, 8.31));
        bifid.put("ic_2_true_x10000", new DataDeviation(24.18, 4.71));
        bifid.put("ic_2_false_x10000", new DataDeviation(27.41, 14.12));
        bifid.put("long_repeat", new DataDeviation(8.47, 1.91));
        bifid.put("long_repeat_odd_percentage", new DataDeviation(47.21, 7.22));
        bifid.put("normal_order", new DataDeviation(192.41, 27.67));
        bifid.put("bifid_0", new DataDeviation(149.14, 69.68));
        bifid.put("bifid_max_3to15", new DataDeviation(334.4, 126.1));
        bifid.put("log_digraph", new DataDeviation(488.75, 29.66));
        HashMap<String, DataHolder<?>> bifid0 = CipherStatistics.createOrGetList(map, "Bifid", "P:0", "Single");
        bifid0.put("ic_1_x10000", new DataDeviation(45.71, 3.06));
        bifid0.put("ic_max_x1000", new DataDeviation(47.56, 3.54));
        bifid0.put("ic_kappa_x1000", new DataDeviation(64.95, 8.69));
        bifid0.put("ic_2_true_x10000", new DataDeviation(24.3, 3.34));
        bifid0.put("ic_2_false_x10000", new DataDeviation(24.7, 3.98));
        bifid0.put("long_repeat", new DataDeviation(8.64, 1.31));
        bifid0.put("long_repeat_odd_percentage", new DataDeviation(49.17, 2.64));
        bifid0.put("normal_order", new DataDeviation(195.67, 27.71));
        bifid0.put("bifid_0", new DataDeviation(375.02, 86.87));
        bifid0.put("bifid_max_3to15", new DataDeviation(158.13, 24.58));
        bifid0.put("log_digraph", new DataDeviation(485.04, 29.57));
        HashMap<String, DataHolder<?>> cmBifid = CipherStatistics.createOrGetList(map, "Bifid", "P:3-15", "Conjugated");
        cmBifid.put("ic_1_x10000", new DataDeviation(45.68, 3.12));
        cmBifid.put("ic_max_x1000", new DataDeviation(51.98, 4.35));
        cmBifid.put("ic_2_true_x10000", new DataDeviation(24.26, 4.82));
        cmBifid.put("ic_2_false_x10000", new DataDeviation(27.95, 15.04));
        cmBifid.put("ic_3_false_x100000", new DataDeviation(29.74, 45.1));
        cmBifid.put("ic_kappa_x1000", new DataDeviation(60.42, 8.26));
        cmBifid.put("log_digraph", new DataDeviation(485.04, 29.57));
        cmBifid.put("log_digraph_reversed", new DataDeviation(154.16, 214.02));
        cmBifid.put("long_repeat", new DataDeviation(8.5, 1.98));
        cmBifid.put("long_repeat_odd_percentage", new DataDeviation(46.95, 7.56));
        cmBifid.put("normal_order", new DataDeviation(231.95, 27.02));
        cmBifid.put("bifid_0", new DataDeviation(131.74, 21.57));
        cmBifid.put("bifid_max_3to15", new DataDeviation(347.12, 120.85));
        HashMap<String, DataHolder<?>> cmBifid0 = CipherStatistics.createOrGetList(map, "Bifid", "P:0", "Conjugated");
        cmBifid0.put("ic_1_x10000", new DataDeviation(45.82, 3.09));
        cmBifid0.put("ic_max_x1000", new DataDeviation(47.53, 3.56));
        cmBifid0.put("ic_2_true_x10000", new DataDeviation(24.27, 3.33));
        cmBifid0.put("ic_2_false_x10000", new DataDeviation(24.72, 4.06));
        cmBifid0.put("ic_3_false_x100000", new DataDeviation(19.23, 12.92));
        cmBifid0.put("ic_kappa_x1000", new DataDeviation(64.87, 8.67));
        cmBifid0.put("log_digraph", new DataDeviation(485.04, 29.57));
        cmBifid0.put("log_digraph_reversed", new DataDeviation(154.54, 214.59));
        cmBifid0.put("long_repeat", new DataDeviation(8.67, 1.31));
        cmBifid0.put("long_repeat_odd_percentage", new DataDeviation(49.16, 2.78));
        cmBifid0.put("normal_order", new DataDeviation(232.04, 27.02));
        cmBifid0.put("bifid_0", new DataDeviation(374.11, 86.62));
        cmBifid0.put("bifid_max_3to15", new DataDeviation(157.91, 24.59));
        HashMap<String, DataHolder<?>> enigma = CipherStatistics.createOrGetList(map, "Enigma", "NOPLUGBOARD");
        enigma.put("ic_1_x10000", new DataDeviation(38.5, 0.43));
        enigma.put("ic_max_x1000", new DataDeviation(40.07, 1.69));
        enigma.put("ic_kappa_x1000", new DataDeviation(49.87, 5.66));
        enigma.put("ic_2_true_x10000", new DataDeviation(14.82, 0.89));
        enigma.put("ic_2_false_x10000", new DataDeviation(14.85, 1.72));
        enigma.put("long_repeat", new DataDeviation(5.15, 0.9));
        enigma.put("long_repeat_odd_percentage", new DataDeviation(49.56, 3.09));
        enigma.put("normal_order", new DataDeviation(248.33, 27.69));
        enigma.put("bifid_0", new DataDeviation(92.89, 10.65));
        enigma.put("bifid_max_3to15", new DataDeviation(105.43, 12.67));
        enigma.put("nicodemus_max_3to15", new DataDeviation(40.15, 1.95));
        enigma.put("trifid_max_3to15", new DataDeviation(234.66, 160.42));
        enigma.put("log_digraph", new DataDeviation(418.27, 12.27));
        enigma.put("log_digraph_porta", new DataDeviation(518.66, 29.14));
        enigma.put("log_digraph_autokey_beaufort", new DataDeviation(531.92, 33.05));
        enigma.put("log_digraph_autokey_porta", new DataDeviation(464.62, 23.28));
        enigma.put("log_digraph_autokey_variant", new DataDeviation(531.94, 32.9));
        enigma.put("log_digraph_autokey_vignere", new DataDeviation(531.81, 32.98));
        enigma.put("log_digraph_portax", new DataDeviation(149.94, 205.56));
        HashMap<String, DataHolder<?>> bazeries = CipherStatistics.createOrGetList(map, "Bazeries");
        bazeries.put("ic_1_x10000", new DataDeviation(66.21, 2.7));
        bazeries.put("ic_max_x1000", new DataDeviation(68.47, 3.22));
        bazeries.put("ic_kappa_x1000", new DataDeviation(78.5, 7.52));
        bazeries.put("ic_2_true_x10000", new DataDeviation(63.89, 6.21));
        bazeries.put("ic_2_false_x10000", new DataDeviation(64.93, 8.15));
        bazeries.put("long_repeat", new DataDeviation(19.16, 2.07));
        bazeries.put("long_repeat_odd_percentage", new DataDeviation(49.4, 1.7));
        bazeries.put("normal_order", new DataDeviation(238.77, 20.61));
        bazeries.put("bifid_0", new DataDeviation(272.98, 29.53));
        bazeries.put("bifid_max_3to15", new DataDeviation(405.23, 44.16));
        bazeries.put("nicodemus_max_3to15", new DataDeviation(67.62, 2.96));
        bazeries.put("trifid_max_3to15", new DataDeviation(2133.32, 631.66));
        bazeries.put("log_digraph", new DataDeviation(485.48, 36.77));
        bazeries.put("log_digraph_beaufort", new DataDeviation(579.48, 25.5));
        bazeries.put("log_digraph_vigenere", new DataDeviation(578.51, 25.18));
        bazeries.put("log_digraph_porta", new DataDeviation(555.82, 25.0));
        HashMap<String, DataHolder<?>> trifid = CipherStatistics.createOrGetList(map, "Trifid");
        trifid.put("ic_1_x10000", new DataDeviation(39.94, 2.34));
        trifid.put("ic_max_x1000", new DataDeviation(46.2, 4.32));
        trifid.put("ic_kappa_x1000", new DataDeviation(54.23, 7.88));
        trifid.put("ic_2_true_x10000", new DataDeviation(17.11, 2.63));
        trifid.put("ic_2_false_x10000", new DataDeviation(17.6, 3.56));
        trifid.put("long_repeat", new DataDeviation(6.41, 1.77));
        trifid.put("long_repeat_odd_percentage", new DataDeviation(48.72, 3.73));
        trifid.put("normal_order", new DataDeviation(0.1, 4.28));
        trifid.put("bifid_0", new DataDeviation(0.04, 2.17));
        trifid.put("bifid_max_3to15", new DataDeviation(0.05, 3.05));
        trifid.put("nicodemus_max_3to15", new DataDeviation(0.01, 0.68));
        trifid.put("trifid_max_3to15", new DataDeviation(1598.23, 1572.71));
        trifid.put("log_digraph", new DataDeviation(417.69, 25.51));
        trifid.put("log_digraph_beaufort", new DataDeviation(0.0, 0.0));
        trifid.put("log_digraph_vigenere", new DataDeviation(0.0, 0.0));
        trifid.put("log_digraph_porta", new DataDeviation(0.0, 0.0));
        return map;
    }

    public static HashMap<String, DataHolder<?>> createOrGetList(Map<String, Object> map, String ... keys) {
        TreeMap<String, AbstractMap> last = map;
        for (int i = 0; i < keys.length; ++i) {
            if (i == keys.length - 1) {
                last.put(keys[i], new HashMap());
                return (HashMap)last.get(keys[i]);
            }
            if (last.containsKey(keys[i])) {
                last = (TreeMap<String, AbstractMap>)last.get(keys[i]);
                continue;
            }
            TreeMap<String, AbstractMap> newMap = new TreeMap<String, AbstractMap>();
            last.put(keys[i], newMap);
            last = newMap;
        }
        return null;
    }
}

