/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import com.alexbarter.lib.util.MathUtil;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.key.KeyIterator;
import tools.cipher.base.settings.ICipherSettingProvider;
import tools.cipher.base.settings.SettingTypes;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.ciphers.HillExtendedCipher;
import tools.cipher.lib.fitness.ChiSquared;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.lib.matrix.Matrix;
import tools.cipher.lib.matrix.MatrixNoInverse;
import tools.cipher.lib.matrix.MatrixNotSquareException;
import tools.cipher.lib.result.DynamicResultList;
import tools.cipher.lib.result.Result;
import tools.cipher.lib.result.Solution;
import tools.cipher.solve.HillAttack;

public class HillExtendedAttack
extends CipherAttack<BiKey<Matrix, Matrix>, HillExtendedCipher> {
    private int[] sizeRange = new int[]{2, 4};

    public HillExtendedAttack() {
        super((ICipher)new HillExtendedCipher(), "Hill Extended");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.PERIODIC_KEY});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"size_range", (int)2, (int)4, (int)2, (int)100, (int)1, (values, cipher) -> {
            this.sizeRange = values;
        })});
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        super.createSettingsUI(dialog, panel);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        HillTracker tracker = new HillTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int size = this.sizeRange[0]; size <= this.sizeRange[1]; ++size) {
                    tracker.resultList.clear();
                    if (tracker.getCipherText().length() % size != 0) {
                        this.output((IDecryptionTracker)tracker, "Matrix size of %d is not possible, length of text is not a multiple.", new Object[]{size});
                        continue;
                    }
                    tracker.size = size;
                    tracker.lengthSub = tracker.getCipherText().length() / size;
                    KeyIterator.iterateIntegerArray(row -> this.iterateMatrixRows(tracker, (Integer[])row), (int)(size + 1), (int)26, (boolean)true);
                    tracker.resultList.sort();
                    if (tracker.resultList.size() < size) {
                        this.output((IDecryptionTracker)tracker, "Did not find enought key columns that produces good characters %d/%d", new Object[]{tracker.resultList.size(), size});
                        continue;
                    }
                    KeyIterator.iterateObject(row -> this.iteratePossibleRows(tracker, (HillAttack.HillSection[])row), (int)size, (Object[])tracker.resultList.toArray((Object[])new HillAttack.HillSection[0]));
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public void decryptAndUpdate(IDecryptionTracker tracker, BiKey<Matrix, Matrix> key) {
        try {
            super.decryptAndUpdate(tracker, key);
        }
        catch (MatrixNoInverse | MatrixNotSquareException e) {
            return;
        }
    }

    public boolean iterateMatrixRows(HillTracker tracker, Integer[] row) {
        if (MathUtil.allDivisibleBy((Integer[])row, (int)0, (int)tracker.size, (int[])new int[]{2, 13})) {
            return true;
        }
        char[] decrypted = new char[tracker.lengthSub];
        for (int i = 0; i < tracker.getCipherText().length(); i += tracker.size) {
            int total = 0;
            for (int s = 0; s < tracker.size; ++s) {
                total += row[s] * (tracker.getCipherText().charAt(i + s) - 65);
            }
            decrypted[i / ((HillTracker)tracker).size] = (char)((total + (26 - row[tracker.size])) % 26 + 65);
        }
        double score = ChiSquared.calculate((char[])decrypted, (ILanguage)tracker.getLanguage());
        if (tracker.resultList.add((Result)new HillAttack.HillSection(score, decrypted, Arrays.copyOf(row, row.length))) && score < 80.0) {
            this.output((IDecryptionTracker)tracker, "%s, %f, %s", new Object[]{Arrays.toString((Object[])row), score, new String(decrypted)});
        }
        return true;
    }

    public boolean iteratePossibleRows(HillTracker tracker, HillAttack.HillSection[] data) {
        Integer[] inverseData = new Integer[tracker.size * tracker.size];
        Integer[] extendedData = new Integer[tracker.size];
        for (int s = 0; s < tracker.size; ++s) {
            HillAttack.HillSection hillResult = data[s];
            for (int n = 0; n < tracker.size; ++n) {
                inverseData[s * ((HillTracker)tracker).size + n] = hillResult.inverseCol[n];
            }
            extendedData[s] = hillResult.inverseCol[tracker.size];
        }
        Matrix inverseMatrix = new Matrix(inverseData, tracker.size);
        if (!inverseMatrix.hasInverseMod(26)) {
            return true;
        }
        for (int s = 0; s < tracker.size; ++s) {
            HillAttack.HillSection hillResult = data[s];
            for (int i = 0; i < tracker.lengthSub; ++i) {
                tracker.getHolder()[i * ((HillTracker)tracker).size + s] = hillResult.decrypted[i];
            }
        }
        tracker.setLastSolution(new Solution(tracker.getHolder(), tracker.getLanguage()));
        this.updateIfBetterThanBest((IDecryptionTracker)tracker, tracker.getLastSolution(), () -> BiKey.of((Object)inverseMatrix.inverseMod(26), (Object)new Matrix(extendedData, tracker.size, 1)));
        return true;
    }

    public class HillTracker
    extends DecryptionTracker {
        private int size;
        private int lengthSub;
        private DynamicResultList<HillAttack.HillSection> resultList;

        public HillTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.resultList = new DynamicResultList(8);
        }
    }
}

