/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.ciphers.solitaire.Solitaire;

public class SolitaireCipher
extends UniKeyCipher<Integer[], OrderedIntegerKeyType.Builder> {
    public SolitaireCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(54, 54));
    }

    public CharSequence encode(CharSequence plainText, Integer[] key) {
        String cipherText = "";
        int index = 0;
        while (index < plainText.length()) {
            int topCard = (key = Solitaire.nextCardOrder(key))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? key[topCard + 1].intValue() : key[key.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            cipherText = cipherText + (char)((plainText.charAt(index) - 65 + (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, Integer[] key) {
        int index = 0;
        for (int i = 0; i < index; ++i) {
            plainText[i] = cipherText.charAt(i);
        }
        while (index < cipherText.length()) {
            int topCard = (key = Solitaire.nextCardOrder(key))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? key[topCard + 1].intValue() : key[key.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            plainText[index] = (char)((52 + (cipherText.charAt(index) - 65) - (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return plainText;
    }
}

