/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.IntegerKeyType;
import tools.cipher.lib.NumberString;

public class BazeriesCipher
extends UniKeyCipher<Integer, IntegerKeyType.Builder> {
    public BazeriesCipher() {
        super((IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(0, Integer.MAX_VALUE));
    }

    public IntegerKeyType.Builder limitDomainForFirstKey(IntegerKeyType.Builder firstKey) {
        return firstKey.setRange(0, 1000000);
    }

    public CharSequence normaliseText(CharSequence plainText, Integer key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, Integer key) {
        String alphabetSquare = "AFLQVBGMRWCHNSXDIOTYEKPUZ";
        String numberSquare = "";
        for (char j : NumberString.convert((int)key).toCharArray()) {
            if (numberSquare.indexOf(j) != -1) continue;
            numberSquare = numberSquare + j;
        }
        for (char j : "ABCDEFGHIKLMNOPQRSTUVWXYZ".toCharArray()) {
            if (numberSquare.indexOf(j) != -1) continue;
            numberSquare = numberSquare + j;
        }
        String s = "" + key;
        String cipherText = "";
        int textPos = 0;
        int count = 0;
        int split = s.charAt(0) - 48;
        while (true) {
            for (int j = textPos + split - 1; j >= textPos; --j) {
                if (j >= plainText.length()) continue;
                char c = plainText.charAt(j);
                cipherText = cipherText + numberSquare.charAt(alphabetSquare.indexOf(c));
            }
            if (textPos + split >= plainText.length()) break;
            textPos += split;
            split = s.charAt(++count % s.length()) - 48;
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] unused, Integer key) {
        String alphabetSquare = "AFLQVBGMRWCHNSXDIOTYEKPUZ";
        String numberSquare = "";
        for (char j : NumberString.convert((int)key).toCharArray()) {
            if (numberSquare.indexOf(j) != -1) continue;
            numberSquare = numberSquare + j;
        }
        for (char j : "ABCDEFGHIKLMNOPQRSTUVWXYZ".toCharArray()) {
            if (numberSquare.indexOf(j) != -1) continue;
            numberSquare = numberSquare + j;
        }
        String s = "" + key;
        StringBuilder plainText = new StringBuilder();
        int textPos = 0;
        int count = 0;
        int split = s.charAt(0) - 48;
        while (true) {
            for (int j = textPos + split - 1; j >= textPos; --j) {
                if (j >= cipherText.length()) continue;
                char c = cipherText.charAt(j);
                plainText.append(alphabetSquare.charAt(numberSquare.indexOf(c)));
            }
            if (textPos + split >= cipherText.length()) break;
            textPos += split;
            split = s.charAt(++count % s.length()) - 48;
        }
        return plainText.toString().toCharArray();
    }

    public char[] decodeEfficiently(CharSequence cipherText, Integer key) {
        return this.decodeEfficiently(cipherText, null, key);
    }
}

