/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.base.settings.ICipherSettingProvider;
import tools.cipher.base.settings.SettingTypes;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.IKeySearchAttack;

public class PeriodicKeyAttack<C extends UniKeyCipher<String, ? extends IRangedKeyType.IRangedKeyBuilder<String>>>
extends CipherAttack<String, C>
implements IKeySearchAttack<String> {
    public int[] periodRange;
    private int charStep = 1;

    public PeriodicKeyAttack(C cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.BRUTE_FORCE});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)15, (int)2, (int)100, (int)1, (range, cipher2) -> {
            this.periodRange = range;
            cipher2.setDomain(builder -> builder.setRange(range));
        })});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        IDecryptionTracker tracker = this.createTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int period = this.periodRange[0]; period <= this.periodRange[1]; ++period) {
                    this.tryKeySearch(tracker, period);
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return periodicPart;
    }

    public int getCharStep() {
        return this.charStep;
    }

    public PeriodicKeyAttack<C> setCharStep(int charStep) {
        this.charStep = charStep;
        return this;
    }
}

