/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import com.alexbarter.lib.util.ArrayUtil;
import java.util.Arrays;
import java.util.Iterator;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.ciphers.TriKey;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.settings.ICipherSettingProvider;
import tools.cipher.base.settings.SettingTypes;
import tools.cipher.base.settings.SettingsCache;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.ciphers.ADFGXCipher;
import tools.cipher.ciphers.ColumnarTranspositionCipher;
import tools.cipher.ciphers.KeywordCipher;
import tools.cipher.lib.characters.CharArrayWrapper;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.lib.parallel.MasterThread;
import tools.cipher.lib.result.DynamicResultList;
import tools.cipher.lib.result.Result;
import tools.cipher.lib.result.ResultPositive;
import tools.cipher.lib.stats.StatIC;
import tools.cipher.util.ReadMode;

public class ADFGXAttack
extends CipherAttack<TriKey<String, Integer[], ReadMode>, ADFGXCipher> {
    public final CharSequence alphabet;
    public final CharSequence charHolders;

    public ADFGXAttack() {
        super((ICipher)new ADFGXCipher(), "ADFGX");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY});
        this.alphabet = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
        this.charHolders = "ADFGX";
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)5, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setRange(values)))});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"read_mode", (Object[])ReadMode.values(), (value, cipher) -> cipher.setThirdKeyDomain(builder -> builder.setUniverse((Enum[])new ReadMode[]{value})))});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        ADFGXTracker tracker = new ADFGXTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                IKeyType orderedKey = ((ADFGXCipher)this.getCipher()).getSecondKeyType();
                app.getProgress().addMax(orderedKey.getNumOfKeys());
                if (((Boolean)SettingsCache.useParallel.get()).booleanValue()) {
                    MasterThread thread = new MasterThread(control -> orderedKey.iterateKeys(key -> {
                        Integer[] keyCopy = (Integer[])ArrayUtil.copy((Object[])key);
                        Runnable job = () -> tracker.onPermute(keyCopy);
                        return !control.tryAddJob(job, 20L).end();
                    }));
                    thread.start();
                    thread.waitTillCompleted(() -> ((ADFGXTracker)tracker).shouldStop());
                } else {
                    orderedKey.iterateKeys(tracker::onPermute);
                }
                tracker.getProgress().finish();
                if (tracker.resultsList.size() < 1) {
                    this.output((IDecryptionTracker)tracker, "No transposition order with good digraph %cIC found.", new Object[]{Character.valueOf('\u0394')});
                    return null;
                }
                this.output((IDecryptionTracker)tracker, "Found %d transposition orders with good digraph %cIC.", new Object[]{tracker.resultsList.size(), Character.valueOf('\u0394')});
                tracker.resultsList.sort();
                int iterSA = 3;
                this.output((IDecryptionTracker)tracker, "Running %d SA iterations per result", new Object[]{iterSA});
                Iterator iterator = tracker.resultsList.iterator();
                while (iterator.hasNext() && !tracker.shouldStop()) {
                    ADFGXResult section = (ADFGXResult)((Object)iterator.next());
                    char[] tempText = new char[section.decrypted.length / 2];
                    for (int r = 0; r < this.charHolders.length(); ++r) {
                        for (int c = 0; c < this.charHolders.length(); ++c) {
                            for (int d = 0; d < section.decrypted.length; d += 2) {
                                if (section.decrypted[d] != this.charHolders.charAt(r) || section.decrypted[d + 1] != this.charHolders.charAt(c)) continue;
                                tempText[d / 2] = this.alphabet.charAt(r * this.charHolders.length() + c);
                            }
                        }
                    }
                    CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIKLMNOPQRSTUVWXYZ"), "ADFGX Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(iterSA).addCallback((CipherAttack)this).mute();
                    IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(tempText), DecryptionMethod.SIMULATED_ANNEALING, app);
                    this.updateIfBetterThanBest((IDecryptionTracker)tracker, keywordTracker.getBestSolution());
                    keywordTracker.getProgress().reset();
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public static class ADFGXResult
    extends ResultPositive {
        public char[] decrypted;
        public Integer[] order;

        public ADFGXResult(char[] decrypted, ILanguage language, Integer[] inverseCol) {
            super(Math.abs(StatIC.calculate((CharSequence)new CharArrayWrapper(decrypted), (int)2, (boolean)false) - language.getNormalisedIC()) * 1000.0);
            this.decrypted = decrypted;
            this.order = inverseCol;
        }

        public String toString() {
            if (this.decrypted.length > 100) {
                int i;
                char[] printDecrypt = new char[105];
                for (i = 0; i < 50; ++i) {
                    printDecrypt[i] = this.decrypted[i];
                }
                printDecrypt[50] = 32;
                printDecrypt[51] = 46;
                printDecrypt[52] = 46;
                printDecrypt[53] = 46;
                printDecrypt[54] = 32;
                for (i = 0; i < 50; ++i) {
                    printDecrypt[i + 55] = this.decrypted[this.decrypted.length - 51 + i];
                }
                return String.format("%s, %f, %s", Arrays.toString((Object[])this.order), this.score, new String(printDecrypt));
            }
            return String.format("%s, %f, %s", Arrays.toString((Object[])this.order), this.score, new String(this.decrypted));
        }

        public int compareTo(Result other) {
            int value = super.compareTo(other);
            return value == 0 ? Integer.compare(this.order.length, ((ADFGXResult)other).order.length) : value;
        }
    }

    public class ADFGXTracker
    extends DecryptionTracker {
        public final ColumnarTranspositionCipher transCipher;
        private DynamicResultList<ADFGXResult> resultsList;

        public ADFGXTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.resultsList = new DynamicResultList(256);
            this.transCipher = new ColumnarTranspositionCipher();
        }

        public boolean onPermute(Integer[] data) {
            if (this.shouldStop()) {
                return false;
            }
            char[] decrypted = new char[this.getOutputTextLength(this.getCipherText().length())];
            ((ADFGXCipher)ADFGXAttack.this.getCipher()).getThirdKeyType().iterateKeys(readMode -> {
                if (this.shouldStop()) {
                    return false;
                }
                this.transCipher.decodeEfficiently(this.getCipherText(), decrypted, (BiKey<Integer[], ReadMode>)BiKey.of((Object)data, (Object)readMode));
                ADFGXResult section = new ADFGXResult(decrypted, this.getLanguage(), Arrays.copyOf(data, data.length));
                if (this.resultsList.add((Result)section) && section.score < 5.0) {
                    ADFGXAttack.this.output((IDecryptionTracker)this, section.toString(), new Object[0]);
                }
                this.getProgress().increment();
                return true;
            });
            return true;
        }
    }
}

