/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.QuadKey;
import tools.cipher.base.ciphers.QuadKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.IntegerKeyType;
import tools.cipher.base.key.types.ObjectKeyType;
import tools.cipher.ciphers.route.RouteCipherType;
import tools.cipher.ciphers.route.Routes;
import tools.cipher.lib.characters.CharArrayWrapper;

public class RouteTranspositionCipher
extends QuadKeyCipher<Integer, Integer, RouteCipherType, RouteCipherType, IntegerKeyType.Builder, IntegerKeyType.Builder, ObjectKeyType.Builder<RouteCipherType>, ObjectKeyType.Builder<RouteCipherType>> {
    public RouteTranspositionCipher() {
        super((IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)ObjectKeyType.builder().setUniverse((Object[])Routes.getRoutes().toArray(new RouteCipherType[0])), (IKeyType.IKeyBuilder)ObjectKeyType.builder().setUniverse((Object[])Routes.getRoutes().toArray(new RouteCipherType[0])));
    }

    public CharSequence normaliseText(CharSequence plainText, QuadKey<Integer, Integer, RouteCipherType, RouteCipherType> key) {
        int blockSize = (Integer)key.getFirstKey() * (Integer)key.getSecondKey();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public IKeyType.IKeyBuilder<Integer> limitDomainForFirstKey(IntegerKeyType.Builder firstKey) {
        return firstKey.setRange(1, 100);
    }

    public IKeyType.IKeyBuilder<Integer> limitDomainForSecondKey(IntegerKeyType.Builder secondKey) {
        return secondKey.setRange(1, 100);
    }

    public CharSequence encode(CharSequence plainText, QuadKey<Integer, Integer, RouteCipherType, RouteCipherType> key) {
        int[] gridWrite = ((RouteCipherType)key.getThirdKey()).getPattern((Integer)key.getFirstKey(), (Integer)key.getSecondKey(), plainText.length());
        int[] gridRead = ((RouteCipherType)key.getFourthKey()).getPattern((Integer)key.getFirstKey(), (Integer)key.getSecondKey(), plainText.length());
        char[] gridString = new char[plainText.length()];
        for (int i = 0; i < plainText.length(); ++i) {
            gridString[gridWrite[i]] = plainText.charAt(i);
        }
        char[] gridString2 = new char[plainText.length()];
        for (int i = 0; i < plainText.length(); ++i) {
            gridString2[i] = gridString[gridRead[i]];
        }
        return new CharArrayWrapper(gridString2);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, QuadKey<Integer, Integer, RouteCipherType, RouteCipherType> key) {
        int i;
        int[] gridWrite = ((RouteCipherType)key.getThirdKey()).getPattern((Integer)key.getFirstKey(), (Integer)key.getSecondKey(), cipherText.length());
        int[] gridRead = ((RouteCipherType)key.getFourthKey()).getPattern((Integer)key.getFirstKey(), (Integer)key.getSecondKey(), cipherText.length());
        char[] gridString = new char[cipherText.length()];
        for (i = 0; i < cipherText.length(); ++i) {
            gridString[gridRead[i]] = cipherText.charAt(i);
        }
        for (i = 0; i < cipherText.length(); ++i) {
            plainText[i] = gridString[gridWrite[i]];
        }
        return plainText;
    }
}

