/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers.route;

import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import tools.cipher.ciphers.route.ColumnRoute;
import tools.cipher.ciphers.route.OtherLetterCycleRoute;
import tools.cipher.ciphers.route.RouteCipherType;
import tools.cipher.ciphers.route.RouteTwist;
import tools.cipher.ciphers.route.RowRoute;
import tools.cipher.lib.ListUtil;

public class Routes {
    public static List<RouteCipherType> ROUTES = new ArrayList<RouteCipherType>();
    public static RouteCipherSpiral SPIRAL_CLOCKWISE_TOPRIGHT = new RouteCipherSpiral("Spiral inwards, clockwise, starting from the top right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, 0, 0, 1};
        }

        @Override
        public boolean isClockwise() {
            return true;
        }
    };
    public static RouteCipherSpiral SPIRAL_CLOCKWISE_TOPLEFT = new RouteCipherSpiral("Spiral inwards, clockwise, starting from the top left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 0, 1, 0};
        }

        @Override
        public boolean isClockwise() {
            return true;
        }
    };
    public static RouteCipherSpiral SPIRAL_CLOCKWISE_BOTLEFT = new RouteCipherSpiral("Spiral inwards, clockwise, starting from the bot left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, height - 1, 0, -1};
        }

        @Override
        public boolean isClockwise() {
            return true;
        }
    };
    public static RouteCipherSpiral SPIRAL_CLOCKWISE_BOTRIGHT = new RouteCipherSpiral("Spiral inwards, clockwise, starting from the bot right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, height - 1, -1, 0};
        }

        @Override
        public boolean isClockwise() {
            return true;
        }
    };
    public static RouteCipherSpiral SPIRAL_ANTICLOCKWISE_TOPRIGHT = new RouteCipherSpiral("Spiral inwards, anit-clockwise, starting from the top right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, 0, -1, 0};
        }

        @Override
        public boolean isClockwise() {
            return false;
        }
    };
    public static RouteCipherSpiral SPIRAL_ANTICLOCKWISE_TOPLEFT = new RouteCipherSpiral("Spiral inwards, anit-clockwise, starting from the top left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 0, 0, 1};
        }

        @Override
        public boolean isClockwise() {
            return false;
        }
    };
    public static RouteCipherSpiral SPIRAL_ANTICLOCKWISE_BOTLEFT = new RouteCipherSpiral("Spiral inwards, anit-clockwise, starting from the bot left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, height - 1, 1, 0};
        }

        @Override
        public boolean isClockwise() {
            return false;
        }
    };
    public static RouteCipherSpiral SPIRAL_ANTICLOCKWISE_BOTRIGHT = new RouteCipherSpiral("Spiral inwards, anit-clockwise, starting from the bot right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, height - 1, 0, -1};
        }

        @Override
        public boolean isClockwise() {
            return false;
        }
    };
    public static RouteCipherSnakeHorzi SNAKE_LEFTTORIGHT_TOP = new RouteCipherSnakeHorzi("Snake left to right, starting from the top."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 1};
        }

        @Override
        public boolean isLeftToRight() {
            return true;
        }
    };
    public static RouteCipherSnakeHorzi SNAKE_LEFTTORIGHT_BOT = new RouteCipherSnakeHorzi("Snake left to right, starting from the bot."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{height - 1, -1};
        }

        @Override
        public boolean isLeftToRight() {
            return true;
        }
    };
    public static RouteCipherSnakeHorzi SNAKE_RIGHTTOLEFT_TOP = new RouteCipherSnakeHorzi("Snake right to left, starting from the top."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 1};
        }

        @Override
        public boolean isLeftToRight() {
            return false;
        }
    };
    public static RouteCipherSnakeHorzi SNAKE_RIGHTTOLEFT_BOT = new RouteCipherSnakeHorzi("Snake right to left, starting from the bot."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{height - 1, -1};
        }

        @Override
        public boolean isLeftToRight() {
            return false;
        }
    };
    public static RouteCipherSnakeVerti SNAKE_TOPTOBOTTOM_LEFT = new RouteCipherSnakeVerti("Snake top to bottom, starting from the left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 1};
        }

        @Override
        public boolean isTopToBottom() {
            return true;
        }
    };
    public static RouteCipherSnakeVerti SNAKE_TOPTOBOTTOM_RIGHT = new RouteCipherSnakeVerti("Snake top to bottom, starting from the right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, -1};
        }

        @Override
        public boolean isTopToBottom() {
            return true;
        }
    };
    public static RouteCipherSnakeVerti SNAKE_BOTTOMTOTOP_LEFT = new RouteCipherSnakeVerti("Snake bottom to top, starting from the left."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{0, 1};
        }

        @Override
        public boolean isTopToBottom() {
            return false;
        }
    };
    public static RouteCipherSnakeVerti SNAKE_BOTTOMTOTOP_RIGHT = new RouteCipherSnakeVerti("Snake bottom to top, starting from the right."){

        @Override
        public int[] getStartDetails(int width, int height, int totalSize) {
            return new int[]{width - 1, -1};
        }

        @Override
        public boolean isTopToBottom() {
            return false;
        }
    };
    public static RouteCipherDiagonal DIAG_BOTTOMTOTOP_LEFT = new RouteCipherDiagonal("Diagonal bottom to top, starting from the left."){

        @Override
        public int[] calculateNewPos(int pos, int height, int width, int totalSize) {
            return new int[]{Math.max(0, pos - height + 1), Math.min(pos, height - 1)};
        }

        @Override
        public int[] getDirVector(int pos) {
            return new int[]{1, -1};
        }
    };
    public static RouteCipherDiagonal DIAG_BOTTOMTOTOP_RIGHT = new RouteCipherDiagonal("Diagonal bottom to top, starting from the right."){

        @Override
        public int[] calculateNewPos(int pos, int height, int width, int totalSize) {
            return new int[]{Math.min(width - 1, height + width - 1 - pos - 1), Math.min(pos, height - 1)};
        }

        @Override
        public int[] getDirVector(int pos) {
            return new int[]{-1, -1};
        }
    };
    public static RouteCipherDiagonal DIAG_TOPTOBOTTOM_LEFT = new RouteCipherDiagonal("Diagonal top to bottom, starting from the left."){

        @Override
        public int[] calculateNewPos(int pos, int height, int width, int totalSize) {
            return new int[]{Math.max(0, pos - height + 1), height - 1 - Math.min(pos, height - 1)};
        }

        @Override
        public int[] getDirVector(int pos) {
            return new int[]{1, 1};
        }
    };
    public static RouteCipherDiagonal DIAG_TOPTOBOTTOM_RIGHT = new RouteCipherDiagonal("Diagonal top to bottom, starting from the right."){

        @Override
        public int[] calculateNewPos(int pos, int height, int width, int totalSize) {
            return new int[]{Math.min(width - 1, height + width - 1 - pos - 1), height - 1 - Math.min(pos, height - 1)};
        }

        @Override
        public int[] getDirVector(int pos) {
            return new int[]{-1, 1};
        }
    };
    public static RouteCipherDiagonal DIAG_ALTER_TOPLEFT = new RouteCipherDiagonal("Alter Diagonal top to bottom start, starting from the right."){

        @Override
        public int[] calculateNewPos(int pos, int height, int width, int totalSize) {
            if (pos % 2 == 0) {
                return new int[]{Math.max(0, pos - height + 1), Math.min(pos, height - 1)};
            }
            return new int[]{Math.min(pos, width - 1), Math.max(0, pos - width + 1)};
        }

        @Override
        public int[] getDirVector(int pos) {
            if (pos % 2 == 0) {
                return new int[]{1, -1};
            }
            return new int[]{-1, 1};
        }
    };
    public static RouteCipherRandom RANDOM = new RouteCipherRandom("Totally random.");
    public static RouteCipherType ACROSS_1 = new RowRoute.TopLeft();
    public static RouteCipherType ACROSS_2 = new RowRoute.TopRight();
    public static RouteCipherType ACROSS_3 = new RowRoute.BottomLeft();
    public static RouteCipherType ACROSS_4 = new RowRoute.BottomRight();
    public static RouteCipherType DOWN_1 = new ColumnRoute.TopLeft();
    public static RouteCipherType DOWN_2 = new ColumnRoute.TopRight();
    public static RouteCipherType DOWN_3 = new ColumnRoute.BottomLeft();
    public static RouteCipherType DOWN_4 = new ColumnRoute.BottomRight();
    public static OtherLetterCycleRoute OTHER_LETTER = new OtherLetterCycleRoute("Other letter route.");
    public static RouteTwist TWIST = new RouteTwist(1);

    public static List<RouteCipherType> getRoutes() {
        return ROUTES;
    }

    public static class RouteCipherRandom
    extends RouteCipherType {
        public RouteCipherRandom(String description) {
            super(description);
        }

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            return ArrayUtil.shuffle((int[])ArrayUtil.createRange((int)totalSize));
        }
    }

    public static class RouteCipherStrips
    extends RouteCipherType {
        public RouteCipherStrips(String description) {
            super(description);
        }

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            int[] grid = new int[totalSize];
            return grid;
        }
    }

    public static abstract class RouteCipherDiagonal
    extends RouteCipherType {
        public RouteCipherDiagonal(String description) {
            super(description);
        }

        public abstract int[] calculateNewPos(int var1, int var2, int var3, int var4);

        public abstract int[] getDirVector(int var1);

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            int[] grid = new int[totalSize];
            int index = 0;
            for (int pos = 0; pos < height + width - 1; ++pos) {
                int[] npos = this.calculateNewPos(pos, height, width, totalSize);
                int nx = npos[0];
                int[] dirVec = this.getDirVector(pos);
                for (int ny = npos[1]; nx >= 0 && nx < width && ny >= 0 && ny < height; nx += dirVec[0], ny += dirVec[1]) {
                    grid[index++] = ny * width + nx;
                }
            }
            return grid;
        }
    }

    public static abstract class RouteCipherSnakeVerti
    extends RouteCipherType {
        public RouteCipherSnakeVerti(String description) {
            super(description);
        }

        public abstract int[] getStartDetails(int var1, int var2, int var3);

        public abstract boolean isTopToBottom();

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            int[] grid = new int[totalSize];
            int[] details = this.getStartDetails(width, height, totalSize);
            int startX = details[0];
            int dir = details[1];
            boolean topToBottom = this.isTopToBottom();
            int index = 0;
            for (int y = 0; y < height; ++y) {
                int ny = topToBottom ? y : height - y - 1;
                for (int x = 0; x < width; ++x) {
                    grid[index++] = ny * width + (startX + dir * x);
                }
                startX = MathUtil.mod((int)(startX + (dir *= -1)), (int)width);
            }
            return grid;
        }
    }

    public static abstract class RouteCipherSnakeHorzi
    extends RouteCipherType {
        public RouteCipherSnakeHorzi(String description) {
            super(description);
        }

        public abstract int[] getStartDetails(int var1, int var2, int var3);

        public abstract boolean isLeftToRight();

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            int[] grid = new int[totalSize];
            int index = 0;
            int[] details = this.getStartDetails(width, height, totalSize);
            int startY = details[0];
            int dir = details[1];
            boolean leftToRight = this.isLeftToRight();
            for (int x = 0; x < width; ++x) {
                int nx = leftToRight ? x : width - x - 1;
                for (int y = 0; y < height; ++y) {
                    grid[index++] = (startY + dir * y) * width + nx;
                }
                startY = MathUtil.mod((int)(startY + (dir *= -1)), (int)height);
            }
            return grid;
        }
    }

    public static abstract class RouteCipherSpiral
    extends RouteCipherType {
        public RouteCipherSpiral(String description) {
            super(description);
        }

        public abstract int[] getStartDetails(int var1, int var2, int var3);

        public abstract boolean isClockwise();

        @Override
        public int[] createPattern(int width, int height, int totalSize) {
            ArrayList<Integer> grid = new ArrayList<Integer>();
            int[] details = this.getStartDetails(width, height, totalSize);
            int x = details[0];
            int y = details[1];
            int dx = details[2];
            int dy = details[3];
            boolean clockwise = this.isClockwise();
            while (grid.size() < totalSize) {
                grid.add(y * width + x);
                int nx = x + dx;
                int ny = y + dy;
                if (nx < 0 || nx >= width || ny < 0 || ny >= height || grid.contains(ny * width + nx)) {
                    int temp = dy;
                    dy = (clockwise ? 1 : -1) * dx;
                    dx = (clockwise ? -1 : 1) * temp;
                }
                x += dx;
                y += dy;
            }
            return ListUtil.toArray(grid);
        }
    }
}

