/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.IntegerKeyType;
import tools.cipher.lib.CipherUtils;

public class CaesarCipher
extends UniKeyCipher<Integer, IntegerKeyType.Builder> {
    public CaesarCipher() {
        super((IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, 25));
    }

    public CharSequence encode(CharSequence plainText, Integer key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            byte ch = CipherUtils.getAlphaIndex((char)plainText.charAt(i));
            if (ch == -1) continue;
            char newLetter = (char)((ch + key) % 26 + 65);
            cipherText.append(newLetter);
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, Integer key) {
        for (int i = 0; i < cipherText.length(); ++i) {
            byte ch = CipherUtils.getAlphaIndex((char)cipherText.charAt(i));
            plainText[i] = ch == -1 ? cipherText.charAt(i) : (char)((ch + 26 - key) % 26 + 65);
        }
        return plainText;
    }
}

