/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import com.alexbarter.lib.util.ArrayUtil;
import javax.annotation.Nullable;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.ciphers.BiKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.EnumKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.util.AMSCOType;

public class AMSCOCipher
extends BiKeyCipher<Integer[], AMSCOType, OrderedIntegerKeyType.Builder, EnumKeyType.Builder<AMSCOType>> {
    public AMSCOCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(1, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)EnumKeyType.builder(AMSCOType.class).setUniverse((Enum[])AMSCOType.values()));
    }

    public IKeyType.IKeyBuilder<Integer[]> limitDomainForFirstKey(OrderedIntegerKeyType.Builder firstKey) {
        return firstKey.setRange(2, 9);
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer[], AMSCOType> key) {
        StringBuilder[] columns = (StringBuilder[])ArrayUtil.fill((Object[])new StringBuilder[((Integer[])key.getFirstKey()).length], () -> new StringBuilder(plainText.length() / ((Integer[])key.getFirstKey()).length));
        int index = 0;
        int row = 0;
        while (index < plainText.length()) {
            for (int col = 0; col < ((Integer[])key.getFirstKey()).length && index < plainText.length(); ++col) {
                int fromIndex = index;
                index += (col + row) % 2 == ((AMSCOType)((Object)key.getSecondKey())).getMod() ? 2 : 1;
                for (int i = fromIndex; i < Math.min(index, plainText.length()); ++i) {
                    columns[((Integer[])key.getFirstKey())[col]].append(plainText.charAt(i));
                }
            }
            ++row;
        }
        StringBuilder read = new StringBuilder(plainText.length());
        for (int i = 0; i < ((Integer[])key.getFirstKey()).length; ++i) {
            read.append((CharSequence)columns[i]);
        }
        return read;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer[], AMSCOType> key) {
        int n;
        Integer[] order = (Integer[])key.getFirstKey();
        int period = order.length;
        int[] reversedOrder = new int[order.length];
        for (int i = 0; i < order.length; ++i) {
            reversedOrder[order[i].intValue()] = i;
        }
        int noChar1st = (period + 1) / 2 * 2 + period / 2;
        int noChar2nd = (period + 1) / 2 + period / 2 * 2;
        int rows = 0;
        int charactersLastRow = 0;
        boolean choose = key.getSecondKey() == AMSCOType.DOUBLE_FIRST;
        int chars = 0;
        do {
            charactersLastRow = chars;
            n = choose ? noChar1st : noChar2nd;
            ++rows;
            boolean bl = choose = !choose;
        } while ((chars += n) < cipherText.length());
        charactersLastRow = plainText.length - charactersLastRow;
        int noCharColumn1st = (rows - 1) / 2 + rows / 2 * 2;
        int noCharColumn2nd = (rows - 1) / 2 * 2 + rows / 2;
        int index = 0;
        CharSequence[] grid = new CharSequence[period];
        for (int column = 0; column < period; ++column) {
            int realColumn = reversedOrder[column];
            boolean isDoubleLetter = (realColumn + rows) % 2 == ((AMSCOType)((Object)key.getSecondKey())).getMod();
            int length = isDoubleLetter ? noCharColumn1st : noCharColumn2nd;
            int noCharN1st = (realColumn + 1) / 2 * 2 + realColumn / 2;
            int noCharN2nd = (realColumn + 1) / 2 + realColumn / 2 * 2;
            int left = charactersLastRow - (isDoubleLetter ? noCharN1st : noCharN2nd);
            if (left > 0) {
                length += isDoubleLetter ? 1 : Math.min(2, left);
            }
            grid[realColumn] = cipherText.subSequence(index, index + length);
            index += length;
        }
        int[] indexTracker = new int[period];
        int textIndex = 0;
        for (int row = 0; row < rows; ++row) {
            int column = 0;
            while (column < period) {
                int number = (column + row) % 2 == ((AMSCOType)((Object)key.getSecondKey())).getMod() ? 2 : 1;
                for (int i = 0; i < number && indexTracker[column] + i < grid[column].length(); ++i) {
                    plainText[textIndex] = grid[column].charAt(indexTracker[column] + i);
                    ++textIndex;
                }
                int n2 = column++;
                indexTracker[n2] = indexTracker[n2] + number;
            }
        }
        return plainText;
    }
}

