/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.HillExtendedCipher;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.ciphertool.lib.matrix.MatrixNoInverse;
import com.alexbarter.ciphertool.lib.matrix.MatrixNotSquareException;
import com.alexbarter.ciphertool.lib.result.DynamicResultList;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.stats.StatIC;
import com.alexbarter.ciphertool.solve.HillAttack;
import com.alexbarter.lib.util.MathUtil;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class HillSubsitutionAttack
extends CipherAttack<BiKey<Matrix, Matrix>, HillExtendedCipher> {
    private int[] sizeRange = new int[]{2, 4};

    public HillSubsitutionAttack() {
        super((ICipher)new HillExtendedCipher(), "Hill Subsitution");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.CALCULATED, DecryptionMethod.PERIODIC_KEY, DecryptionMethod.SIMULATED_ANNEALING});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"size_range", (int)2, (int)4, (int)2, (int)100, (int)1, (values, cipher) -> {
            this.sizeRange = values;
        })});
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        super.createSettingsUI(dialog, panel);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        HillTracker tracker = new HillTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int size = this.sizeRange[0]; size <= this.sizeRange[1]; ++size) {
                    tracker.resultList.clear();
                    if (tracker.getCipherText().length() % size != 0) {
                        this.output((IDecryptionTracker)tracker, "Matrix size of %d is not possible, length of text is not a multiple.", new Object[]{size});
                        continue;
                    }
                    tracker.size = size;
                    tracker.lengthSub = tracker.getCipherText().length() / size;
                    KeyIterator.iterateIntegerArray(row -> this.iterateMatrixRows(tracker, (Integer[])row), (int)size, (int)26, (boolean)true);
                    tracker.resultList.sort();
                    if (tracker.resultList.size() < size) {
                        this.output((IDecryptionTracker)tracker, "Did not find enought key columns that produces good characters %d/%d", new Object[]{tracker.resultList.size(), size});
                        continue;
                    }
                    this.output((IDecryptionTracker)tracker, "Trying all combinations...", new Object[0]);
                    this.output((IDecryptionTracker)tracker, "Removing trials that have no inverse...", new Object[0]);
                    this.output((IDecryptionTracker)tracker, "Removing trials with %cIC less than 10...", new Object[]{Character.valueOf('\u0394')});
                    KeyIterator.iterateObject(row -> this.iteratePossibleRows(tracker, (HillAttack.HillSection[])row), (int)size, (Object[])tracker.resultList.toArray((Object[])new HillAttack.HillSection[0]));
                    tracker.bestNext.sort();
                    for (HillAttack.HillSection section : tracker.bestNext) {
                        CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "Hill Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(5).mute();
                        IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(section.decrypted), DecryptionMethod.SIMULATED_ANNEALING, app);
                        this.updateIfBetterThanBest((IDecryptionTracker)tracker, keywordTracker.getBestSolution());
                    }
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public void decryptAndUpdate(IDecryptionTracker tracker, BiKey<Matrix, Matrix> key) {
        try {
            super.decryptAndUpdate(tracker, key);
        }
        catch (MatrixNoInverse | MatrixNotSquareException e) {
            return;
        }
    }

    public boolean iterateMatrixRows(HillTracker tracker, Integer[] row) {
        if (MathUtil.allDivisibleBy((Integer[])row, (int)0, (int)tracker.size, (int[])new int[]{2, 13})) {
            return true;
        }
        char[] decrypted = new char[tracker.lengthSub];
        for (int i = 0; i < tracker.getCipherText().length(); i += tracker.size) {
            int total = 0;
            for (int s = 0; s < tracker.size; ++s) {
                total += row[s] * (tracker.getCipherText().charAt(i + s) - 65);
            }
            decrypted[i / ((HillTracker)tracker).size] = (char)(total % 26 + 65);
        }
        double score = Math.abs(StatIC.calculateMonoIC((char[])decrypted) - tracker.getLanguage().getNormalisedIC()) * 1000.0;
        if (tracker.resultList.add((Result)new HillAttack.HillSection(score, decrypted, Arrays.copyOf(row, row.length))) && score < 10.0) {
            this.output((IDecryptionTracker)tracker, "%s, %f, %s", new Object[]{Arrays.toString((Object[])row), score, new String(decrypted)});
        }
        return true;
    }

    public boolean iteratePossibleRows(HillTracker tracker, HillAttack.HillSection[] data) {
        Integer[] inverseData = new Integer[tracker.size * tracker.size];
        for (int s = 0; s < tracker.size; ++s) {
            HillAttack.HillSection hillResult = data[s];
            for (int n = 0; n < tracker.size; ++n) {
                inverseData[s * ((HillTracker)tracker).size + n] = hillResult.inverseCol[n];
            }
        }
        Matrix inverseMatrix = new Matrix(inverseData, tracker.size);
        if (!inverseMatrix.hasInverseMod(26)) {
            return true;
        }
        char[] combinedDecrypted = new char[tracker.getCipherText().length()];
        for (int s = 0; s < tracker.size; ++s) {
            HillAttack.HillSection hillSection = data[s];
            for (int i = 0; i < tracker.lengthSub; ++i) {
                combinedDecrypted[i * ((HillTracker)tracker).size + s] = hillSection.decrypted[i];
            }
        }
        double score = Math.abs(StatIC.calculateMonoIC((char[])combinedDecrypted) - tracker.getLanguage().getNormalisedIC()) * 1000.0;
        if (score < 10.0) {
            HillAttack.HillSection section = new HillAttack.HillSection(score, combinedDecrypted, inverseData);
            if (tracker.bestNext.add((Result)section)) {
                this.output((IDecryptionTracker)tracker, section.toString(), new Object[0]);
            }
        }
        return true;
    }

    public class HillTracker
    extends DecryptionTracker {
        private int size;
        private int lengthSub;
        private DynamicResultList<HillAttack.HillSection> resultList;
        private DynamicResultList<HillAttack.HillSection> bestNext;

        public HillTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.resultList = new DynamicResultList(8);
            this.bestNext = new DynamicResultList(8);
        }
    }
}

