/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.ciphers.TriKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.BooleanKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import java.util.Map;
import javax.annotation.Nullable;

public class PhillipsCipher
extends TriKeyCipher<String, Boolean, Boolean, SquareStringKeyType.Builder, BooleanKeyType.Builder, BooleanKeyType.Builder> {
    public static int[][] rows = new int[][]{{0, 1, 2, 3, 4}, {1, 0, 2, 3, 4}, {1, 2, 0, 3, 4}, {1, 2, 3, 0, 4}, {1, 2, 3, 4, 0}, {2, 1, 3, 4, 0}, {2, 3, 1, 4, 0}, {2, 3, 4, 1, 0}};
    public static int[][] rowsIndex = new int[][]{{0, 1, 2, 3, 4}, {1, 0, 2, 3, 4}, {2, 0, 1, 3, 4}, {3, 0, 1, 2, 4}, {4, 0, 1, 2, 3}, {4, 1, 0, 2, 3}, {4, 2, 0, 1, 3}, {4, 3, 0, 1, 2}};

    public PhillipsCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)BooleanKeyType.builder(), (IKeyType.IKeyBuilder)BooleanKeyType.builder());
    }

    public CharSequence normaliseText(CharSequence plainText, TriKey<String, Boolean, Boolean> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, Boolean, Boolean> key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            int squareIndex = i / 5 % rows.length;
            int[] order = rows[squareIndex];
            int[] orderIndex = rowsIndex[squareIndex];
            char ch = plainText.charAt(i);
            int index = ((String)key.getFirstKey()).indexOf(ch);
            int row = index / 5;
            int column = index % 5;
            int newRow = (Boolean)key.getSecondKey() != false ? order[(orderIndex[row] + 1) % 5] : (row + 1) % 5;
            int newColumn = (Boolean)key.getThirdKey() != false ? order[(orderIndex[column] + 1) % 5] : (column + 1) % 5;
            cipherText.append(((String)key.getFirstKey()).charAt(newRow * 5 + newColumn));
        }
        return new String(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, Boolean, Boolean> key) {
        Map keyIndex = CipherUtils.createCharacterIndexMapping((CharSequence)((CharSequence)key.getFirstKey()));
        for (int i = 0; i < cipherText.length(); ++i) {
            int squareIndex = i / 5 % rows.length;
            int[] order = rows[squareIndex];
            int[] orderIndex = rowsIndex[squareIndex];
            int index = (Integer)keyIndex.get(Character.valueOf(cipherText.charAt(i)));
            int row = index / 5;
            int column = index % 5;
            int newRow = (Boolean)key.getSecondKey() != false ? order[(orderIndex[row] + 4) % 5] : (row + 4) % 5;
            int newColumn = (Boolean)key.getThirdKey() != false ? order[(orderIndex[column] + 4) % 5] : (column + 4) % 5;
            plainText[i] = ((String)key.getFirstKey()).charAt(newRow * 5 + newColumn);
        }
        return plainText;
    }
}

