/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import javax.annotation.Nullable;

public class CaesarCipher
extends UniKeyCipher<Integer, IntegerKeyType.Builder> {
    public CaesarCipher() {
        super((IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, 25));
    }

    public CharSequence encode(CharSequence plainText, Integer key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            byte ch = CipherUtils.getAlphaIndex((char)plainText.charAt(i));
            if (ch == -1) continue;
            char newLetter = (char)((ch + key) % 26 + 65);
            cipherText.append(newLetter);
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, Integer key) {
        for (int i = 0; i < cipherText.length(); ++i) {
            byte ch = CipherUtils.getAlphaIndex((char)cipherText.charAt(i));
            plainText[i] = ch == -1 ? cipherText.charAt(i) : (char)((ch + 26 - key) % 26 + 65);
        }
        return plainText;
    }
}

