/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.IDictionaryAttack;
import com.alexbarter.ciphertool.ciphers.SolitaireCipher;
import com.alexbarter.ciphertool.ciphers.solitaire.DeckParse;
import com.alexbarter.ciphertool.ciphers.solitaire.Solitaire;
import com.alexbarter.ciphertool.ciphers.solitaire.SolitaireSolver;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.ciphertool.lib.ListUtil;
import com.alexbarter.ciphertool.lib.fitness.NGramData;
import com.alexbarter.ciphertool.lib.fitness.TextFitness;
import com.alexbarter.ciphertool.lib.swing.DocumentUtils;
import com.alexbarter.lib.util.MathUtil;
import java.math.BigInteger;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;

public class SolitaireAttack
extends CipherAttack<Integer[], SolitaireCipher>
implements IDictionaryAttack<Integer[]> {
    public static int[] deck2016 = new int[]{38, 34, 46, 3, 4, 41, 16, 51, 19, 12, 52, 15, 29, 39, 37, 33, 42, 13, 40, 6, 26, 43, 0, 5, 32, 14, 53, 35, 17, 23, 2, 8, 50, 36, 22, -1, -1, -1, -1, -1, -1, -1, -1, 24, -1, -1, -1, -1, -1, -1, 31, -1, 28, -1};
    private int[] periodRange;
    private JTextField passKeyStartingOrder;
    private JTextField charactersToDecode;
    private JTextField passKeyIterateOrder;

    public SolitaireAttack() {
        super((ICipher)new SolitaireCipher(), "Solitaire");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.PERIODIC_KEY, DecryptionMethod.DICTIONARY, DecryptionMethod.CALCULATED});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"key_period", (int)2, (int)6, (int)1, (int)25, (int)1, (range, cipher) -> {
            this.periodRange = range;
        })});
        this.passKeyStartingOrder = new JTextField("0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53");
        this.charactersToDecode = new JTextField("100");
        this.passKeyIterateOrder = new JTextField("0,*,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53");
        Object[] args = new String[]{"Forwards", "Backwards"};
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"iteration_direction", (Object[])args, (value, cipher) -> {})});
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        super.createSettingsUI(dialog, panel);
        ((AbstractDocument)this.charactersToDecode.getDocument()).setDocumentFilter(DocumentUtils.createTextFilter((String)"[^0-9*,]"));
        ((AbstractDocument)this.passKeyIterateOrder.getDocument()).setDocumentFilter(DocumentUtils.createTextFilter((String)"[^0-9*,]"));
        JLabel suitOrder = new JLabel("\u2663 \u25c6 \u2665 \u2660");
        suitOrder.setFont(suitOrder.getFont().deriveFont(20.0f));
        panel.add(this.passKeyStartingOrder);
        panel.add(this.charactersToDecode);
        panel.add(this.passKeyIterateOrder);
        panel.add(suitOrder.add(new JLabel("Club | Diamond | Heart | Spade")));
    }

    public DecryptionTracker tryBruteForce(IDecryptionTracker trackerIn) {
        SolitaireTracker tracker = (SolitaireTracker)trackerIn;
        DeckParse deck = new DeckParse(this.passKeyIterateOrder.getText());
        this.output((IDecryptionTracker)tracker, "Deck Size: %d", new Object[]{deck.order.length});
        this.output((IDecryptionTracker)tracker, "Current known order: " + ListUtil.toString((Integer[])deck.order), new Object[0]);
        this.output((IDecryptionTracker)tracker, "Current known order: " + ListUtil.toString((Integer[])deck.order, (int)1), new Object[0]);
        this.output((IDecryptionTracker)tracker, "No of unknowns (%d), permutations - %s", new Object[]{deck.countUnknowns(), CipherUtils.formatBigInteger((BigInteger)MathUtil.factorialBig((int)deck.countUnknowns()))});
        if (!deck.isDeckComplete()) {
            tracker.incompleteOrder = deck.order;
            tracker.emptyIndex = deck.emptyIndex;
            this.output((IDecryptionTracker)tracker, "Left: %s", new Object[]{Arrays.toString((Object[])deck.unknownCards)});
            tracker.getProgress().addMax(MathUtil.factorialBig((int)deck.countUnknowns()));
            KeyIterator.permuteObject(order -> this.decodeIncomplete(tracker, (Integer[])order), (Object[])deck.unknownCards);
        } else {
            this.output((IDecryptionTracker)tracker, "Decrypting...\n%s", new Object[]{((SolitaireCipher)this.getCipher()).decode(tracker.getCipherText(), deck.order)});
        }
        return tracker;
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case DICTIONARY: {
                return this.tryDictionaryAttack((IDecryptionTracker)this.createTracker(text, app));
            }
            case PERIODIC_KEY: {
                DecryptionTracker tracker = this.createTracker(text, app);
                IKeyType keyGen = VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(this.periodRange).create();
                app.getProgress().addMax(keyGen.getNumOfKeys());
                keyGen.iterateKeys(keyword -> {
                    this.decryptAndUpdate((IDecryptionTracker)tracker, this.useWordToGetKey(tracker, (String)keyword));
                    tracker.getProgress().increment();
                    return !app.shouldStop();
                });
                return tracker;
            }
            case CALCULATED: {
                text = text.subSequence(0, Math.min(100, text.length()));
                SolitaireSolver.startCompleteAttack(text, 7, 1280, new DeckParse(this.passKeyStartingOrder.getText()), app.out(), 0);
                return null;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public boolean decodeIncomplete(SolitaireTracker tracker, Integer[] order) {
        for (int i = 0; i < tracker.emptyIndex.length; ++i) {
            tracker.incompleteOrder[tracker.emptyIndex[tracker.direction ? i : tracker.emptyIndex.length - i - 1].intValue()] = order[i];
        }
        this.decryptAndUpdate((IDecryptionTracker)tracker, tracker.incompleteOrder);
        return !tracker.shouldStop();
    }

    public char[] decode(char[] cipherText, Integer[] cardOrder, double bestScore, NGramData quadgramData) {
        double score = 0.0;
        int length = cipherText.length;
        char[] plainText = new char[length];
        int index = 0;
        while (index < length) {
            int keyStreamNumber;
            int topCard = (cardOrder = Solitaire.nextCardOrder(cardOrder))[0];
            if (topCard == 53) {
                topCard = 52;
            }
            if (Solitaire.isJoker(keyStreamNumber = cardOrder[topCard + 1].intValue())) continue;
            plainText[index] = (char)((52 + (cipherText[index] - 65) - (keyStreamNumber + 1)) % 26 + 65);
            if (++index <= 3 || !((score += TextFitness.scoreWord((char[])plainText, (int)(index - 4), (NGramData)quadgramData)) < bestScore)) continue;
            break;
        }
        return plainText;
    }

    public DecryptionTracker createTracker(CharSequence text, ICipherProgram app) {
        return new SolitaireTracker(text, app);
    }

    public Integer[] useWordToGetKey(DecryptionTracker tracker, String word) {
        return Solitaire.createCardOrder(word);
    }

    public class SolitaireTracker
    extends DecryptionTracker {
        public Integer[] incompleteOrder;
        public Integer[] emptyIndex;
        public boolean direction;

        public SolitaireTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
        }
    }
}

